/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.build.BuildExecutionManager;
import com.atlassian.bamboo.build.PlanResultsAction;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.persister.Persister;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.results.BuildResults;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResult;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.queue.BuildQueueManager;
import com.atlassian.bamboo.ww2.actions.BuildableAwareContextHolder;
import com.atlassian.bamboo.ww2.aware.BuildResultsAware;
import com.atlassian.bamboo.ww2.aware.BuildResultsSummaryAware;
import com.atlassian.bamboo.ww2.aware.BuildableAware;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import io.atlassian.util.concurrent.Lazy;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildResultsAction
extends PlanResultsAction
implements BuildableAware,
BuildResultsAware,
BuildResultsSummaryAware {
    protected BuildResults buildResults;
    protected BuildResultsSummary buildResultsSummary;
    protected BuildExecutionManager buildExecutionManager;
    private BuildQueueManager buildQueueManager;
    protected Persister persister;
    private BuildableAwareContextHolder buildableAwareContextHolder = new BuildableAwareContextHolder();
    private final Supplier<CurrentlyBuilding> currentlyBuilding = Lazy.supplier(() -> this.buildExecutionManager.getCurrentlyBuildingByPlanResultKey((ResultKey)this.getTypedPlanResultKey()));
    private final Supplier<List<BuildAgent>> executableAgents = Lazy.supplier(() -> {
        Set agentIds = (Set)MoreObjects.firstNonNull((Object)this.buildQueueManager.getExecutorsForQueuedExecutable((ResultKey)this.getTypedPlanResultKey()), Collections.emptySet());
        return agentIds.stream().map(arg_0 -> ((AgentManager)this.agentManager).getAgent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    });

    @Override
    @Nullable
    public ImmutableBuildable getImmutableBuild() {
        return this.buildableAwareContextHolder.getImmutableBuild();
    }

    @Override
    public void setBuild(ImmutableBuildable build) {
        this.buildableAwareContextHolder.setBuild(build);
    }

    public String getBuildResultKey() {
        return this.buildableAwareContextHolder.getBuildResultKey();
    }

    public void setBuildResultKey(String buildResultKey) {
        this.buildableAwareContextHolder.setBuildResultKey(buildResultKey);
    }

    @Override
    public BuildResults getBuildResults() {
        return this.buildResults;
    }

    @Override
    public void setBuildResults(BuildResults buildResults) {
        this.buildResults = buildResults;
    }

    @Override
    public BuildResultsSummary getBuildResultsSummary() {
        return this.buildResultsSummary;
    }

    @Override
    public void setBuildResultsSummary(BuildResultsSummary buildResultsSummary) {
        this.buildResultsSummary = buildResultsSummary;
        if (buildResultsSummary == null) {
            this.setBuildResultKey(null);
            this.setPlanResultKey(null);
        } else {
            this.setBuildResultKey(buildResultsSummary.getPlanResultKey().toString());
            this.setPlanResultKey(buildResultsSummary.getPlanResultKey().toString());
        }
    }

    @Deprecated
    public ImmutableChain getChain() {
        return this.getImmutableChain();
    }

    public ImmutableChain getImmutableChain() {
        return (ImmutableChain)this.cachedPlanManager.getPlanByKey(PlanKeys.getChainKeyFromJobKey((PlanKey)PlanKeys.getPlanKey((String)this.getPlanKey())), ImmutableChain.class);
    }

    public String execute() throws Exception {
        if (this.getBuildNumber() == null) {
            this.addActionError("Unable to get build result since buildNumber was not specified");
            return "error";
        }
        try {
            this.buildResults = this.getBuildResultsFromContainer(this.getBuildNumber(), this.getBuildKey());
            if (this.buildResults == null && this.buildResultsSummary == null) {
                return this.errorMessage(this.getBuildKey());
            }
            return "success";
        }
        catch (NumberFormatException e) {
            return this.errorMessage(this.getBuildKey());
        }
    }

    @Nullable
    protected BuildResults getBuildResultsFromContainer(int currentBuildNumber, String jobKey) {
        if (this.persister == null) {
            return null;
        }
        return this.persister.getBuildResults((Key)PlanKeys.getPlanKey((String)jobKey), currentBuildNumber);
    }

    @Nullable
    public BuildResultsSummary getFailingSinceForTest(@Nullable TestCaseResult testCaseResult) {
        int failingSinceBuildNumber;
        if (testCaseResult != null && (failingSinceBuildNumber = testCaseResult.getFailingSince()) != -1) {
            return (BuildResultsSummary)this.resultsSummaryManager.getResultsSummary(PlanKeys.getPlanResultKey((PlanKey)this.getTypedPlanKey(), (int)failingSinceBuildNumber), BuildResultsSummary.class);
        }
        return null;
    }

    @Nullable
    public String getFailingSinceForTestString(@Nullable BuildResultsSummary buildResultsSummary, @Nullable TestCaseResult testCaseResult) {
        int failingSinceBuildNumber;
        if (buildResultsSummary != null && testCaseResult != null && (failingSinceBuildNumber = testCaseResult.getFailingSince()) != -1) {
            return buildResultsSummary.getPlanKey() + "-" + failingSinceBuildNumber;
        }
        return null;
    }

    @NotNull
    public String getFailingSinceRelativeTime(@Nullable BuildResultsSummary buildResultsSummary, @Nullable BuildResultsSummary failingSinceSummary) {
        if (failingSinceSummary != null && buildResultsSummary != null) {
            return failingSinceSummary.getRelativeBuildDate(buildResultsSummary.getBuildDate());
        }
        return "";
    }

    @Nullable
    public BuildAgent getAgent(BuildResultsSummary summary) {
        if (summary != null) {
            return this.getAgent(summary.getBuildAgentId());
        }
        return null;
    }

    @Nullable
    public BuildAgent getAgent(@Nullable CurrentlyBuilding currentlyBuilding) {
        if (currentlyBuilding != null) {
            return this.getAgent(currentlyBuilding.getBuildAgentId());
        }
        return null;
    }

    @Nullable
    private BuildAgent getAgent(@Nullable Long agentId) {
        return agentId != null ? this.agentManager.getAgent(agentId.longValue()) : null;
    }

    protected String errorMessage(String name) {
        this.addActionError(this.getText("buildResult.error.summary.number.invalid", Lists.newArrayList((Object[])new Serializable[]{this.buildNumber, name})));
        return "error";
    }

    public CurrentlyBuilding getCurrentlyBuilding() {
        return this.currentlyBuilding.get();
    }

    public Collection<BuildAgent> getExecutableAgents() {
        return this.executableAgents.get();
    }

    public Collection<ElasticImageConfiguration> getExecutableElasticImages() {
        Collection imagesForQueuedExecutable = this.buildQueueManager.getImagesForQueuedExecutable((ResultKey)this.getTypedPlanResultKey());
        return (Collection)MoreObjects.firstNonNull((Object)imagesForQueuedExecutable, Collections.emptyList());
    }

    public void setBuildExecutionManager(BuildExecutionManager buildExecutionManager) {
        this.buildExecutionManager = buildExecutionManager;
    }

    public void setPersister(Persister persister) {
        this.persister = persister;
    }

    public void setBuildQueueManager(BuildQueueManager buildQueueManager) {
        this.buildQueueManager = buildQueueManager;
    }
}

