/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.author.collector;

import com.atlassian.bamboo.charts.collater.TimePeriodCollater;
import com.atlassian.bamboo.resultsummary.ResultStatisticsProvider;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.utils.Comparators;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.time.Week;
import org.jfree.data.time.Year;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public abstract class AbstractAuthorReportCollector {
    private static final Logger log = Logger.getLogger(AbstractAuthorReportCollector.class);
    private Map<String, String[]> params;
    private Map<String, List<ResultsSummary>> authorBuilds;

    public Dataset getDataSet() {
        TimeTableXYDataset dataset = new TimeTableXYDataset();
        for (Map.Entry<String, List<ResultsSummary>> mapEntry : this.authorBuilds.entrySet()) {
            dataset = this.populateDataSet((Collection<ResultsSummary>)mapEntry.getValue(), dataset, mapEntry.getKey());
        }
        return dataset;
    }

    protected TimeTableXYDataset populateDataSet(Collection<ResultsSummary> results, TimeTableXYDataset dataset, String seriesName) {
        if (!CollectionUtils.isEmpty(results)) {
            List sortedResults = Comparators.getBuildDateOrdering().sortedCopy(results);
            Date earliest = this.getEarliestBuildDate(sortedResults);
            Date latest = this.getLatestBuildDate(sortedResults);
            List<RegularTimePeriod> periods = this.getAllPeriodsBetweenDates(earliest, latest);
            for (RegularTimePeriod timePeriod : periods) {
                TimePeriodCollater collater = this.getCollater();
                collater.setPeriod(timePeriod);
                collater.setSeriesName(seriesName);
                for (ResultStatisticsProvider resultStatisticsProvider : results) {
                    if (!this.isInPeriod(timePeriod, resultStatisticsProvider.getStatDate())) continue;
                    collater.addResult(resultStatisticsProvider);
                }
                this.writeCollaterToDataSet(dataset, collater);
            }
        }
        return dataset;
    }

    protected abstract TimePeriodCollater getCollater();

    protected void writeCollaterToDataSet(TimeTableXYDataset dataset, TimePeriodCollater collater) {
        dataset.add((TimePeriod)collater.getPeriod(), collater.getValue(), collater.getSeriesName());
    }

    public String getPeriodRange() {
        String[] groupBy;
        String periodRange = "AUTO";
        if (this.params.containsKey("groupByPeriod") && (groupBy = this.params.get("groupByPeriod")) != null && groupBy.length > 0) {
            periodRange = groupBy[0];
        }
        if ("AUTO".equals(periodRange) && this.authorBuilds != null && !this.authorBuilds.isEmpty()) {
            Date startDate = null;
            Date lastDate = null;
            for (List<ResultsSummary> builds : this.authorBuilds.values()) {
                if (CollectionUtils.isEmpty(builds)) continue;
                ResultsSummary first = builds.get(0);
                ResultsSummary last = builds.get(builds.size() - 1);
                if (startDate == null || first.getStatDate().compareTo(startDate) < 0) {
                    startDate = first.getStatDate();
                }
                if (lastDate != null && last.getStatDate().compareTo(lastDate) <= 0) continue;
                lastDate = last.getStatDate();
            }
            periodRange = this.getAutoDate(startDate, lastDate);
        }
        return periodRange;
    }

    protected String getAutoDate(Date startDate, Date lastDate) {
        if (startDate == null || lastDate == null) {
            return "MONTH";
        }
        DateTime start = new DateTime((Object)startDate);
        Interval threeMonths = new Interval((ReadableInstant)start, (ReadablePeriod)Period.months((int)3));
        Interval threeWeeks = new Interval((ReadableInstant)start, (ReadablePeriod)Period.weeks((int)3));
        if (!threeMonths.contains(lastDate.getTime())) {
            return "MONTH";
        }
        if (!threeWeeks.contains(lastDate.getTime())) {
            return "WEEK";
        }
        return "DAY";
    }

    protected List<RegularTimePeriod> getAllPeriodsBetweenDates(Date earliest, Date latest) {
        RegularTimePeriod firstPeriod = this.getFirstPeriod(earliest, this.getPeriodRange());
        RegularTimePeriod lastPeriod = this.getLastPeriod(latest, this.getPeriodRange());
        RegularTimePeriod period = firstPeriod;
        ArrayList<RegularTimePeriod> periods = new ArrayList<RegularTimePeriod>();
        periods.add(firstPeriod);
        while (period.compareTo((Object)lastPeriod) < 0) {
            Date firstNextPeriod = new Date(period.getLastMillisecond() + 1L);
            RegularTimePeriod nextPeriod = this.getPeriod(firstNextPeriod, this.getPeriodRange());
            periods.add(nextPeriod);
            period = nextPeriod;
        }
        return periods;
    }

    @Nullable
    protected Date getEarliestBuildDate(List<? extends ResultStatisticsProvider> results) {
        ResultStatisticsProvider provider = (ResultStatisticsProvider)Iterables.getFirst(results, null);
        return provider != null ? provider.getStatDate() : null;
    }

    @Nullable
    protected Date getLatestBuildDate(List<? extends ResultStatisticsProvider> results) {
        ResultStatisticsProvider provider = (ResultStatisticsProvider)Iterables.getLast(results, null);
        return provider != null ? provider.getStatDate() : null;
    }

    protected boolean isInPeriod(RegularTimePeriod time, Date date) {
        long firstMillisecond = time.getFirstMillisecond();
        long lastMillisecond = time.getLastMillisecond();
        long buildTime = date.getTime();
        return buildTime >= firstMillisecond && buildTime <= lastMillisecond;
    }

    protected RegularTimePeriod getFirstPeriod(Date earliestDataEntry, String periodRange) {
        return this.getPeriod(earliestDataEntry, periodRange);
    }

    protected RegularTimePeriod getLastPeriod(Date latestDataEntry, String periodRange) {
        return this.getPeriod(latestDataEntry, periodRange);
    }

    protected RegularTimePeriod getPeriod(Date date, String periodRange) {
        if ("YEAR".equals(periodRange)) {
            return new Year(date);
        }
        if ("WEEK".equals(periodRange)) {
            return new Week(date);
        }
        if ("DAY".equals(periodRange)) {
            return new Day(date);
        }
        return new Month(date);
    }

    public Map<String, String[]> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String[]> params) {
        this.params = params;
    }

    public Map<String, List<ResultsSummary>> getAuthorBuilds() {
        return this.authorBuilds;
    }

    public void setAuthorBuilds(Map<String, List<ResultsSummary>> authorBuilds) {
        if (authorBuilds != null) {
            for (List<ResultsSummary> resultsSummaries : authorBuilds.values()) {
                Collections.sort(resultsSummaries, Comparators.getBuildDateOrdering());
            }
        }
        this.authorBuilds = authorBuilds;
    }
}

