/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.messaging;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.agent.BambooAgentHttpRequestUtils;
import com.atlassian.bamboo.agent.classserver.AgentServerManager;
import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.build.ServerBuildLoggerManager;
import com.atlassian.bamboo.build.artifact.BambooArtifactHttpTransport;
import com.atlassian.bamboo.build.logger.FileWritingBuildLogger;
import com.atlassian.bamboo.deployments.DeploymentResultKeyImpl;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionContext;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactDefinitionBase;
import com.atlassian.bamboo.security.SecureToken;
import com.atlassian.bamboo.security.SecureTokenService;
import com.atlassian.bamboo.servlet.BambooHttpServlet;
import com.atlassian.bamboo.storage.StorageCappingService;
import com.atlassian.bamboo.storage.StorageLocationService;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.utils.BambooFiles;
import com.atlassian.bamboo.utils.BambooPathUtils;
import com.atlassian.bamboo.v2.build.agent.messages.ArtifactStreams;
import com.atlassian.bamboo.v2.build.agent.messages.ArtifactUnpackResult;
import com.atlassian.event.api.EventPublisher;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.stream.Stream;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class ArtifactServlet
extends BambooHttpServlet {
    private static final Logger log = Logger.getLogger(ArtifactServlet.class);
    @Autowired
    @VisibleForTesting
    AgentServerManager agentServerManager;
    @Autowired
    @VisibleForTesting
    SecureTokenService secureTokenService;
    @Autowired
    @VisibleForTesting
    StorageCappingService storageCappingService;
    @Autowired
    EventPublisher eventPublisher;
    @Autowired
    private StorageLocationService storageLocationService;
    @Autowired
    private ServerBuildLoggerManager buildLoggerManager;

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.retrieveArtifact(req, resp);
    }

    private void retrieveArtifact(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!this.isFingerprintAndTokenValid(req, resp)) {
            return;
        }
        Artifact artifact = BambooArtifactHttpTransport.artifactFromJson((Reader)new InputStreamReader((InputStream)req.getInputStream(), StandardCharsets.UTF_8));
        File artifactStorageDirectory = this.storageLocationService.getDefaultArtifactDirectoryBuilder().getArtifactDirectory(artifact);
        ArtifactStreams.writeFilesToStream((Path)artifactStorageDirectory.toPath(), (Stream)ArtifactStreams.iterateFilesAndDirs((Path)artifactStorageDirectory.toPath()), (OutputStream)resp.getOutputStream());
        resp.setStatus(200);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!this.isFingerprintAndTokenValid(req, resp)) {
            return;
        }
        if (this.storageCappingService.isHardLimitExceeded()) {
            String msg = "Unable to publish " + this.getArtifactDescription(req) + " because local storage is full. Switch to S3 storage";
            log.error((Object)msg);
            resp.sendError(403, msg);
            return;
        }
        this.storeArtifact(req, resp);
        resp.setStatus(204);
    }

    protected void storeArtifact(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String artifactDescription = this.getArtifactDescription(req);
        log.debug((Object)("Receiving " + artifactDescription));
        LocalDateTime start = LocalDateTime.now();
        try (BambooFiles.QuietlyRemoved autoArtifactTmpDir = BambooFiles.quietlyRemoved((Path)this.getDeserialisationPath());){
            Path artifactTmpDir = autoArtifactTmpDir.getPath();
            ServletInputStream inputStream = req.getInputStream();
            ArtifactDefinitionContext artifactDefinitionContext = ArtifactServlet.readArtifactDefinition((InputStream)inputStream);
            ArtifactUnpackResult artifactUnpackResult = ArtifactStreams.deserialiseStreamToDir((InputStream)inputStream, (Path)artifactTmpDir, (EventPublisher)this.eventPublisher);
            this.moveToFinalDestination(req, artifactTmpDir, (ImmutableArtifactDefinitionBase)artifactDefinitionContext);
            long processingLongerThanPackingBy = this.getProcessingTimeDifference(Duration.between(start, LocalDateTime.now()), artifactUnpackResult.getPackingTime());
            if (processingLongerThanPackingBy > ArtifactStreams.TOO_LONG_PROCESSING_DURATION.getSeconds()) {
                log.warn((Object)("Artifact processing was longer by " + processingLongerThanPackingBy + "s than artifact publish, looks like your server is under load or the disk holding the artifact directory is too slow. Deserialisation itself took " + artifactUnpackResult.getUnpackingTime().getSeconds() + 's'));
            }
            log.info((Object)(artifactDescription + " is now available on the server"));
        }
        catch (Exception e) {
            log.error((Object)"Exception when storing the artifact", (Throwable)e);
            throw e;
        }
    }

    private long getProcessingTimeDifference(Duration totalTime, Duration packingTime) {
        return totalTime.compareTo(packingTime) > 0 ? totalTime.getSeconds() - packingTime.getSeconds() : 0L;
    }

    private boolean isFingerprintAndTokenValid(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String authenticationTokenStr;
        String fingeprintProvidedInUrl = req.getParameter("fingerprint");
        if (fingeprintProvidedInUrl != null && !this.agentServerManager.isServerFingerprintValid(fingeprintProvidedInUrl)) {
            log.warn((Object)("Incorrect fingerprint: " + fingeprintProvidedInUrl + ". This could be due to a remote agent left over from a previous Bamboo server process, or an attempted attack."));
            resp.sendError(404, "Incorrect fingerprint");
            return false;
        }
        if (fingeprintProvidedInUrl == null) {
            String fingerprint = req.getHeader("Atlassian-Bamboo-Fingerprint");
            if (fingerprint == null) {
                BambooAgentHttpRequestUtils.sendError(resp, 400, "Atlassian-Bamboo-Fingerprint is missing");
                return false;
            }
            if (Long.parseLong(fingerprint) != this.agentServerManager.getFingerprint().getInstanceFingerprint()) {
                BambooAgentHttpRequestUtils.sendError(resp, 404, "Atlassian-Bamboo-Fingerprint is missing");
                return false;
            }
        }
        if (StringUtils.isBlank((CharSequence)(authenticationTokenStr = req.getHeader("X-Bamboo-AuthenticationToken")))) {
            String msg = "Cannot process message: authentication token missing for " + this.getArtifactDescription(req);
            BambooAgentHttpRequestUtils.sendError(resp, 401, msg);
            return false;
        }
        SecureToken authenticationToken = SecureToken.createFromString((String)authenticationTokenStr);
        if (!this.secureTokenService.isValid(authenticationToken)) {
            String msg = "Cannot process message: invalid authentication token [" + authenticationToken.getToken() + "]: " + this.getArtifactDescription(req);
            BambooAgentHttpRequestUtils.sendError(resp, 401, msg);
            return false;
        }
        return true;
    }

    private static ArtifactDefinitionContext readArtifactDefinition(InputStream inputStream) throws IOException {
        int byte1 = inputStream.read();
        int byte2 = inputStream.read();
        if (byte1 == -1 || byte2 == -1) {
            throw new IOException("Unable to read stream length, encountered EOF");
        }
        int i = (byte1 << 8) + byte2;
        byte[] buf = new byte[i];
        IOUtils.readFully((InputStream)inputStream, (byte[])buf);
        return BambooArtifactHttpTransport.artifactDefinitionfromJson((String)new String(buf, StandardCharsets.UTF_8));
    }

    private void moveToFinalDestination(HttpServletRequest req, Path srcDir, ImmutableArtifactDefinitionBase artifact) throws IOException {
        String artifactDescription = this.getArtifactDescription(req);
        ResultKey resultKey = this.getResultKey(req);
        if (artifact.getName().equals("LogsFromBambooAgent")) {
            this.appendLogFile(resultKey, srcDir, artifact);
            return;
        }
        File destinationDirectory = this.getArtifactStorageDirectory(resultKey, artifact);
        try {
            log.debug((Object)("Moving " + artifactDescription + " to its final destination"));
            BambooFileUtils.moveDirectoryContentToDirectory((File)srcDir.toFile(), (File)destinationDirectory, (boolean)true);
        }
        catch (IOException e) {
            BambooPathUtils.deleteQuietly((Path)destinationDirectory.toPath());
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendLogFile(@NotNull ResultKey resultKey, Path srcDir, @NotNull ImmutableArtifactDefinitionBase artifact) throws IOException {
        File logFile = this.storageLocationService.getLogFile(resultKey);
        if (logFile.exists()) {
            try {
                FileWritingBuildLogger buildLogger = this.buildLoggerManager.getPersistentLogger(resultKey);
                buildLogger.appendLogFile(new File(srcDir.toFile(), artifact.getCopyPattern()));
            }
            finally {
                BambooPathUtils.deleteQuietly((Path)srcDir);
            }
        } else {
            logFile.getParentFile().mkdirs();
            BambooFileUtils.renameTo((File)new File(srcDir.toFile(), artifact.getCopyPattern()), (File)logFile);
        }
    }

    private Path getDeserialisationPath() throws IOException {
        return BambooFiles.createTempDirectory((Path)this.storageLocationService.getDefaultArtifactDirectoryBuilder().getTemporaryDirectory().toPath(), (String)((Object)((Object)this)).getClass().getName(), (FileAttribute[])new FileAttribute[0]);
    }

    protected File getArtifactStorageDirectory(@NotNull ResultKey resultKey, @NotNull ImmutableArtifactDefinitionBase artifact) {
        return this.storageLocationService.getDefaultArtifactDirectoryBuilder().getEntityOrientedArtifactDirectory(resultKey, artifact);
    }

    private String getArtifactDescription(HttpServletRequest req) {
        return req.getHeader("Content-Description");
    }

    private ResultKey getResultKey(HttpServletRequest req) {
        String resultKeyString = req.getParameter("resultKey");
        BambooArtifactHttpTransport.EntityType entityType = BambooArtifactHttpTransport.EntityType.valueOf((String)((String)StringUtils.defaultIfBlank((CharSequence)req.getParameter("entityType"), (CharSequence)BambooArtifactHttpTransport.EntityType.PLAN.name())));
        switch (entityType) {
            case PLAN: {
                return PlanKeys.getPlanResultKey((String)resultKeyString);
            }
            case DEPLOYMENT: {
                return DeploymentResultKeyImpl.from((String)resultKeyString);
            }
        }
        throw new IllegalStateException("Neither plan nor deployment?");
    }
}

