/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.classserver.cacheable;

import com.atlassian.bamboo.agent.BambooAgentHttpRequestUtils;
import com.atlassian.bamboo.agent.bootstrap.AgentFileManifestDao;
import com.atlassian.bamboo.agent.classserver.AgentClassServer;
import com.atlassian.bamboo.agent.classserver.AgentServerManager;
import com.atlassian.bamboo.agent.classserver.JarDescriptor;
import com.atlassian.bamboo.servlet.BambooHttpServlet;
import com.atlassian.bamboo.spring.EventuallyAutowired;
import com.atlassian.bamboo.utils.SystemProperty;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import io.atlassian.util.concurrent.Lazy;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.entity.ContentType;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class CacheableClasspathServlet
extends BambooHttpServlet {
    private static final Logger log = Logger.getLogger(CacheableClasspathServlet.class);
    private static final Duration TIME_TO_WAIT_FOR_BUSY_SEVER = Duration.ofSeconds(60L);
    private static final String TEXT_PLAIN_UTF8 = ContentType.TEXT_PLAIN.withCharset(StandardCharsets.UTF_8).toString();
    private static final int DEFAULT_MAX_REQUESTS = 20;
    private static final AtomicInteger counter = new AtomicInteger();
    private static final Semaphore REQUEST_THROTTLING_SEMAPHORE = new Semaphore(SystemProperty.BAMBOO_MAX_AGENTS_LOADING.getValue(20));
    public static final Date fixedTimestamp = new Date();
    @EventuallyAutowired
    private EventuallyAvailable eventuallyAvailable;
    private final Supplier<Map<String, Pair<String, Supplier<Map<String, JarDescriptor>>>>> collectionDefinitions = Lazy.supplier(() -> {
        AgentClassServer classServerService = this.eventuallyAvailable.getClassServerService();
        ImmutableMap collectionDefinitions = ImmutableMap.builder().put((Object)"classpath", (Object)Pair.of((Object)"classpath", () -> ((AgentClassServer)classServerService).getJarsOnSystemClasspath())).put((Object)"user-installed-plugins", (Object)Pair.of((Object)"plugins/user-installed", () -> ((AgentClassServer)classServerService).getJarsOfUserInstalledPlugins())).put((Object)"system-provided-plugins", (Object)Pair.of((Object)"plugins/system-provided", () -> ((AgentClassServer)classServerService).getJarsOfSystemProvidedPlugins())).put((Object)"framework-bundles", (Object)Pair.of((Object)"framework-bundles", () -> ((AgentClassServer)classServerService).getJarsOfFrameworkBundle())).build();
        return collectionDefinitions;
    });

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        if (pathInfo.equals("/content-cache-test")) {
            this.serveCacheTest(resp);
            return;
        }
        if (!this.verifyFingerprint(req, resp)) {
            return;
        }
        List collectionAndFile = Splitter.on((char)'/').omitEmptyStrings().splitToList((CharSequence)pathInfo);
        String collection = (String)collectionAndFile.get(0);
        String pathOrHash = (String)collectionAndFile.get(collectionAndFile.size() - 1);
        Pair<String, Map<String, JarDescriptor>> collectionDefinition = this.getCollectionDefinition(collection);
        if (collectionDefinition == null) {
            BambooAgentHttpRequestUtils.sendError(resp, 400, "Unknown collection " + collection);
            return;
        }
        switch ('/' + pathOrHash) {
            case "/manifest": {
                this.writeJarManifest(resp, collection, collectionDefinition);
                break;
            }
            default: {
                this.serveFileWithThrottling(resp, collectionAndFile, collectionDefinition);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serveFileWithThrottling(HttpServletResponse resp, List<String> collectionAndFile, Pair<String, Map<String, JarDescriptor>> collectionDefinition) throws IOException {
        String path = collectionAndFile.get(collectionAndFile.size() - 2);
        if (!REQUEST_THROTTLING_SEMAPHORE.tryAcquire()) {
            this.addTryLaterHeader(resp);
            resp.sendError(503, "Bamboo server is still starting up");
            return;
        }
        try {
            this.serveFile(resp, collectionDefinition, path);
        }
        finally {
            REQUEST_THROTTLING_SEMAPHORE.release();
        }
    }

    private void serveCacheTest(HttpServletResponse resp) throws IOException {
        resp.setContentType(TEXT_PLAIN_UTF8);
        resp.setDateHeader("Last-Modified", fixedTimestamp.getTime());
        resp.setHeader("Cache-Control", "public, max-age=30");
        String s = Integer.toString(counter.incrementAndGet()) + StringUtils.repeat((String)" ", (int)5000);
        resp.setHeader("Content-Length", String.valueOf(s.length()));
        PrintWriter writer = resp.getWriter();
        writer.write(s);
    }

    private void serveFile(HttpServletResponse resp, Pair<String, Map<String, JarDescriptor>> jars, String file) throws IOException {
        JarDescriptor jarDescriptor = (JarDescriptor)((Map)jars.getRight()).get(file);
        if (jarDescriptor == null) {
            BambooAgentHttpRequestUtils.sendError(resp, 403, "Serving file [" + file + "] is not allowed, rejecting request.");
            return;
        }
        resp.setContentType(ContentType.APPLICATION_OCTET_STREAM.toString());
        resp.setHeader("Cache-Control", "public, max-age=" + TimeUnit.DAYS.toSeconds(365L));
        jarDescriptor.getLastModified().ifPresent(lastModified -> resp.setDateHeader("Last-Modified", lastModified.longValue()));
        jarDescriptor.getLength().ifPresent(length -> resp.setHeader("Content-Length", String.valueOf(length)));
        try (InputStream inputStream = jarDescriptor.getInputStream();){
            IOUtils.copy((InputStream)inputStream, (OutputStream)resp.getOutputStream());
        }
    }

    private void writeJarManifest(HttpServletResponse resp, String collection, Pair<String, Map<String, JarDescriptor>> jarsInCollection) throws IOException {
        resp.setContentType(TEXT_PLAIN_UTF8);
        ArrayList<AgentFileManifestDao.AgentFileManifestEntry> classpathFiles = new ArrayList<AgentFileManifestDao.AgentFileManifestEntry>();
        for (JarDescriptor jar : ((Map)jarsInCollection.getRight()).values()) {
            Long length = jar.getLength().orElse(-1L);
            classpathFiles.add(new AgentFileManifestDao.AgentFileManifestEntry(collection, this.getDestination(jarsInCollection, jar), length.longValue(), Long.toString(jar.getChecksum())));
        }
        HashMap<String, ArrayList<AgentFileManifestDao.AgentFileManifestEntry>> collections = new HashMap<String, ArrayList<AgentFileManifestDao.AgentFileManifestEntry>>();
        collections.put(collection, classpathFiles);
        PrintWriter writer = resp.getWriter();
        AgentFileManifestDao.write((PrintWriter)writer, collections);
        resp.setStatus(200);
        writer.flush();
    }

    @NotNull
    private String getDestination(Pair<String, Map<String, JarDescriptor>> collection, JarDescriptor jar) {
        return (String)collection.getLeft() + "/" + jar.getName();
    }

    private boolean verifyFingerprint(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean isServerFingerprintValid;
        String fingerprint = req.getHeader("Atlassian-Bamboo-Fingerprint");
        if (fingerprint == null) {
            BambooAgentHttpRequestUtils.sendError(resp, 400, "Atlassian-Bamboo-Fingerprint is missing");
            return false;
        }
        AgentServerManager agentServerManager = this.eventuallyAvailable.getAgentServerManager();
        if (agentServerManager == null) {
            this.addTryLaterHeader(resp);
            BambooAgentHttpRequestUtils.sendError(resp, 503, "Bamboo server is still starting up");
            return false;
        }
        boolean bl = isServerFingerprintValid = agentServerManager.getFingerprint().getInstanceFingerprint() == Long.parseLong(fingerprint);
        if (!isServerFingerprintValid) {
            BambooAgentHttpRequestUtils.sendError(resp, 403, "Invalid fingerprint found");
        }
        return isServerFingerprintValid;
    }

    private void addTryLaterHeader(HttpServletResponse resp) {
        resp.addHeader("Retry-After", Long.toString(TIME_TO_WAIT_FOR_BUSY_SEVER.getSeconds()));
    }

    @Nullable
    private Pair<String, Map<String, JarDescriptor>> getCollectionDefinition(String collection) {
        Pair<String, Supplier<Map<String, JarDescriptor>>> collectionDefinition = this.collectionDefinitions.get().get(collection);
        return Pair.of((Object)collectionDefinition.getLeft(), ((Supplier)collectionDefinition.getRight()).get());
    }

    private static class EventuallyAvailable {
        @Autowired
        private AgentServerManager agentServerManager;
        @Autowired
        protected AgentClassServer classServerService;

        private EventuallyAvailable() {
        }

        @Nullable
        public AgentServerManager getAgentServerManager() {
            return this.agentServerManager;
        }

        public AgentClassServer getClassServerService() {
            return this.classServerService;
        }
    }
}

