/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.classserver;

import com.atlassian.bamboo.agent.classserver.AgentServerServlet;
import com.atlassian.bamboo.agent.classserver.ClassServerManifest;
import com.atlassian.bamboo.agent.classserver.FileHashDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PluginArtifactServlet
extends AgentServerServlet {
    @Override
    protected void calculateResult(HttpServletRequest request, HttpServletResponse response) throws IOException, ClassNotFoundException {
        ClassServerManifest manifest;
        Set<FileHashDescriptor> fileHashDescriptors = PluginArtifactServlet.getFileHashDescriptors(request);
        String requestURI = request.getRequestURI();
        if (requestURI.endsWith("bundled-plugins.zip")) {
            manifest = this.classServerService.getSystemProvidedPlugins(fileHashDescriptors);
        } else if (requestURI.endsWith("plugins.zip")) {
            manifest = this.classServerService.getUserInstalledPlugins(fileHashDescriptors);
        } else if (requestURI.endsWith("framework-bundles.zip")) {
            manifest = this.classServerService.getPluginFrameworkBundles(fileHashDescriptors);
        } else {
            throw new IllegalStateException("Could not serve plugin artifacts for '" + requestURI + "'");
        }
        this.writeClasspathToOutputStream(manifest, (OutputStream)response.getOutputStream(), "plugins");
    }
}

