/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.classserver;

import com.atlassian.bamboo.agent.bootstrap.BootstrapUpdater;
import com.atlassian.bamboo.agent.bootstrap.BootstrapUtils;
import com.atlassian.bamboo.agent.classserver.AgentServerManager;
import com.atlassian.bamboo.agent.classserver.AgentServerServlet;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.v2.build.agent.remote.UpgradeRemoteAgent;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;

public class GetResourceServlet
extends AgentServerServlet {
    private static final Logger log = Logger.getLogger(GetResourceServlet.class);
    private static final Class<?>[] WHITELISTED_3RD_PARTY_CLASSES = new Class[]{LogFactory.class, LoggerFactory.class, StaticLoggerBinder.class};
    private static final Class<?>[] WHITELISTED_BAMBOO_CLASSES = new Class[]{UpgradeRemoteAgent.class, BootstrapUpdater.class, BootstrapUtils.class};
    final Collection<String> whiteListedJarPaths = this.createWhitelistedJarPathsList();

    @Override
    protected void calculateResult(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        AgentServerManager agentServerManager = this.getAgentServerManager();
        if (agentServerManager == null) {
            log.debug((Object)"Application Context is not yet set up, agentServerManager is null");
            httpServletResponse.sendError(500, "Application Context is not yet set up.");
            return;
        }
        String name = httpServletRequest.getParameter("name");
        URL resource = agentServerManager.getClassLoader().getResource(name);
        if (resource == null) {
            String currentUrl = httpServletRequest.getRequestURI();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unable to find '" + name + "' from '" + currentUrl + "'. Returning status code 404."));
            }
            httpServletResponse.sendError(404, "Unable to find '" + name + "' from '" + currentUrl + "'.");
            return;
        }
        if (!(this.isContainingJarWhiteListed(resource) || BuildUtils.isDevMode() && this.isResourceWhiteListedForDevMode(resource))) {
            httpServletResponse.sendError(403, "Forbidden.");
            return;
        }
        URLConnection urlConnection = resource.openConnection();
        int contentLength = urlConnection.getContentLength();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fetching resource with name = " + name + ",  resource = " + resource + " " + contentLength));
        }
        this.copyToResponse(httpServletResponse, contentLength, "application/octet-stream", urlConnection.getInputStream());
    }

    private boolean isResourceWhiteListedForDevMode(URL resource) {
        for (Class<?> aClass : WHITELISTED_BAMBOO_CLASSES) {
            if (!resource.getFile().startsWith(aClass.getProtectionDomain().getCodeSource().getLocation().getFile())) continue;
            return true;
        }
        return false;
    }

    private Collection<String> createWhitelistedJarPathsList() {
        ArrayList<String> whitelist = new ArrayList<String>();
        for (Class<?> aClass : WHITELISTED_3RD_PARTY_CLASSES) {
            whitelist.add(this.locationOf(aClass).getFile());
        }
        for (Class<?> aClass : WHITELISTED_BAMBOO_CLASSES) {
            whitelist.add(this.locationOf(aClass).getFile());
        }
        return whitelist;
    }

    private boolean isContainingJarWhiteListed(URL resource) {
        for (String whiteListedJarPath : this.whiteListedJarPaths) {
            String nameWithoutSubprotocol = StringUtils.removeStart((String)resource.getFile(), (String)"file:");
            if (!nameWithoutSubprotocol.startsWith(whiteListedJarPath + '!')) continue;
            return true;
        }
        return false;
    }

    private URL locationOf(Class<?> logFactoryClass) {
        return logFactoryClass.getProtectionDomain().getCodeSource().getLocation();
    }
}

