/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.classserver;

import com.atlassian.bamboo.agent.classserver.AgentServerManager;
import com.atlassian.bamboo.agent.classserver.AgentServerServlet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class GetPackageServlet
extends AgentServerServlet {
    private static final Logger log = Logger.getLogger(GetPackageServlet.class);

    @Override
    protected void calculateResult(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ClassNotFoundException {
        String className = httpServletRequest.getParameter("className");
        log.debug((Object)("Loading class" + className));
        AgentServerManager agentServerManager = this.getAgentServerManager();
        if (agentServerManager != null) {
            ClassLoader classLoader = agentServerManager.getClassLoader();
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            try {
                Class<?> aClass = Class.forName(className, false, classLoader);
                Package aPackage = aClass.getPackage();
                try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(buffer);){
                    objectOutputStream.writeObject(aPackage.getSpecificationTitle());
                    objectOutputStream.writeObject(aPackage.getSpecificationVersion());
                    objectOutputStream.writeObject(aPackage.getSpecificationVendor());
                    objectOutputStream.writeObject(aPackage.getImplementationTitle());
                    objectOutputStream.writeObject(aPackage.getImplementationVersion());
                    objectOutputStream.writeObject(aPackage.getImplementationVendor());
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
                byte[] packageInfo = buffer.toByteArray();
                this.copyToResponse(httpServletResponse, packageInfo.length, "application/octet-stream", new ByteArrayInputStream(packageInfo));
            }
            catch (ClassNotFoundException exception) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Unable to find '" + className + "' from '" + httpServletRequest.getRequestURI() + "'. Returning status code 404."));
                }
                httpServletResponse.sendError(404, "Class not found. Returning status code 404");
            }
        } else {
            log.debug((Object)"Application Context is not yet set up, agentServerManager is null");
            httpServletResponse.sendError(500, "Application Context is not yet set up.");
        }
    }
}

