/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.classserver;

import com.atlassian.bamboo.agent.classserver.AgentServerManager;
import com.atlassian.bamboo.agent.classserver.AgentServerServlet;
import com.atlassian.bamboo.agent.classserver.ClasspathJarUtils;
import com.atlassian.bamboo.agent.classserver.JarDescriptor;
import com.atlassian.bamboo.fileserver.SystemDirectory;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.utils.Pair;
import com.google.common.base.Throwables;
import com.google.common.io.ByteSource;
import io.atlassian.util.concurrent.Lazy;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class GetJarServlet
extends AgentServerServlet {
    private static final Logger log = Logger.getLogger(GetJarServlet.class);
    private static final String INSTALLER_JAR_NAME = "atlassian-bamboo-agent-installer-" + BuildUtils.getCurrentVersion() + ".jar";
    private static final String BOOTSTRAP_JAR_NAME = "bamboo-agent-bootstrap-jar-with-dependencies.jar";
    private static final ConcurrentMap<String, JarDescriptor> servedJars = new ConcurrentHashMap<String, JarDescriptor>();

    public GetJarServlet() {
        if (servedJars.isEmpty()) {
            servedJars.putIfAbsent("google-collections", new JarDescriptor("google-collections", (ByteSource)new ClassPathInputSupplier("com.google.common.collect.ListMultimap")));
            servedJars.putIfAbsent("bcprov", new JarDescriptor("bcprov", (ByteSource)new ClassPathInputSupplier("org.bouncycastle.jce.provider.BouncyCastleProvider")));
            servedJars.putIfAbsent("bootstrap-with-deps", new JarredJarDescriptor("bootstrap-with-deps", new JarredInputSupplier("/admin/agent", INSTALLER_JAR_NAME, BOOTSTRAP_JAR_NAME)));
        }
    }

    @Override
    protected void calculateResult(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ClassNotFoundException {
        AgentServerManager agentServerManager;
        String name = httpServletRequest.getParameter("name");
        String remoteChecksumString = httpServletRequest.getParameter("checksum");
        JarDescriptor requestedResource = (JarDescriptor)servedJars.get(name);
        if (requestedResource == null) {
            log.warn((Object)("Agent requested unsupported jar '" + name + "' from '" + httpServletRequest.getRequestURI() + "'. Returning status code 404."));
            httpServletResponse.sendError(404, "Jar not supported. Returning status code 404");
            return;
        }
        if (remoteChecksumString != null) {
            long localChecksum;
            long remoteChecksum = Long.parseLong(remoteChecksumString);
            if (remoteChecksum == (localChecksum = requestedResource.getChecksum())) {
                httpServletResponse.setStatus(204);
                return;
            }
            log.info((Object)("Sending updated resource: " + name + ", remote checksum is: " + Long.toHexString(remoteChecksum) + " local checksum is: " + Long.toHexString(localChecksum)));
        }
        if ((agentServerManager = this.getAgentServerManager()) == null) {
            log.debug((Object)"Application Context is not yet set up, agentServerManager is null");
            httpServletResponse.sendError(500, "Application Context is not yet set up.");
            return;
        }
        try (InputStream inputStream = requestedResource.getInputStream();){
            this.copyToResponse(httpServletResponse, -1, "application/octet-stream", inputStream);
        }
    }

    private static class ClassPathInputSupplier
    extends ByteSource {
        private final String oneOfTheClassesInJar;

        public ClassPathInputSupplier(String oneOfTheClassesInJar) {
            this.oneOfTheClassesInJar = oneOfTheClassesInJar;
        }

        public InputStream openStream() throws IOException {
            ClassLoader classLoader = AgentServerManager.class.getClassLoader();
            try {
                Class<?> aClass = Class.forName(this.oneOfTheClassesInJar, false, classLoader);
                URL classPathLocation = aClass.getProtectionDomain().getCodeSource().getLocation();
                File file = new File(classPathLocation.toURI());
                if (file.isDirectory()) {
                    log.info((Object)("Creating JAR for " + file));
                    File jarFromClassPathDirectory = ClasspathJarUtils.createJar((File)file);
                    if (jarFromClassPathDirectory == null) {
                        throw new ClassNotFoundException("Unable to create JAR for " + this.oneOfTheClassesInJar);
                    }
                    return new BufferedInputStream(new FileInputStream(jarFromClassPathDirectory));
                }
                return classPathLocation.openStream();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    private static class JarredJarDescriptor
    extends JarDescriptor {
        final JarredInputSupplier inputSupplier;

        public JarredJarDescriptor(String name, JarredInputSupplier inputSupplier) {
            super(name, (ByteSource)inputSupplier);
            this.inputSupplier = inputSupplier;
        }

        public long getChecksum() {
            return this.inputSupplier.getChecksum();
        }
    }

    private class JarredInputSupplier
    extends ByteSource {
        private final String virtualLocation;
        private final String outerJarName;
        private final String innerResourceName;
        private final Supplier<Pair<File, Long>> file = Lazy.supplier((Supplier)new Supplier<Pair<File, Long>>(){

            @Override
            public Pair<File, Long> get() {
                try {
                    return this.makePath();
                }
                catch (IOException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }

            @NotNull
            private Pair<File, Long> makePath() throws IOException {
                long innerResourceChecksum;
                String virtualPath = JarredInputSupplier.this.virtualLocation + "/" + JarredInputSupplier.this.outerJarName;
                String outerJarPath = GetJarServlet.this.getServletContext().getRealPath(virtualPath);
                if (outerJarPath.matches(".*src.main.webapp" + virtualPath.replace('/', '.') + "$")) {
                    outerJarPath = outerJarPath.replace("/src/main/webapp/", "/target/atlassian-bamboo-web-app/");
                }
                if (outerJarPath == null) {
                    throw new IOException("Cannot find " + JarredInputSupplier.this.virtualLocation);
                }
                File innerResource = new File(SystemDirectory.getCacheDirectory(), JarredInputSupplier.this.innerResourceName);
                try (JarFile outerJarFile = new JarFile(new File(outerJarPath));){
                    JarEntry innerJar = outerJarFile.getJarEntry("generic/lib/" + JarredInputSupplier.this.innerResourceName);
                    innerResourceChecksum = innerJar.getCrc();
                    try (FileOutputStream innerResourceStream = new FileOutputStream(innerResource);){
                        IOUtils.copy((InputStream)outerJarFile.getInputStream(innerJar), (OutputStream)innerResourceStream);
                    }
                }
                return Pair.make((Object)innerResource, (Object)innerResourceChecksum);
            }
        });

        public JarredInputSupplier(String jarVirtualPath, String outerJarName, String innerResourceName) {
            this.virtualLocation = jarVirtualPath;
            this.outerJarName = outerJarName;
            this.innerResourceName = innerResourceName;
        }

        public InputStream openStream() throws IOException {
            return new BufferedInputStream(new FileInputStream((File)this.file.get().first));
        }

        public long getChecksum() {
            return (Long)this.file.get().second;
        }
    }
}

