/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.classserver;

import com.atlassian.bamboo.agent.AgentSecurityTokenService;
import com.atlassian.bamboo.agent.classserver.AgentServerManager;
import com.atlassian.bamboo.buildqueue.RemoteAgentAuthentication;
import com.atlassian.bamboo.buildqueue.manager.RemoteAgentAuthenticationManager;
import com.atlassian.bamboo.buildqueue.manager.RemoteAgentManager;
import com.atlassian.bamboo.util.UrlBuilder;
import com.atlassian.bamboo.utils.BambooFunctions;
import com.atlassian.bamboo.utils.EscapeChars;
import com.atlassian.bamboo.utils.ServletUtils;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalBypassSecurityAware;
import com.atlassian.security.utils.ConstantTimeComparison;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class GetFingerprintAction
extends BambooActionSupport
implements GlobalBypassSecurityAware,
ServletRequestAware,
ServletResponseAware {
    private static final Logger log = Logger.getLogger(GetFingerprintAction.class);
    private static final String ELASTIC = "elastic";
    private static final String APPROVAL_REQUIRED_HEADER = "ApprovalRequired";
    @Autowired
    private AgentServerManager agentServerManager;
    @Autowired
    private RemoteAgentManager remoteAgentManager;
    @Autowired
    private RemoteAgentAuthenticationManager authenticationManager;
    @Autowired
    private AgentSecurityTokenService agentSecurityTokenService;
    private String hostName;
    private String agentType;
    private String instanceId;
    private String version;
    private String uuid;
    private String agentId;
    private String fingerprintSentByElasticAgent;
    private String securityToken;
    private String errorMessage;
    private HttpServletRequest httpServletRequest;
    private HttpServletResponse httpServletResponse;

    public String execute() throws Exception {
        if (this.requiresSecurityToken()) {
            if (StringUtils.isEmpty((CharSequence)this.securityToken)) {
                log.warn((Object)String.format("Security token not provided by remote agent (uuid: %s, host: %s, version: %s)", this.uuid, this.hostName, this.version));
                this.errorMessage = "Security token is required for preliminary authentication, but none was provided. Please obtain the token from " + this.getSecurityTokenUrl();
                this.httpServletResponse.setStatus(400);
                return "error";
            }
            if (!this.agentSecurityTokenService.getSecurityToken().equals(this.securityToken)) {
                log.warn((Object)String.format("Invalid token provided by remote agent (uuid: %s, host: %s, version: %s)", this.uuid, this.hostName, this.version));
                this.errorMessage = "Security token verification failed. Please obtain the correct token from " + this.getSecurityTokenUrl();
                this.httpServletResponse.setStatus(401);
                return "error";
            }
        }
        if (!this.isAuthenticated()) {
            this.httpServletResponse.setStatus(401);
            return "error";
        }
        if (this.isElastic()) {
            this.remoteAgentManager.bootstrappingElastic(this.getHostIdentification(), this.instanceId);
        } else {
            this.remoteAgentManager.bootstrapping(this.getHostIdentification());
        }
        return "success";
    }

    private boolean isElastic() {
        return ELASTIC.equals(this.agentType);
    }

    private boolean requiresSecurityToken() {
        return !this.isElastic() && this.administrationConfigurationAccessor.getAdministrationConfiguration().isSecurityTokenRequiredFromAgents();
    }

    private boolean isAuthenticated() {
        if (this.isElastic()) {
            String fingerprint = (String)Preconditions.checkNotNull((Object)this.fingerprintSentByElasticAgent, (Object)"The elastic agent did not send a fingerprint. You probably need to rebuild Bamboo");
            return ConstantTimeComparison.isEqual((String)fingerprint, (String)this.agentServerManager.getFingerprint().getServerFingerprint());
        }
        return !this.authenticationManager.isRemoteAgentAuthenticationEnabled() || this.isAgentAuthenticationApproved();
    }

    private boolean isAgentAuthenticationApproved() {
        String ips = this.getAgentIps();
        Preconditions.checkState((ips != null ? 1 : 0) != 0, (Object)"IP address of the connecting agent was null");
        if (this.uuid == null) {
            this.errorMessage = "UUID not received in request. This should not occur. Please contact us at http://support.atlassian.com.";
            return false;
        }
        UUID agentUuid = this.parseUuid();
        if (agentUuid == null) {
            this.errorMessage = "UUID '" + this.uuid + "' is invalid. This should not occur. Please contact us at http://support.atlassian.com.";
            return false;
        }
        Long agentId = NumberUtils.isCreatable((String)this.agentId) ? Long.valueOf(Long.parseLong(this.agentId)) : null;
        int versionInt = Integer.parseInt(this.version);
        try {
            Pair authentication = this.authenticationManager.getOrCreatePendingAuthentication(agentUuid, ips, agentId, versionInt >= 4);
            if (!((Boolean)authentication.getRight()).booleanValue() || !((RemoteAgentAuthentication)authentication.getLeft()).isApproved()) {
                this.errorMessage = "Approve this agent at '" + this.getApproveAgentUrl((RemoteAgentAuthentication)authentication.getLeft()) + "'. Check that the IP is correct. ";
                this.httpServletResponse.setHeader(APPROVAL_REQUIRED_HEADER, "true");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.errorMessage = e.getMessage();
            return false;
        }
    }

    private String getApproveAgentUrl(RemoteAgentAuthentication authentication) {
        return new UrlBuilder().setUrlBase(this.getBaseUrl()).addPath("admin/agent/viewAgents.action").setParameter("selectedTab", this.getText("agent.remote.authentication.tab")).setParameter("focusUuid", authentication.getUuid().toString()).toString();
    }

    private String getSecurityTokenUrl() {
        return new UrlBuilder().setUrlBase(this.getBaseUrl()).addPath("admin/agent/addRemoteAgent.action").toString();
    }

    @Nullable
    private UUID parseUuid() {
        try {
            return UUID.fromString(this.uuid);
        }
        catch (IllegalArgumentException ignore) {
            return null;
        }
    }

    @Nullable
    private String getHostIdentification() {
        String hostAddress = this.httpServletRequest.getRemoteAddr();
        if (this.hostName != null) {
            if (hostAddress == null) {
                return this.hostName;
            }
            return this.hostName + " (" + hostAddress + ")";
        }
        return hostAddress;
    }

    @VisibleForTesting
    String getAgentIps() {
        return Joiner.on((char)',').join((Iterable)ServletUtils.getAllRequestIpAddresses((HttpServletRequest)this.httpServletRequest).stream().map(InetAddress::getHostAddress).collect(Collectors.toList()));
    }

    public void setAgentType(String agentType) {
        this.agentType = agentType;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setAgentUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    public String getFormEncodedServerFingerprint() {
        return EscapeChars.forFormSubmission((String)this.agentServerManager.getFingerprint().getServerFingerprint());
    }

    public String getFormEncodedInstanceFingerprint() {
        return EscapeChars.forFormSubmission((String)Long.toString(this.agentServerManager.getFingerprint().getInstanceFingerprint()));
    }

    public String getFormEncodedAgentClassName() {
        return EscapeChars.forFormSubmission((String)this.agentServerManager.getAgentClass(this.agentType, this.version).getName());
    }

    public String getFormEncodedUserProperties() {
        HashMap userProperties = new HashMap(this.agentServerManager.getUserProperties());
        BiFunction<String, String, String> mapEntry = (key, value) -> EscapeChars.forFormSubmission((String)("userProperty." + key)) + '=' + EscapeChars.forFormSubmission((String)value);
        return userProperties.entrySet().stream().map(BambooFunctions.liftToEntryFunction(mapEntry)).collect(Collectors.joining("&"));
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setFingerprint(String fingerprint) {
        this.fingerprintSentByElasticAgent = fingerprint;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setServletRequest(HttpServletRequest request) {
        this.httpServletRequest = request;
    }

    public void setServletResponse(HttpServletResponse httpServletResponse) {
        this.httpServletResponse = httpServletResponse;
    }
}

