/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.classserver;

import com.atlassian.bamboo.agent.BambooAgentHttpRequestUtils;
import com.atlassian.bamboo.agent.classserver.AgentClassServer;
import com.atlassian.bamboo.agent.classserver.AgentServerManager;
import com.atlassian.bamboo.agent.classserver.ClassServerManifest;
import com.atlassian.bamboo.agent.classserver.FileHashDescriptor;
import com.atlassian.bamboo.agent.classserver.JarDescriptor;
import com.atlassian.bamboo.event.agent.AgentInstallerEvent;
import com.atlassian.bamboo.servlet.BambooHttpServlet;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.spring.container.ContainerManager;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.Adler32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AgentServerServlet
extends BambooHttpServlet {
    private static final Logger log = Logger.getLogger(AgentServerServlet.class);
    protected static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final String METHOD_POST = "POST";
    protected static final String PRODUCED_BY_ATLASSIAN_BAMBOO = "Produced by Atlassian Bamboo ";
    private AgentServerManager agentServerManager;
    @Autowired
    protected AgentClassServer classServerService;
    @Autowired
    private EventPublisher eventPublisherReference;

    protected final void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.verifyFingerPrintAndCalculateResult(request, response);
    }

    protected final void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.verifyFingerPrintAndCalculateResult(request, response);
    }

    protected abstract void calculateResult(HttpServletRequest var1, HttpServletResponse var2) throws IOException, ClassNotFoundException;

    protected final void verifyFingerPrintAndCalculateResult(@NotNull HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.isFingerprintValid(request, response)) {
            return;
        }
        try {
            this.calculateResult(request, response);
        }
        catch (Throwable e) {
            log.warn((Object)("Unable to generate content for a remote agent on (" + request.getRemoteAddr() + "): " + e.getMessage()), e);
            response.sendError(404, "Could not find resource. Returning status code 404");
        }
    }

    private boolean isFingerprintValid(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean isFingerprintValid;
        AgentServerManager agentServerManager = this.getAgentServerManager();
        if (agentServerManager == null) {
            throw new IllegalStateException("Application Context is not yet set up, downloads are not available.");
        }
        String oldFingerprint = this.getOldFingerprint(request);
        if (oldFingerprint != null) {
            return agentServerManager.isServerFingerprintValid(oldFingerprint);
        }
        Long newFingerprint = this.getNewFingerprint(request);
        if (newFingerprint == null) {
            BambooAgentHttpRequestUtils.sendError(response, 400, "Atlassian-Bamboo-Fingerprint is missing");
            return false;
        }
        boolean bl = isFingerprintValid = agentServerManager.getFingerprint().getInstanceFingerprint() == newFingerprint.longValue();
        if (!isFingerprintValid) {
            String currentUrl = request.getRequestURI();
            String message = "Request " + currentUrl + "?" + request.getQueryString() + " contains an invalid fingerprint. Returning status code " + 410;
            log.warn((Object)message);
            response.sendError(410, message);
        }
        return isFingerprintValid;
    }

    private String getOldFingerprint(HttpServletRequest request) {
        return request.getParameter("fingerprint");
    }

    @Nullable
    private Long getNewFingerprint(HttpServletRequest request) {
        String header = request.getHeader("Atlassian-Bamboo-Fingerprint");
        if (header == null) {
            return null;
        }
        return Long.parseLong(header);
    }

    @Nullable
    protected final AgentServerManager getAgentServerManager() {
        if (BootstrapUtils.getBootstrapManager().isBootstrapped()) {
            if (this.agentServerManager == null) {
                this.agentServerManager = (AgentServerManager)ContainerManager.getComponent((String)"agentServerManager");
            }
            return this.agentServerManager;
        }
        throw new IllegalStateException("Application Context is not yet set up, downloads are not available.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeClasspathToOutputStream(@NotNull ClassServerManifest classServerManifest, @NotNull OutputStream outputStream, String source) throws IOException {
        CheckedOutputStream checksum = new CheckedOutputStream(outputStream, new Adler32());
        ZipOutputStream os = new ZipOutputStream(new BufferedOutputStream(checksum));
        os.setComment(PRODUCED_BY_ATLASSIAN_BAMBOO + BuildUtils.getVersionAndBuild());
        classServerManifest.write(os);
        long size = 0L;
        for (JarDescriptor descriptor : classServerManifest.getJars()) {
            ZipEntry entry = new ZipEntry(descriptor.getName());
            os.putNextEntry(entry);
            try {
                InputStream is = descriptor.getInputStream();
                Throwable throwable = null;
                try {
                    size += IOUtils.copyLarge((InputStream)is, (OutputStream)os);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            finally {
                os.closeEntry();
            }
        }
        this.eventPublisherReference.publish((Object)new AgentInstallerEvent((Object)source, size));
        os.close();
    }

    protected static Map<String, String> collapseParamMapToStringMap(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            if (((String[])entry.getValue()).length <= 0) continue;
            map.put((String)entry.getKey(), ((String[])entry.getValue())[0]);
        }
        return map;
    }

    protected static Set<FileHashDescriptor> getFileHashDescriptors(HttpServletRequest request) {
        if (!METHOD_POST.equals(request.getMethod())) {
            return Collections.emptySet();
        }
        Map<String, String> map = AgentServerServlet.collapseParamMapToStringMap(request);
        map.remove("fingerprint");
        map.remove("mode");
        try {
            return FileHashDescriptor.getFileHashDescriptors(map);
        }
        catch (RuntimeException e) {
            log.error((Object)("Unable to parse data from agent: \nrequest: " + request.getParameterMap() + "\ncollapsed map: " + map));
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyToResponse(HttpServletResponse httpServletResponse, int contentLength, String contentType, InputStream in) throws IOException {
        if (contentLength > 0) {
            httpServletResponse.setContentLength(contentLength);
        }
        httpServletResponse.setContentType(contentType);
        ServletOutputStream out = httpServletResponse.getOutputStream();
        try {
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException e) {
            log.error((Object)"Error copying stream", (Throwable)e);
            httpServletResponse.sendError(500, "Error copying stream.");
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            try {
                out.flush();
            }
            catch (IOException e) {
                log.error((Object)"Error flushing output stream", (Throwable)e);
                httpServletResponse.sendError(500, "Error flushing output stream.");
            }
        }
    }
}

