/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.classserver;

import com.atlassian.bamboo.agent.classserver.AgentClassServer;
import com.atlassian.bamboo.fileserver.SystemDirectory;
import com.atlassian.bamboo.servlet.BambooHttpServlet;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.utils.SystemProperty;
import com.google.common.io.ByteSource;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class AgentInstallerServlet
extends BambooHttpServlet {
    private static final Logger log = Logger.getLogger(AgentInstallerServlet.class);
    @Autowired
    private AgentClassServer classServerServiceReference;
    private final ResettableLazyReference<File> agentInstallerInputStream = new ResettableLazyReference<File>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected File create() throws Exception {
            ByteSource classpathInputSupplier = AgentInstallerServlet.this.classServerServiceReference.getSystemClasspathZip();
            File cacheDirectory = SystemDirectory.getCacheDirectory();
            File file = new File(cacheDirectory, "agent-installer.jar");
            if (file.exists() && !file.delete()) {
                throw new IOException("Could not remove '" + file.getAbsolutePath() + "'.");
            }
            if (!file.createNewFile()) {
                throw new IOException("Could not create '" + file.getAbsolutePath() + "'.");
            }
            ServletContext servletContext = AgentInstallerServlet.this.getServletContext();
            String agentInstallerPath = servletContext.getRealPath("/admin/agent/atlassian-bamboo-agent-installer-" + BuildUtils.getCurrentVersion() + ".jar");
            if (agentInstallerPath == null) {
                throw new IOException("Cannot find bamboo-agent-installer.jar to build customized agent installer");
            }
            JarFile jarFile = new JarFile(new File(agentInstallerPath));
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                JarOutputStream jarOutputStream = new JarOutputStream(fileOutputStream);
                log.debug((Object)String.format("Copying contents of %s to agent installer jar", jarFile.getName()));
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry e = entries.nextElement();
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("name %s, type %s, size %d, compressed size %d", e.getName(), e.isDirectory() ? "DIR" : "NOT DIR", e.getSize(), e.getCompressedSize()));
                    }
                    jarOutputStream.putNextEntry(e);
                    if (!e.isDirectory()) {
                        IOUtils.copy((InputStream)jarFile.getInputStream(e), (OutputStream)jarOutputStream);
                    }
                    jarOutputStream.closeEntry();
                }
                ZipEntry classpathEntry = new ZipEntry("classpath.zip");
                jarOutputStream.putNextEntry(classpathEntry);
                try (InputStream input = classpathInputSupplier.openStream();){
                    IOUtils.copyLarge((InputStream)input, (OutputStream)jarOutputStream);
                }
                jarOutputStream.closeEntry();
                jarOutputStream.close();
            }
            finally {
                IOUtils.closeQuietly((Closeable)jarFile);
                IOUtils.closeQuietly((OutputStream)fileOutputStream);
            }
            return file;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (SystemProperty.BAMBOO_RELOAD_AGENT_CLASSPATH.getValue(false)) {
            this.agentInstallerInputStream.reset();
        }
        File file = (File)this.agentInstallerInputStream.get();
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=\"atlassian-bamboo-agent-installer-" + BuildUtils.getCurrentVersion() + ".jar\"");
        response.setContentLength((int)file.length());
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            IOUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }
}

