/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent;

import com.atlassian.bamboo.FeatureManager;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentService;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentServiceHelper;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.plan.ExecutableAgentsHelper;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.util.RequestCacheThreadLocal;
import com.atlassian.bamboo.v2.build.agent.AgentCommandSender;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.agent.capability.MinimalRequirementSet;
import com.atlassian.bamboo.v2.build.agent.messages.ExecuteCommandMessage;
import com.atlassian.bamboo.v2.build.agent.messages.RemoteBambooMessage;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.google.common.base.Preconditions;
import java.util.Collection;
import org.acegisecurity.acls.Permission;
import org.jetbrains.annotations.Nullable;

public class AgentConsoleAction
extends BambooActionSupport {
    private AgentCommandSender agentCommandSender;
    private String command;
    private long agentId;
    private long sessionId;
    private AgentManager agentManager;
    private String agentName;
    private PlanKey planKey;
    private ExecutableAgentsHelper executableAgentsHelper;

    public String execute() throws Exception {
        if (!this.canAccessAgent()) {
            return "accessDenied";
        }
        BuildAgent buildAgent = this.agentManager.getAgent(this.agentId);
        if (buildAgent != null) {
            this.agentName = buildAgent.getName();
        }
        return "input";
    }

    public String sendCommand() {
        if (!this.canAccessAgent()) {
            return "accessDenied";
        }
        this.agentCommandSender.send((RemoteBambooMessage)new ExecuteCommandMessage(this.command, this.sessionId), Long.valueOf(this.agentId));
        RequestCacheThreadLocal.getNonNullResponse().addHeader("Content-Type", "text/plain");
        return "success";
    }

    public long getAgentId() {
        return this.agentId;
    }

    public void setAgentId(long agentId) {
        this.agentId = agentId;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setSessionId(long sessionId) {
        this.sessionId = sessionId;
    }

    public void setPlanKey(PlanKey planKey) {
        this.planKey = planKey;
    }

    public PlanKey getPlanKey() {
        return this.planKey;
    }

    private boolean canAccessAgent() {
        if (!((FeatureManager)ComponentAccessor.FEATURE_MANAGER.get()).isRemoteAgentShellEnabled()) {
            return false;
        }
        return this.hasAdminPermission() || this.canEditPlan(this.planKey) && this.planRunsOnAgent(this.planKey, this.agentId);
    }

    private boolean canEditPlan(PlanKey planKey) {
        if (planKey == null) {
            return false;
        }
        return this.bambooPermissionManager.hasPlanPermission((Permission)BambooPermission.ADMINISTRATION, planKey) || this.bambooPermissionManager.hasPlanPermission((Permission)BambooPermission.WRITE, planKey);
    }

    private boolean planRunsOnAgent(@Nullable PlanKey planKey, long agentId) {
        if (planKey == null) {
            return false;
        }
        ImmutableJob plan = (ImmutableJob)this.cachedPlanManager.getPlanByKey(planKey, ImmutableJob.class);
        Preconditions.checkNotNull((Object)(plan != null ? 1 : 0), (Object)("Unknown plan " + planKey));
        assert (plan != null);
        ExecutableAgentsHelper.ExecutorQuery executorQuery = ExecutableAgentsHelper.ExecutorQuery.newQuery((MinimalRequirementSet)plan.getEffectiveRequirementSet(), (AgentAssignmentService.AgentAssignmentExecutable)AgentAssignmentServiceHelper.asExecutable((ImmutableBuildable)plan));
        Collection executableAgents = this.executableAgentsHelper.getExecutableAgents(executorQuery);
        for (BuildAgent executableAgent : executableAgents) {
            if (executableAgent.getId() != agentId) continue;
            return this.canEditPlan(planKey);
        }
        throw new IllegalStateException("Agent " + this.agentId + " cannot build " + planKey);
    }

    public void setAgentCommandSender(AgentCommandSender agentCommandSender) {
        this.agentCommandSender = agentCommandSender;
    }

    public void setAgentManager(AgentManager agentManager) {
        this.agentManager = agentManager;
    }

    public void setExecutableAgentsHelper(ExecutableAgentsHelper executableAgentsHelper) {
        this.executableAgentsHelper = executableAgentsHelper;
    }
}

