/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.concurrent;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BambooLocks {
    private static final CacheLoader<Object, ReentrantLock> REENTRANT_LOCK_FACTORY = new CacheLoader<Object, ReentrantLock>(){

        public ReentrantLock load(Object key) throws Exception {
            return new ReentrantLock();
        }
    };
    private static final CacheLoader<Object, ReentrantReadWriteLock> REENTRANT_READ_WRITE_LOCK_FACTORY = new CacheLoader<Object, ReentrantReadWriteLock>(){

        public ReentrantReadWriteLock load(Object key) throws Exception {
            return new ReentrantReadWriteLock();
        }
    };

    protected BambooLocks() {
    }

    public static <K> LoadingCache<K, CloseableLock> closeableLockFactory() {
        return BambooLocks.weakFactoryBuilder().build(new CacheLoader<K, CloseableLock>(){

            public CloseableLock load(K key) {
                return new CloseableLock();
            }
        });
    }

    public static LoadingCache<Object, ReentrantLock> weakReentrantLockFactory() {
        return BambooLocks.weakFactoryBuilder().build(REENTRANT_LOCK_FACTORY);
    }

    public static LoadingCache<Object, ReentrantReadWriteLock> weakReentrantReadWriteLockFactory() {
        return BambooLocks.weakFactoryBuilder().build(REENTRANT_READ_WRITE_LOCK_FACTORY);
    }

    private static CacheBuilder<Object, Object> weakFactoryBuilder() {
        return CacheBuilder.newBuilder().weakValues();
    }

    public static CloseableLock newCloseableLock() {
        return new CloseableLock();
    }

    public static class CloseableLock {
        final ReentrantLock lock = new ReentrantLock();

        public AutoCloseableLock lock() {
            this.lock.lock();
            return new AutoCloseableLock(this.lock);
        }

        public void tryLock(long timeout, TimeUnit unit) throws InterruptedException {
            this.lock.tryLock(timeout, unit);
        }
    }

    public static class AutoCloseableLock
    implements AutoCloseable {
        private final ReentrantLock lock;

        AutoCloseableLock(ReentrantLock lock) {
            this.lock = lock;
        }

        @Override
        public void close() {
            this.lock.unlock();
        }
    }
}

