/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.google.common.net.HostAndPort;
import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ServletUtils {
    public static List<InetAddress> getAllRequestIpAddresses(@NotNull HttpServletRequest httpServletRequest) {
        LinkedHashSet<InetAddress> result = new LinkedHashSet<InetAddress>();
        result.add(InetAddresses.forString((String)httpServletRequest.getRemoteAddr()));
        Collections.list(httpServletRequest.getHeaders("X-Forwarded-For")).stream().filter(StringUtils::isNotBlank).forEach(forwardedFor -> result.addAll(ServletUtils.splitIpAddresses(forwardedFor)));
        return new ArrayList<InetAddress>(result);
    }

    private static List<InetAddress> splitIpAddresses(@NotNull String ipAddresses) {
        return Arrays.stream(ipAddresses.split(",")).map(ip -> HostAndPort.fromString((String)ip.trim()).getHost()).map(InetAddresses::forString).collect(Collectors.toList());
    }
}

