/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import java.time.Duration;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public class InvocationLimiterResponse<T> {
    private final T value;
    private final boolean called;
    private final Duration retryAfter;

    private InvocationLimiterResponse(@Nullable T value, boolean called, @Nullable Duration retryAfter) {
        this.value = value;
        this.called = called;
        this.retryAfter = retryAfter;
    }

    public static <U> InvocationLimiterResponse<U> successful(@NotNull U value) {
        return new InvocationLimiterResponse<U>(value, true, null);
    }

    public static <U> InvocationLimiterResponse<U> rejected(@NotNull Duration retryAfter) {
        return new InvocationLimiterResponse<Object>(null, false, retryAfter);
    }

    @Nullable
    public T getValue() {
        return this.value;
    }

    public boolean isCalled() {
        return this.called;
    }

    @Nullable
    public Duration getRetryAfter() {
        return this.retryAfter;
    }
}

