/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.bamboo.utils.BambooFiles;
import com.atlassian.bamboo.utils.concurrent.AtomicUtils;
import com.google.common.base.Preconditions;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooPathUtils {
    private static EnumSet<PosixFilePermission> ALL_PERMISSIONS = EnumSet.allOf(PosixFilePermission.class);

    public static boolean deleteQuietly(@Nullable Path path) {
        if (path == null) {
            return false;
        }
        if (path.toFile().isDirectory()) {
            try {
                BambooPathUtils.cleanDirectory(path);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            BambooFiles.delete(path);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static void cleanDirectory(@NotNull Path directoryToCleanOrSymlink) throws IOException {
        IOException exception;
        Preconditions.checkArgument((boolean)directoryToCleanOrSymlink.toFile().exists(), (Object)(directoryToCleanOrSymlink + " does not exist"));
        Preconditions.checkArgument((boolean)directoryToCleanOrSymlink.toFile().isDirectory(), (Object)(directoryToCleanOrSymlink + " is not a directory"));
        Path directoryToClean = BambooPathUtils.toRealPathIfNeeded(directoryToCleanOrSymlink);
        AtomicReference<IOException> exceptionRef = new AtomicReference<IOException>();
        boolean tryHarder = false;
        Files.walkFileTree(directoryToClean, BambooPathUtils.newDeletingVisitor(directoryToClean, exceptionRef, tryHarder));
        if (exceptionRef.get() instanceof DirectoryNotEmptyException) {
            exceptionRef.set(null);
            tryHarder = true;
            Files.walkFileTree(directoryToClean, BambooPathUtils.newDeletingVisitor(directoryToClean, exceptionRef, tryHarder));
        }
        if ((exception = exceptionRef.get()) != null) {
            throw exception;
        }
    }

    @NotNull
    private static SimpleFileVisitor<Path> newDeletingVisitor(final Path directoryToClean, final AtomicReference<IOException> exceptionRef, final boolean shouldTryHarder) {
        return new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                BambooPathUtils.deleteNoThrow(file, exceptionRef);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                AtomicUtils.setIfNotNull(exceptionRef, exc);
                BambooPathUtils.deleteNoThrow(file, exceptionRef);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                PosixFileAttributeView fileAttributeView;
                if (shouldTryHarder && !dir.equals(directoryToClean) && (fileAttributeView = Files.getFileAttributeView(dir, PosixFileAttributeView.class, new LinkOption[0])) != null) {
                    fileAttributeView.setPermissions(ALL_PERMISSIONS);
                }
                return super.preVisitDirectory(dir, attrs);
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                AtomicUtils.setIfNotNull(exceptionRef, exc);
                if (!dir.equals(directoryToClean)) {
                    BambooPathUtils.deleteNoThrow(dir, exceptionRef);
                }
                return FileVisitResult.CONTINUE;
            }
        };
    }

    public static void deleteDirectory(@NotNull Path path) throws IOException {
        if (!path.toFile().exists()) {
            return;
        }
        if (!Files.isSymbolicLink(path)) {
            BambooPathUtils.cleanDirectory(path);
        }
        BambooFiles.delete(path);
    }

    public static void forceDelete(@NotNull Path path) throws IOException {
        if (path.toFile().isDirectory()) {
            BambooPathUtils.deleteDirectory(path);
        } else {
            try {
                BambooFiles.delete(path);
            }
            catch (NoSuchFileException e) {
                throw new FileNotFoundException(e.getMessage());
            }
        }
    }

    private static void deleteNoThrow(Path file, AtomicReference<IOException> exceptionRef) {
        try {
            BambooFiles.delete(file);
        }
        catch (IOException e) {
            exceptionRef.set(e);
        }
    }

    public static Path toRealPathIfNeeded(@NotNull Path maybeSymlink) throws IOException {
        return Files.isSymbolicLink(maybeSymlink) ? maybeSymlink.toRealPath(new LinkOption[0]) : maybeSymlink;
    }

    public static void writeStringToFile(Path file, String data, Charset charset) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(file, charset, new OpenOption[0]);){
            IOUtils.write((String)data, (Writer)writer);
        }
    }

    @Nullable
    public static Path toPath(@Nullable File file) {
        if (file == null) {
            return null;
        }
        return file.toPath();
    }

    public static OutputStream openOutputStream(Path file) throws IOException {
        return BambooPathUtils.openOutputStream(file, false);
    }

    public static OutputStream openOutputStream(Path file, boolean append) throws IOException {
        try {
            return BambooPathUtils.openOutputStreamInternal(file, append);
        }
        catch (IOException iOException) {
            if (file.toFile().exists()) {
                if (file.toFile().isDirectory()) {
                    throw new IOException("File '" + file + "' exists but is a directory");
                }
                if (!Files.isWritable(file)) {
                    throw new IOException("File '" + file + "' cannot be written to");
                }
            } else {
                Path parent = file.getParent();
                if (parent != null && !BambooPathUtils.mkdirs(parent) && !parent.toFile().isDirectory()) {
                    throw new IOException("Directory '" + parent + "' could not be created");
                }
            }
            return BambooPathUtils.openOutputStreamInternal(file, append);
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean contentEquals(@NotNull Path file1, @NotNull Path file2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String readFileToString(Path path, Charset encoding) throws IOException {
        return new String(Files.readAllBytes(path), encoding);
    }

    private static OutputStream openOutputStreamInternal(Path file, boolean append) throws IOException {
        return append ? Files.newOutputStream(file, StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.WRITE) : Files.newOutputStream(file, new OpenOption[0]);
    }

    private static boolean mkdirs(Path parent) {
        try {
            Files.createDirectories(parent, new FileAttribute[0]);
            return true;
        }
        catch (IOException ignored) {
            return false;
        }
    }
}

