/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs.export;

import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.vcs.export.VcsRepositoryContext;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class VcsRepositoryContextImpl
implements VcsRepositoryContext {
    private final ImmutablePlan ownerPlan;

    public VcsRepositoryContextImpl(ImmutablePlan ownerPlan) {
        this.ownerPlan = ownerPlan;
    }

    public Optional<ImmutablePlan> getOwnerPlan() {
        return Optional.ofNullable(this.ownerPlan);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static VcsRepositoryContext emptyContext() {
        return new EmptyVcsRepositoryContext();
    }

    private static final class EmptyVcsRepositoryContext
    implements VcsRepositoryContext {
        private EmptyVcsRepositoryContext() {
        }

        public Optional<ImmutablePlan> getOwnerPlan() {
            return Optional.empty();
        }
    }

    public static class Builder {
        private ImmutablePlan ownerPlan;

        private Builder() {
        }

        public Builder withOwnerPlan(ImmutablePlan ownerPlan) {
            this.ownerPlan = ownerPlan;
            return this;
        }

        public VcsRepositoryContext build() {
            return new VcsRepositoryContextImpl(this.ownerPlan);
        }
    }
}

