/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcs.export;

import com.atlassian.bamboo.configuration.external.helpers.ConfigurationMapExportHelper;
import com.atlassian.bamboo.specs.api.builders.AtlassianModule;
import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.repository.AnyVcsRepository;
import com.atlassian.bamboo.specs.api.builders.repository.VcsChangeDetection;
import com.atlassian.bamboo.specs.api.model.repository.AnyVcsRepositoryProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsChangeDetectionProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDetectionOptions;
import com.atlassian.bamboo.vcs.configuration.VcsChangeDetectionOptions;
import com.atlassian.bamboo.vcs.configuration.VcsLocationDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.export.VcsRepositoryContext;
import com.atlassian.bamboo.vcs.export.VcsRepositoryDataExporter;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultVcsRepositoryDataExporter
implements VcsRepositoryDataExporter<AnyVcsRepository, AnyVcsRepositoryProperties> {
    private static final BiMap<VcsChangeDetection.FileFilteringOption, String> FILE_PATTERN_OPTION_MAP = ImmutableBiMap.of((Object)VcsChangeDetection.FileFilteringOption.EXCLUDE_ALL, (Object)"excludeAll", (Object)VcsChangeDetection.FileFilteringOption.INCLUDE_ONLY, (Object)"includeOnly", (Object)VcsChangeDetection.FileFilteringOption.NONE, (Object)"none");
    private static final VcsChangeDetection.FileFilteringOption DEFAULT_FILE_PATTERN_OPTION = VcsChangeDetection.FileFilteringOption.NONE;

    @NotNull
    public AnyVcsRepository getEntityPropertiesBuilder(@NotNull VcsRepositoryData repositoryData) {
        return new AnyVcsRepository(new AtlassianModule(repositoryData.getPluginKey()));
    }

    @NotNull
    public AnyVcsRepository appendLocationData(@NotNull AnyVcsRepository builder, @NotNull VcsLocationDefinition vcsLocationDefinition, @NotNull VcsRepositoryContext repositoryContext) {
        return builder.serverConfiguration(ConfigurationMapExportHelper.configurationToSerializableMap(vcsLocationDefinition.getConfiguration()));
    }

    @NotNull
    public AnyVcsRepository appendBranchData(@NotNull AnyVcsRepository builder, @NotNull VcsBranchDefinition vcsBranchDefinition) {
        return builder.branchConfiguration(ConfigurationMapExportHelper.configurationToSerializableMap(vcsBranchDefinition.getConfiguration()));
    }

    @NotNull
    public AnyVcsRepository appendChangeDetectionOptions(@NotNull AnyVcsRepository builder, @NotNull VcsChangeDetectionOptions changeDetectionOptions) {
        return builder.changeDetectionConfiguration(DefaultVcsRepositoryDataExporter.exportStandardChangeDetectionOptions(changeDetectionOptions));
    }

    @NotNull
    public AnyVcsRepository appendBranchDetectionOptions(@NotNull AnyVcsRepository builder, @NotNull VcsBranchDetectionOptions branchDetectionOptions) {
        return builder.branchDetectionConfiguration(ConfigurationMapExportHelper.configurationToSerializableMap(branchDetectionOptions.getConfiguration()));
    }

    @NotNull
    public Map<String, String> importLocationData(@NotNull AnyVcsRepositoryProperties properties, @Nullable VcsLocationDefinition existingData, @NotNull VcsRepositoryContext repositoryContext) {
        if (properties.getServerConfiguration() != null) {
            return ConfigurationMapExportHelper.serializableMapToConfiguration(properties.getServerConfiguration());
        }
        return null;
    }

    @NotNull
    public Map<String, String> importBranchData(@NotNull AnyVcsRepositoryProperties properties, @Nullable VcsBranchDefinition existingData) {
        if (properties.getBranchConfiguration() != null) {
            return ConfigurationMapExportHelper.serializableMapToConfiguration(properties.getBranchConfiguration());
        }
        return null;
    }

    @NotNull
    public Map<String, String> importChangeDetectionOptions(@NotNull AnyVcsRepositoryProperties properties, @Nullable VcsChangeDetectionOptions existingData) {
        VcsChangeDetectionProperties changeDetectionConfiguration = properties.getChangeDetectionConfiguration();
        Map<String, String> changeDetectionConfigurationMap = DefaultVcsRepositoryDataExporter.importStandardChangeDetectionOptions((VcsRepositoryProperties)properties, changeDetectionConfiguration);
        if (changeDetectionConfigurationMap != null && changeDetectionConfiguration != null) {
            Map pluginChangeDetectionConfigurationMap = changeDetectionConfiguration.getConfiguration();
            if (MapUtils.isNotEmpty((Map)pluginChangeDetectionConfigurationMap)) {
                changeDetectionConfigurationMap.putAll(ConfigurationMapExportHelper.serializableMapToConfiguration(pluginChangeDetectionConfigurationMap));
            }
            return changeDetectionConfigurationMap;
        }
        return null;
    }

    @NotNull
    public Map<String, String> importBranchDetectionOptions(@NotNull AnyVcsRepositoryProperties properties, @Nullable VcsBranchDetectionOptions existingData) {
        if (properties.getBranchDetectionConfiguration() != null) {
            return ConfigurationMapExportHelper.serializableMapToConfiguration(properties.getBranchDetectionConfiguration());
        }
        return null;
    }

    @Nullable
    public static Map<String, String> importStandardChangeDetectionOptions(@NotNull VcsRepositoryProperties repositoryProperties, @Nullable VcsChangeDetectionProperties cdOptionInput) {
        VcsChangeDetectionProperties changeDetectionConfiguration = cdOptionInput;
        if (changeDetectionConfiguration == null) {
            if (!repositoryProperties.hasParent()) {
                changeDetectionConfiguration = (VcsChangeDetectionProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)new VcsChangeDetection());
            } else {
                return null;
            }
        }
        HashMap<String, String> changeDetectionConfigurationMap = new HashMap<String, String>();
        changeDetectionConfigurationMap.put("commit.isolation.option", Boolean.toString(changeDetectionConfiguration.isCommitIsolationEnabled()));
        changeDetectionConfigurationMap.put("repository.common.quietPeriod.enabled", Boolean.toString(changeDetectionConfiguration.isQuietPeriodEnabled()));
        changeDetectionConfigurationMap.put("repository.common.quietPeriod.period", String.valueOf(changeDetectionConfiguration.getQuietPeriod().getSeconds()));
        changeDetectionConfigurationMap.put("repository.common.quietPeriod.maxRetries", String.valueOf(changeDetectionConfiguration.getMaxRetries()));
        VcsChangeDetection.FileFilteringOption fileFilteringOption = changeDetectionConfiguration.getFilterFilePatternOption() != null ? changeDetectionConfiguration.getFilterFilePatternOption() : DEFAULT_FILE_PATTERN_OPTION;
        changeDetectionConfigurationMap.put("filter.pattern.option", (String)FILE_PATTERN_OPTION_MAP.get((Object)fileFilteringOption));
        changeDetectionConfigurationMap.put("filter.pattern.regex", StringUtils.defaultString((String)changeDetectionConfiguration.getFilterFilePatternRegex()));
        changeDetectionConfigurationMap.put("changeset.filter.pattern.regex", StringUtils.defaultString((String)changeDetectionConfiguration.getChangesetFilterPatternRegex()));
        return changeDetectionConfigurationMap;
    }

    public static VcsChangeDetection exportStandardChangeDetectionOptions(@NotNull VcsChangeDetectionOptions changeDetectionOptions) {
        VcsChangeDetection.FileFilteringOption fileFilteringOption = Optional.ofNullable(changeDetectionOptions.getFilterFilePatternOption()).filter(StringUtils::isNotBlank).map(arg_0 -> FILE_PATTERN_OPTION_MAP.inverse().get(arg_0)).orElse(DEFAULT_FILE_PATTERN_OPTION);
        return new VcsChangeDetection().commitIsolationEnabled(changeDetectionOptions.isCommitIsolationEnabled()).quietPeriodEnabled(changeDetectionOptions.isQuietPeriodEnabled()).quietPeriod(Duration.ofSeconds(changeDetectionOptions.getQuietPeriod())).quietPeriodMaxRetries(changeDetectionOptions.getMaxRetries()).changesetFilterPatternRegex(changeDetectionOptions.getChangesetFilterPatternRegex()).filterFilePatternOption(fileFilteringOption).filterFilePatternRegex(changeDetectionOptions.getFilterFilePatternRegex());
    }
}

