/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.trigger.export;

import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.repository.PlanRepositoryLink;
import com.atlassian.bamboo.utils.DescriptionProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TriggeringRepositoriesHelper {
    private final Map<String, Long> planRepositoriesOidToIDMap = new HashMap<String, Long>();
    private final Map<String, Long> planRepositoriesNameToIDMap;

    public TriggeringRepositoriesHelper(List<PlanRepositoryLink> planRepositoryLinks) {
        planRepositoryLinks.stream().map(PlanRepositoryLink::getRepositoryDataEntity).forEach(repository -> {
            this.planRepositoriesOidToIDMap.put(repository.getOid().toExternalValue(), repository.getId());
            if (repository.getParent() != null) {
                this.planRepositoriesOidToIDMap.put(repository.getParent().getOid().toExternalValue(), repository.getId());
            }
        });
        this.planRepositoriesNameToIDMap = planRepositoryLinks.stream().map(PlanRepositoryLink::getRepositoryDataEntity).collect(Collectors.toMap(DescriptionProvider::getName, BambooIdProvider::getId));
    }

    public Long getTriggeringRepositoryIdByOid(String oid) {
        return this.planRepositoriesOidToIDMap.get(oid);
    }

    public Long getTriggeringRepositoryIdByName(String name) {
        return this.planRepositoriesNameToIDMap.get(name);
    }
}

