/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.trigger.export;

import com.atlassian.bamboo.configuration.external.helpers.RepositoryReferenceHelper;
import com.atlassian.bamboo.specs.api.builders.trigger.RepositoryBasedTrigger;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryProperties;
import com.atlassian.bamboo.specs.api.model.trigger.RepositoryBasedTriggerProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.trigger.export.TriggerValidationContext;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class RepositoryTriggersValidator {
    public static void validateRepositoryTriggers(@NotNull TriggerValidationContext triggerValidationContext, @NotNull RepositoryBasedTriggerProperties repositoryTriggers, @NotNull List<ValidationProblem> problems) {
        if (repositoryTriggers.getTriggeringRepositoriesType() == RepositoryBasedTrigger.TriggeringRepositoriesType.ALL) {
            return;
        }
        if (repositoryTriggers.getSelectedTriggeringRepositories().isEmpty()) {
            return;
        }
        if (triggerValidationContext.getOwnerPlan().isPresent()) {
            PlanProperties topLevelPlanProperties = (PlanProperties)triggerValidationContext.getOwnerPlan().get();
            for (VcsRepositoryIdentifierProperties repositoryIdentifier : repositoryTriggers.getSelectedTriggeringRepositories()) {
                BambooOidProperties oid = repositoryIdentifier.getOid();
                String name = repositoryIdentifier.getName();
                if (oid == null && StringUtils.isBlank((CharSequence)name)) {
                    problems.add(new ValidationProblem("Can't link repository to trigger since both OID and Name are empty"));
                    continue;
                }
                Optional<VcsRepositoryProperties> referencedRepositoryInPlan = RepositoryReferenceHelper.findReferencedRepositoryInPlan(repositoryIdentifier, topLevelPlanProperties);
                if (referencedRepositoryInPlan.isPresent()) continue;
                problems.add(new ValidationProblem("Repository: " + repositoryIdentifier + " cannot be found in plan"));
            }
        } else {
            problems.add(new ValidationProblem("Can't validate RepositoryBasedTriggerProperties without plan context"));
        }
    }
}

