/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.trigger.export;

import com.atlassian.bamboo.specs.api.builders.AtlassianModule;
import com.atlassian.bamboo.specs.api.builders.trigger.AnyTrigger;
import com.atlassian.bamboo.specs.api.builders.trigger.Trigger;
import com.atlassian.bamboo.specs.api.model.trigger.AnyTriggerProperties;
import com.atlassian.bamboo.specs.api.model.trigger.RepositoryBasedTriggerProperties;
import com.atlassian.bamboo.specs.api.model.trigger.TriggerProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.trigger.TriggerDefinition;
import com.atlassian.bamboo.trigger.Triggerable;
import com.atlassian.bamboo.trigger.export.RepositoryTriggersValidator;
import com.atlassian.bamboo.trigger.export.TriggerDefinitionExporter;
import com.atlassian.bamboo.trigger.export.TriggerValidationContext;
import com.atlassian.bamboo.util.Narrow;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class DefaultTriggerDefinitionExporter
implements TriggerDefinitionExporter {
    @NotNull
    public Map<String, String> toTriggerConfiguration(@NotNull TriggerProperties triggerProperties, @NotNull Triggerable triggerable) {
        AnyTriggerProperties anyTriggerProperties = (AnyTriggerProperties)Narrow.downTo((Object)triggerProperties, AnyTriggerProperties.class);
        if (anyTriggerProperties != null) {
            return anyTriggerProperties.getConfiguration();
        }
        throw new IllegalStateException("Don't know how to import trigger properties of type: " + triggerProperties.getClass().getName());
    }

    @NotNull
    public Trigger toSpecsEntity(@NotNull TriggerDefinition triggerDefinition) {
        return new AnyTrigger(new AtlassianModule(triggerDefinition.getPluginKey())).configuration(triggerDefinition.getConfiguration());
    }

    public List<ValidationProblem> validate(@NotNull TriggerValidationContext triggerValidationContext, @NotNull TriggerProperties triggerProperties) {
        ArrayList<ValidationProblem> problems = new ArrayList<ValidationProblem>();
        RepositoryBasedTriggerProperties repositoryTriggers = (RepositoryBasedTriggerProperties)Narrow.downTo((Object)triggerProperties, RepositoryBasedTriggerProperties.class);
        if (repositoryTriggers != null) {
            RepositoryTriggersValidator.validateRepositoryTriggers(triggerValidationContext, repositoryTriggers, problems);
        }
        if (StringUtils.isBlank((CharSequence)triggerProperties.getName())) {
            problems.add(new ValidationProblem("Argument trigger name can not be blank."));
        }
        return problems;
    }
}

