/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.task.export;

import com.atlassian.bamboo.configuration.external.RssPermissions;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.specs.api.model.deployment.DeploymentProperties;
import com.atlassian.bamboo.specs.api.model.deployment.EnvironmentProperties;
import com.atlassian.bamboo.specs.api.model.plan.JobProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanProperties;
import com.atlassian.bamboo.task.export.TaskValidationContext;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public class TaskValidationContextImpl
implements TaskValidationContext {
    private final PlanProperties topLevelPlanProperties;
    private final JobProperties jobProperties;
    private final DeploymentProperties deploymentProperties;
    private final EnvironmentProperties environmentProperties;
    private final String repositoryName;
    private final RssPermissions rssPermissions;
    private final VcsBranch importedBranch;

    @Deprecated
    public TaskValidationContextImpl(PlanProperties topLevelPlanProperties, JobProperties jobProperties) {
        this(topLevelPlanProperties, jobProperties, RssPermissions.FULL_ACCESS, null);
    }

    @Deprecated
    public TaskValidationContextImpl(PlanProperties topLevelPlanProperties, JobProperties jobProperties, @NotNull RssPermissions rssPermissions, @Nullable VcsBranch importedBranch) {
        this.topLevelPlanProperties = topLevelPlanProperties;
        this.jobProperties = jobProperties;
        this.deploymentProperties = null;
        this.environmentProperties = null;
        this.rssPermissions = rssPermissions;
        this.repositoryName = null;
        this.importedBranch = importedBranch;
    }

    @Deprecated
    public TaskValidationContextImpl(DeploymentProperties deploymentProperties, EnvironmentProperties environmentProperties) {
        this(deploymentProperties, environmentProperties, RssPermissions.FULL_ACCESS);
    }

    @Deprecated
    public TaskValidationContextImpl(DeploymentProperties deploymentProperties, EnvironmentProperties environmentProperties, @NotNull RssPermissions rssPermissions) {
        this.deploymentProperties = deploymentProperties;
        this.environmentProperties = environmentProperties;
        this.topLevelPlanProperties = null;
        this.jobProperties = null;
        this.importedBranch = null;
        this.repositoryName = null;
        this.rssPermissions = rssPermissions;
    }

    public TaskValidationContextImpl(PlanProperties topLevelPlanProperties, JobProperties jobProperties, DeploymentProperties deploymentProperties, EnvironmentProperties environmentProperties, String repositoryName, RssPermissions rssPermissions, VcsBranch importedBranch) {
        this.topLevelPlanProperties = topLevelPlanProperties;
        this.jobProperties = jobProperties;
        this.deploymentProperties = deploymentProperties;
        this.environmentProperties = environmentProperties;
        this.repositoryName = repositoryName;
        this.importedBranch = importedBranch;
        this.rssPermissions = rssPermissions;
    }

    public Optional<PlanProperties> getOwnerPlan() {
        return Optional.ofNullable(this.topLevelPlanProperties);
    }

    public Optional<JobProperties> getOwnerJob() {
        return Optional.ofNullable(this.jobProperties);
    }

    public Optional<DeploymentProperties> getOwnerDeployment() {
        return Optional.ofNullable(this.deploymentProperties);
    }

    public Optional<EnvironmentProperties> getOwnerEnvironment() {
        return Optional.ofNullable(this.environmentProperties);
    }

    public Optional<String> getOwnerRepositoryName() {
        return Optional.ofNullable(this.repositoryName);
    }

    public Optional<VcsBranch> getImportedBranch() {
        return Optional.ofNullable(this.importedBranch);
    }

    @NotNull
    public RssPermissions getRssPermissions() {
        return this.rssPermissions;
    }

    public static class Builder {
        private PlanProperties topLevelPlanProperties;
        private JobProperties jobProperties;
        private DeploymentProperties deploymentProperties;
        private EnvironmentProperties environmentProperties;
        private String repositoryName;
        private RssPermissions rssPermissions = RssPermissions.FULL_ACCESS;
        private VcsBranch importedBranch;

        public Builder withContext(TaskValidationContext context) {
            this.topLevelPlanProperties = context.getOwnerPlan().orElse(null);
            this.jobProperties = context.getOwnerJob().orElse(null);
            this.deploymentProperties = context.getOwnerDeployment().orElse(null);
            this.environmentProperties = context.getOwnerEnvironment().orElse(null);
            this.repositoryName = context.getOwnerRepositoryName().orElse(null);
            this.rssPermissions = context.getRssPermissions();
            this.importedBranch = context.getImportedBranch().orElse(null);
            return this;
        }

        public Builder withPlan(PlanProperties planProperties) {
            this.topLevelPlanProperties = planProperties;
            return this;
        }

        public Builder withJob(JobProperties job) {
            this.jobProperties = job;
            return this;
        }

        public Builder withRepository(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public Builder withDeployment(DeploymentProperties deploymentProperties) {
            this.deploymentProperties = deploymentProperties;
            return this;
        }

        public Builder withEnvironment(EnvironmentProperties environment) {
            this.environmentProperties = environment;
            return this;
        }

        public TaskValidationContext build() {
            return new TaskValidationContextImpl(this.topLevelPlanProperties, this.jobProperties, this.deploymentProperties, this.environmentProperties, this.repositoryName, this.rssPermissions, this.importedBranch);
        }

        public Builder withRssPermissions(RssPermissions rssPermissions) {
            this.rssPermissions = rssPermissions;
            return this;
        }

        public Builder withBranch(VcsBranch importedBranch) {
            this.importedBranch = importedBranch;
            return this;
        }
    }
}

