/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.task.export;

import com.atlassian.bamboo.specs.api.builders.AtlassianModule;
import com.atlassian.bamboo.specs.api.builders.task.AnyTask;
import com.atlassian.bamboo.specs.api.builders.task.Task;
import com.atlassian.bamboo.specs.api.model.task.AnyTaskProperties;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.yaml.MapNode;
import com.atlassian.bamboo.specs.yaml.Node;
import com.atlassian.bamboo.specs.yaml.StringNode;
import com.atlassian.bamboo.specs.yaml.YamlSpecsValidationException;
import com.atlassian.bamboo.task.TaskContainer;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.export.TaskDefinitionExporter;
import com.atlassian.bamboo.task.export.TaskValidationContext;
import com.atlassian.bamboo.util.BambooConstantUtils;
import com.atlassian.bamboo.util.Narrow;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultTaskDefinitionExporter
implements TaskDefinitionExporter {
    @NotNull
    public Map<String, String> toTaskConfiguration(@NotNull TaskContainer taskContainer, @NotNull TaskProperties taskProperties) {
        AnyTaskProperties anyTaskProperties = (AnyTaskProperties)Narrow.downTo((Object)taskProperties, AnyTaskProperties.class);
        if (anyTaskProperties != null) {
            return anyTaskProperties.getConfiguration();
        }
        throw new IllegalStateException("Don't know how to import task properties of type: " + taskProperties.getClass().getName());
    }

    @NotNull
    public Task toSpecsEntity(TaskDefinition taskDefinition) {
        return new AnyTask(new AtlassianModule(taskDefinition.getPluginKey())).configuration(taskDefinition.getConfiguration());
    }

    @NotNull
    public List<ValidationProblem> validate(@NotNull TaskValidationContext taskValidationContext, @NotNull TaskProperties taskProperties) {
        return Collections.emptyList();
    }

    @Nullable
    public Node toYaml(@NotNull TaskProperties taskProperties) {
        if (taskProperties instanceof AnyTaskProperties) {
            AnyTaskProperties any = (AnyTaskProperties)taskProperties;
            LinkedHashMap<String, Object> config = new LinkedHashMap<String, Object>();
            config.put(Config.PLUGIN_KEY, any.getAtlassianPlugin().getCompleteModuleKey());
            LinkedHashMap filteredMap = new LinkedHashMap();
            for (Map.Entry entry : any.getConfiguration().entrySet()) {
                if (!StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
                filteredMap.put(entry.getKey(), entry.getValue());
            }
            config.put(Config.CONFIG, filteredMap);
            return new MapNode((Map)ImmutableMap.of((Object)Config.YAML_ROOT, config), ValidationContext.of((String)Config.YAML_ROOT));
        }
        return null;
    }

    @Nullable
    public AnyTask fromYaml(@NotNull Node node, @NotNull TaskValidationContext context) throws YamlSpecsValidationException {
        if (node instanceof MapNode && ((MapNode)node).getOptionalMap(Config.YAML_ROOT).isPresent()) {
            MapNode taskMap = ((MapNode)node).getMap(Config.YAML_ROOT);
            Optional pluginKeyNode = taskMap.getOptionalString(Config.PLUGIN_KEY);
            Optional configMapNode = taskMap.getOptionalMap(Config.CONFIG);
            if (pluginKeyNode.isPresent()) {
                String pluginKey = ((StringNode)pluginKeyNode.get()).get();
                AnyTask result = new AnyTask(new AtlassianModule(pluginKey));
                if (configMapNode.isPresent()) {
                    MapNode configMap = (MapNode)configMapNode.get();
                    LinkedHashMap<String, String> config = new LinkedHashMap<String, String>();
                    for (String property : configMap.getProperties()) {
                        config.put(property, configMap.getString(property).get());
                    }
                    result.configuration(config);
                }
                return result;
            }
        }
        return null;
    }

    private static interface Config {
        public static final String YAML_ROOT = (String)BambooConstantUtils.preventInlining((Object)"any-task");
        public static final String PLUGIN_KEY = (String)BambooConstantUtils.preventInlining((Object)"plugin-key");
        public static final String CONFIG = (String)BambooConstantUtils.preventInlining((Object)"configuration");
    }
}

