/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.task.export;

import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.specs.api.builders.repository.VcsRepositoryIdentifier;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryIdentifierProperties;
import com.atlassian.bamboo.task.TaskContainer;
import com.atlassian.bamboo.task.export.TaskDefinitionExporter;
import com.atlassian.bamboo.task.repository.RepositoryTaskHelper;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractRepositoryAwareTaskExporter
implements TaskDefinitionExporter {
    private static final Logger log = Logger.getLogger(AbstractRepositoryAwareTaskExporter.class);
    protected final RepositoryDefinitionManager repositoryDefinitionManager;

    public AbstractRepositoryAwareTaskExporter(@NotNull RepositoryDefinitionManager repositoryDefinitionManager) {
        this.repositoryDefinitionManager = repositoryDefinitionManager;
    }

    protected boolean isDefaultRepositoryRef(@NotNull String repositoryString) {
        return RepositoryTaskHelper.CFG_DEFAULT_REPOSITORY.equals(repositoryString);
    }

    @NotNull
    public VcsRepositoryIdentifier getNonDefaultRepositoryRef(@NotNull String repositorySelector, @NotNull Map<String, String> configuration) {
        return this.getNonDefaultRepositoryRef(configuration.get(repositorySelector));
    }

    @NotNull
    public VcsRepositoryIdentifier getNonDefaultRepositoryRef(@NotNull String repositoryString) {
        Preconditions.checkArgument((!this.isDefaultRepositoryRef(repositoryString) ? 1 : 0) != 0, (Object)"Cannot create identifier for default repository");
        long repositoryId = Long.parseLong(repositoryString);
        RepositoryDataEntity repositoryDataEntity = this.repositoryDefinitionManager.getRepositoryDataEntity(repositoryId);
        Preconditions.checkState((repositoryDataEntity != null ? 1 : 0) != 0, (String)"Repository with ID %s does not exist", (long)repositoryId);
        return new VcsRepositoryIdentifier().name(repositoryDataEntity.getName());
    }

    @NotNull
    protected String getRepositoryIdString(@NotNull VcsRepositoryIdentifierProperties repository, @NotNull TaskContainer taskContainer) {
        Predicate<VcsRepositoryData> repositoryPredicate;
        if (repository.isOidDefined()) {
            BambooEntityOid oid = BambooEntityOid.createFromExternalValue((String)repository.getOid().getOid());
            repositoryPredicate = repo -> repo.getOid().equals((Object)oid) || oid.equals((Object)repo.getParentOid());
        } else {
            repositoryPredicate = r -> r.getName().equals(repository.getName());
        }
        return this.getRepositoryListForTaskContainer(taskContainer).stream().filter(repositoryPredicate).map(BambooIdProvider::getId).map(String::valueOf).findFirst().orElseThrow(() -> new IllegalArgumentException("Repository " + repository + " not found"));
    }

    @NotNull
    @VisibleForTesting
    public List<? extends VcsRepositoryData> getRepositoryListForTaskContainer(@NotNull TaskContainer taskContainer) {
        ImmutableJob job = (ImmutableJob)Narrow.downTo((Object)taskContainer, ImmutableJob.class);
        return job != null ? this.repositoryDefinitionManager.getPlanRepositoryDefinitions((PlanIdentifier)job.getParent()) : this.repositoryDefinitionManager.getLinkedRepositories();
    }
}

