/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.yaml.properties.plan;

import com.atlassian.bamboo.configuration.external.yaml.properties.plan.Job;
import com.atlassian.bamboo.util.BambooConstantUtils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.NotNull;

@Immutable
public class Stage {
    @NotNull
    private final String name;
    @NotNull
    private final List<Job> jobs;
    private final boolean isManual;
    private final boolean isFinal;

    public Stage(@NotNull String name, @NotNull Iterable<Job> jobs, boolean isManual, boolean isFinal) {
        this.name = name;
        this.jobs = ImmutableList.copyOf(jobs);
        this.isManual = isManual;
        this.isFinal = isFinal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Stage)) {
            return false;
        }
        Stage stage = (Stage)o;
        return Objects.equals(this.jobs, stage.jobs) && Objects.equals(this.name, stage.name) && this.isManual == stage.isManual && this.isFinal == stage.isFinal;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.jobs, this.isManual, this.isFinal);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE).append(Config.NAME, (Object)this.name).append(Config.JOBS, this.jobs).append(Config.MANUAL, this.isManual).append(Config.FINAL, this.isFinal).toString();
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public List<Job> getJobs() {
        return this.jobs;
    }

    public boolean isManual() {
        return this.isManual;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public static interface Config {
        public static final String NAME = (String)BambooConstantUtils.preventInlining((Object)"name");
        public static final String JOBS = (String)BambooConstantUtils.preventInlining((Object)"jobs");
        public static final String MANUAL = (String)BambooConstantUtils.preventInlining((Object)"manual");
        public static final String FINAL = (String)BambooConstantUtils.preventInlining((Object)"final");
    }
}

