/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.yaml.properties.plan;

import com.atlassian.bamboo.configuration.external.yaml.properties.branch.MasterBranch;
import com.atlassian.bamboo.util.BambooConstantUtils;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public class Plan {
    @NotNull
    private final String projectKey;
    @NotNull
    private final String key;
    @NotNull
    private final String name;
    @Nullable
    private final MasterBranch masterBranch;

    public Plan(@NotNull String projectKey, @NotNull String key, @NotNull String name, @Nullable MasterBranch masterBranch) {
        this.projectKey = projectKey;
        this.key = key;
        this.name = name;
        this.masterBranch = masterBranch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Plan)) {
            return false;
        }
        Plan plan = (Plan)o;
        return Objects.equals(this.projectKey, plan.projectKey) && Objects.equals(this.key, plan.key) && Objects.equals(this.name, plan.name) && Objects.equals(this.masterBranch, plan.masterBranch);
    }

    public int hashCode() {
        return Objects.hash(this.projectKey, this.key, this.name, this.masterBranch);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE).append(Config.PROJECT_KEY, (Object)this.projectKey).append(Config.KEY, (Object)this.key).append(Config.NAME, (Object)this.name).append(Config.BRANCH, (Object)this.masterBranch).build();
    }

    @NotNull
    public String getProjectKey() {
        return this.projectKey;
    }

    @NotNull
    public String getKey() {
        return this.key;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public MasterBranch getMasterBranch() {
        return this.masterBranch;
    }

    public static interface Config {
        public static final String PROJECT_KEY = (String)BambooConstantUtils.preventInlining((Object)"project-key");
        public static final String KEY = (String)BambooConstantUtils.preventInlining((Object)"key");
        public static final String NAME = (String)BambooConstantUtils.preventInlining((Object)"name");
        public static final String BRANCH = (String)BambooConstantUtils.preventInlining((Object)"master-branch");
    }
}

