/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.yaml.properties.plan;

import com.atlassian.bamboo.configuration.external.yaml.properties.common.Docker;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.Requirement;
import com.atlassian.bamboo.configuration.external.yaml.properties.plan.Artifact;
import com.atlassian.bamboo.configuration.external.yaml.properties.plan.Other;
import com.atlassian.bamboo.specs.api.builders.task.Task;
import com.atlassian.bamboo.util.BambooConstantUtils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public class Job {
    @NotNull
    private final String key;
    @NotNull
    private final String name;
    @NotNull
    private final List<Task> tasks;
    @NotNull
    private final List<Task> finalTasks;
    @NotNull
    private final List<Requirement> requirements;
    @NotNull
    private final List<Artifact> artifacts;
    @Nullable
    private final Docker docker;
    @Nullable
    private final Other other;

    public Job(@NotNull String key, @NotNull String name, @NotNull Iterable<Task> tasks, @NotNull Iterable<Task> finalTasks, @NotNull Iterable<Requirement> requirements, @NotNull Iterable<Artifact> artifacts, @Nullable Docker docker, @Nullable Other other) {
        this.key = key;
        this.name = name;
        this.tasks = ImmutableList.copyOf(tasks);
        this.finalTasks = ImmutableList.copyOf(finalTasks);
        this.requirements = ImmutableList.copyOf(requirements);
        this.artifacts = ImmutableList.copyOf(artifacts);
        this.docker = docker;
        this.other = other;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Job)) {
            return false;
        }
        Job job = (Job)o;
        return Objects.equals(this.key, job.key) && Objects.equals(this.name, job.name) && Objects.equals(this.tasks, job.tasks) && Objects.equals(this.finalTasks, job.finalTasks) && Objects.equals(this.requirements, job.requirements) && Objects.equals(this.artifacts, job.artifacts) && Objects.equals(this.docker, job.docker) && Objects.equals(this.other, job.other);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.name, this.tasks, this.finalTasks, this.requirements, this.artifacts, this.docker, this.other);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE).append(Config.KEY, (Object)this.key).append(Config.NAME, (Object)this.name).append(Config.TASKS, this.tasks).append(Config.FINAL_TASKS, this.finalTasks).append(Config.REQUIREMENTS, this.requirements).append(Config.ARTIFACTS, this.artifacts).append(Config.DOCKER, (Object)this.docker).append(Config.OTHER, (Object)this.other).toString();
    }

    @NotNull
    public String getKey() {
        return this.key;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public List<Task> getTasks() {
        return this.tasks;
    }

    @NotNull
    public List<Task> getFinalTasks() {
        return this.finalTasks;
    }

    @NotNull
    public List<Requirement> getRequirements() {
        return this.requirements;
    }

    @NotNull
    public List<Artifact> getArtifacts() {
        return this.artifacts;
    }

    @Nullable
    public Docker getDocker() {
        return this.docker;
    }

    @Nullable
    public Other getOther() {
        return this.other;
    }

    public static interface Config {
        public static final String KEY = (String)BambooConstantUtils.preventInlining((Object)"key");
        public static final String NAME = (String)BambooConstantUtils.preventInlining((Object)"name");
        public static final String TASKS = (String)BambooConstantUtils.preventInlining((Object)"tasks");
        public static final String FINAL_TASKS = (String)BambooConstantUtils.preventInlining((Object)"final-tasks");
        public static final String REQUIREMENTS = (String)BambooConstantUtils.preventInlining((Object)"requirements");
        public static final String ARTIFACTS = (String)BambooConstantUtils.preventInlining((Object)"artifacts");
        public static final String DOCKER = (String)BambooConstantUtils.preventInlining((Object)"docker");
        public static final String OTHER = (String)BambooConstantUtils.preventInlining((Object)"other");
        public static final String TASK_CONDITIONS = (String)BambooConstantUtils.preventInlining((Object)"conditions");
    }
}

