/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.yaml.properties.plan;

import com.atlassian.bamboo.util.BambooConstantUtils;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public class Artifact {
    @NotNull
    private final String name;
    @Nullable
    private final String location;
    @NotNull
    private final String pattern;
    private final boolean shared;
    private final boolean required;

    public Artifact(@NotNull String name, @Nullable String location, @NotNull String pattern, boolean shared, boolean required) {
        this.name = name;
        this.location = location;
        this.pattern = pattern;
        this.shared = shared;
        this.required = required;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Artifact)) {
            return false;
        }
        Artifact artifact = (Artifact)o;
        return this.shared == artifact.shared && this.required == artifact.required && Objects.equals(this.name, artifact.name) && Objects.equals(this.location, artifact.location) && Objects.equals(this.pattern, artifact.pattern);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.location, this.pattern, this.shared, this.required);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE).append(Config.NAME, (Object)this.name).append(Config.LOCATION, (Object)this.location).append(Config.PATTERN, (Object)this.pattern).append(Config.SHARED, this.shared).append(Config.REQUIRED, this.required).toString();
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getLocation() {
        return this.location;
    }

    @NotNull
    public String getPattern() {
        return this.pattern;
    }

    public boolean isShared() {
        return this.shared;
    }

    public boolean isRequired() {
        return this.required;
    }

    public static interface Config {
        public static final String NAME = (String)BambooConstantUtils.preventInlining((Object)"name");
        public static final String LOCATION = (String)BambooConstantUtils.preventInlining((Object)"location");
        public static final String PATTERN = (String)BambooConstantUtils.preventInlining((Object)"pattern");
        public static final String SHARED = (String)BambooConstantUtils.preventInlining((Object)"shared");
        public static final String REQUIRED = (String)BambooConstantUtils.preventInlining((Object)"required");
    }
}

