/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.yaml.properties.deployment;

import com.atlassian.bamboo.util.BambooConstantUtils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.NotNull;

@Immutable
public class ReleaseNaming {
    @NotNull
    private final String nextVersionName;
    private final boolean appliesToBranches;
    private final boolean autoIncrement;
    @NotNull
    private final List<String> autoIncrementVariables;

    public ReleaseNaming(@NotNull String nextVersionName, boolean appliesToBranches, boolean autoIncrement, @NotNull Iterable<String> autoIncrementVariables) {
        this.nextVersionName = nextVersionName;
        this.appliesToBranches = appliesToBranches;
        this.autoIncrement = autoIncrement;
        this.autoIncrementVariables = ImmutableList.copyOf(autoIncrementVariables);
    }

    @NotNull
    public String getNextVersionName() {
        return this.nextVersionName;
    }

    public boolean isAppliesToBranches() {
        return this.appliesToBranches;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    @NotNull
    public List<String> getAutoIncrementVariables() {
        return this.autoIncrementVariables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReleaseNaming that = (ReleaseNaming)o;
        return this.appliesToBranches == that.appliesToBranches && this.autoIncrement == that.autoIncrement && Objects.equals(this.nextVersionName, that.nextVersionName) && Objects.equals(this.autoIncrementVariables, that.autoIncrementVariables);
    }

    public int hashCode() {
        return Objects.hash(this.nextVersionName, this.appliesToBranches, this.autoIncrement, this.autoIncrementVariables);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE).append("nextVersionName", (Object)this.nextVersionName).append("appliesToBranches", this.appliesToBranches).append("autoIncrement", this.autoIncrement).append("autoIncrementVariables", this.autoIncrementVariables).toString();
    }

    public static interface Config {
        public static final String NAME = (String)BambooConstantUtils.preventInlining((Object)"next-version-name");
        public static final String APPLIES_TO_BRANCHES = (String)BambooConstantUtils.preventInlining((Object)"applies-to-branches");
        public static final String AUTOINCREMENT = (String)BambooConstantUtils.preventInlining((Object)"auto-increment");
        public static final String AUTOINCREMENT_VARIABLES = (String)BambooConstantUtils.preventInlining((Object)"auto-increment-variables");
    }
}

