/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.yaml.properties.deployment;

import com.atlassian.bamboo.configuration.external.yaml.properties.common.Docker;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.Notification;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.Requirement;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.Trigger;
import com.atlassian.bamboo.specs.api.builders.deployment.configuration.EnvironmentPluginConfiguration;
import com.atlassian.bamboo.specs.api.builders.task.Task;
import com.atlassian.bamboo.util.BambooConstantUtils;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public class Environment {
    @NotNull
    private final String name;
    @NotNull
    private final List<Task> tasks;
    @NotNull
    private final List<Task> finalTasks;
    @NotNull
    private final Map<String, String> variables;
    @NotNull
    private final List<Requirement> requirements;
    @NotNull
    private final List<Trigger> triggers;
    @NotNull
    private final List<Notification> notifications;
    @Nullable
    private final Docker docker;
    @Nullable
    private final List<EnvironmentPluginConfiguration<?>> other;

    public Environment(@NotNull String name, @NotNull Iterable<Task> tasks, @NotNull Iterable<Task> finalTasks, @NotNull Map<String, String> variables, @NotNull Iterable<Requirement> requirements, @NotNull Iterable<Trigger> triggers, @NotNull Iterable<Notification> notifications, @Nullable Docker docker, @Nullable Iterable<? extends EnvironmentPluginConfiguration<?>> other) {
        this.name = name;
        this.tasks = ImmutableList.copyOf(tasks);
        this.finalTasks = ImmutableList.copyOf(finalTasks);
        this.variables = variables;
        this.requirements = ImmutableList.copyOf(requirements);
        this.triggers = ImmutableList.copyOf(triggers);
        this.notifications = ImmutableList.copyOf(notifications);
        this.docker = docker;
        this.other = other != null ? ImmutableList.copyOf(other) : null;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public List<Task> getTasks() {
        return this.tasks;
    }

    @NotNull
    public List<Task> getFinalTasks() {
        return this.finalTasks;
    }

    @NotNull
    public Map<String, String> getVariables() {
        return new HashMap<String, String>(this.variables);
    }

    @NotNull
    public List<Requirement> getRequirements() {
        return this.requirements;
    }

    @NotNull
    public List<Trigger> getTriggers() {
        return this.triggers;
    }

    @NotNull
    public List<Notification> getNotifications() {
        return this.notifications;
    }

    @Nullable
    public Docker getDocker() {
        return this.docker;
    }

    @Nullable
    public List<EnvironmentPluginConfiguration<?>> getOther() {
        return this.other;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Environment that = (Environment)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.tasks, that.tasks) && Objects.equals(this.finalTasks, that.finalTasks) && Objects.equals(this.variables, that.variables) && Objects.equals(this.requirements, that.requirements) && Objects.equals(this.triggers, that.triggers) && Objects.equals(this.notifications, that.notifications) && Objects.equals(this.docker, that.docker) && Objects.equals(this.other, that.other);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.tasks, this.finalTasks, this.variables, this.requirements, this.triggers, this.notifications, this.docker, this.other);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE).append("name", (Object)this.name).append(Config.TASKS, this.tasks).append(Config.FINAL_TASKS, this.finalTasks).append(Config.VARIABLES, this.variables).append(Config.REQUIREMENTS, this.requirements).append(Config.TRIGGERS, this.triggers).append(Config.NOTIFICATIONS, this.notifications).append(Config.DOCKER, (Object)this.docker).append(Config.OTHER, this.other).toString();
    }

    public static interface Config {
        public static final String TASKS = (String)BambooConstantUtils.preventInlining((Object)"tasks");
        public static final String FINAL_TASKS = (String)BambooConstantUtils.preventInlining((Object)"final-tasks");
        public static final String REQUIREMENTS = (String)BambooConstantUtils.preventInlining((Object)"requirements");
        public static final String DOCKER = (String)BambooConstantUtils.preventInlining((Object)"docker");
        public static final String VARIABLES = (String)BambooConstantUtils.preventInlining((Object)"variables");
        public static final String TRIGGERS = (String)BambooConstantUtils.preventInlining((Object)"triggers");
        public static final String NOTIFICATIONS = (String)BambooConstantUtils.preventInlining((Object)"notifications");
        public static final String OTHER = (String)BambooConstantUtils.preventInlining((Object)"other");
    }
}

