/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.yaml.properties.common.recipients;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;

@Immutable
public interface NotificationRecipients {

    public static enum NotificationRecipientType {
        USERS("users", "com.atlassian.bamboo.plugin.system.notifications:recipient.user", true),
        GROUPS("groups", "com.atlassian.bamboo.plugin.system.notifications:recipient.group", true),
        EMAILS("emails", "com.atlassian.bamboo.plugin.system.notifications:recipient.email", true),
        WEBHOOK("webhook", "com.atlassian.bamboo.plugin.system.notifications:recipient.webhook", true),
        RESPONSIBLE("responsible", "com.atlassian.bamboo.brokenbuildtracker:recipient.responsible", false),
        COMMITTERS("committers", "com.atlassian.bamboo.plugin.system.notifications:recipient.committer", false),
        WATCHERS("watchers", "com.atlassian.bamboo.plugin.system.notifications:recipient.watcher", false),
        PLUGIN("plugin", "", true);

        private final String value;
        private final String pluginKey;
        private boolean isApplicableToDeployments;

        private NotificationRecipientType(String value, String pluginKey, boolean isApplicableToDeployments) {
            this.value = value;
            this.pluginKey = pluginKey;
            this.isApplicableToDeployments = isApplicableToDeployments;
        }

        @NotNull
        public static Optional<NotificationRecipientType> fromValue(@NotNull String value) {
            return Arrays.stream(NotificationRecipientType.values()).filter(type -> Objects.equals(type.getValue(), value)).findFirst();
        }

        @NotNull
        public static Optional<NotificationRecipientType> fromPluginKey(@NotNull String pluginKey) {
            return Arrays.stream(NotificationRecipientType.values()).filter(type -> Objects.equals(type.getPluginKey(), pluginKey)).findFirst();
        }

        @NotNull
        public String getValue() {
            return this.value;
        }

        public String getPluginKey() {
            return this.pluginKey;
        }

        public boolean isDeploymentRecipientType() {
            return this.isApplicableToDeployments;
        }

        public boolean isPlanRecipientType() {
            return true;
        }
    }
}

