/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.yaml.properties.common.permissions;

import com.atlassian.bamboo.configuration.external.yaml.properties.common.permissions.Permission;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.NotNull;

@Immutable
public class PermissionSet {
    @NotNull
    private final Set<String> users;
    @NotNull
    private final Set<String> groups;
    @NotNull
    private final Set<Role> roles;
    @NotNull
    private final Set<Permission> permissions;

    public PermissionSet(@NotNull Set<String> users, @NotNull Set<String> groups, @NotNull Set<Role> roles, @NotNull Set<Permission> permissions) {
        this.users = ImmutableSet.copyOf(users);
        this.groups = ImmutableSet.copyOf(groups);
        this.permissions = ImmutableSet.copyOf(permissions);
        this.roles = ImmutableSet.copyOf(roles);
    }

    @NotNull
    public Set<String> getUsers() {
        return this.users;
    }

    @NotNull
    public Set<String> getGroups() {
        return this.groups;
    }

    @NotNull
    public Set<Permission> getPermissions() {
        return this.permissions;
    }

    public boolean isLoggedIn() {
        return this.roles.contains((Object)Role.LOGGED_IN);
    }

    public boolean isAnonymous() {
        return this.roles.contains((Object)Role.ANONYMOUS);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionSet that = (PermissionSet)o;
        return Objects.equals(this.users, that.users) && Objects.equals(this.groups, that.groups) && Objects.equals(this.roles, that.roles) && Objects.equals(this.permissions, that.permissions);
    }

    public int hashCode() {
        return Objects.hash(this.users, this.groups, this.permissions, this.roles);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE).append("users", this.users).append("groups", this.groups).append("roles", this.roles).append("permissions", this.permissions).toString();
    }

    public static interface Config {
        public static final String USERS = "users";
        public static final String GROUPS = "groups";
        public static final String PERMISSIONS = "permissions";
        public static final String ROLES = "roles";
    }

    public static enum Role {
        LOGGED_IN("logged-in"),
        ANONYMOUS("anonymous");

        private final String label;

        private Role(String label) {
            this.label = label;
        }

        public static Role byLabel(String label) {
            for (Role value : Role.values()) {
                if (!value.label.equals(label)) continue;
                return value;
            }
            throw new IllegalArgumentException("Can't find role: " + label);
        }

        public String getLabel() {
            return this.label;
        }
    }
}

