/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.yaml.properties.common.permissions;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public enum Permission {
    VIEW("view", true, true, true),
    EDIT("edit", true, true, true),
    DEPLOY("deploy", false, false, true),
    BUILD("build", true, false, false),
    CLONE("clone", true, false, false),
    ADMIN("admin", true, false, false);

    private final String label;
    private final boolean supportPlans;
    private final boolean supportDeployments;
    private final boolean supportEnvironments;

    private Permission(String label, boolean supportPlans, boolean supportDeployments, boolean supportEnvironments) {
        this.label = label;
        this.supportPlans = supportPlans;
        this.supportDeployments = supportDeployments;
        this.supportEnvironments = supportEnvironments;
    }

    @NotNull
    public static Permission byLabel(String label, Entity entity) {
        for (Permission value : Permission.values()) {
            if (!value.label.equals(label)) continue;
            return value;
        }
        throw new IllegalArgumentException("Can't find permission by label: " + label + ". Possible values are " + Permission.getPossibleValues(entity));
    }

    private static String getPossibleValues(Entity entity) {
        return Stream.of(Permission.values()).filter(perm -> perm.supports(entity)).map(Permission::getLabel).collect(Collectors.joining(","));
    }

    public String getLabel() {
        return this.label;
    }

    public boolean supports(Entity entity) {
        switch (entity) {
            case PLAN: {
                return this.supportPlans;
            }
            case DEPLOYMENT_PROJECT: {
                return this.supportDeployments;
            }
            case ENVIRONMENT: {
                return this.supportEnvironments;
            }
        }
        throw new IllegalStateException("Unknown entity: " + (Object)((Object)entity));
    }

    public static enum Entity {
        PLAN,
        DEPLOYMENT_PROJECT,
        ENVIRONMENT;

    }
}

