/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.yaml.properties.common.notifications;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;

@Immutable
public interface NotificationEvent {

    public static enum NotificationEventType {
        DEPLOYMENT_FAILED("deployment-failed", "bamboo.deployments:deploymentFailed", true),
        DEPLOYMENT_FINISHED("deployment-finished", "bamboo.deployments:deploymentFinished", true),
        DEPLOYMENT_STARTED_AND_FINISHED("deployment-started-and-finished", "bamboo.deployments:deploymentStartedFinished", true),
        PLAN_COMPLETED("plan-completed", "com.atlassian.bamboo.plugin.system.notifications:chainCompleted.allBuilds", false),
        PLAN_STATUS_CHANGED("plan-status-changed", "com.atlassian.bamboo.plugin.system.notifications:chainCompleted.changedChainStatus", false),
        PLAN_FAILED("plan-failed", "com.atlassian.bamboo.plugin.system.notifications:chainCompleted.failedChains", false),
        PLAN_COMMENT_ADDED("plan-comment-added", "com.atlassian.bamboo.plugin.system.notifications:buildCommented", false),
        PLAN_RESPONSIBILITY_CHANGED("plan-responsibility-changed", "com.atlassian.bamboo.brokenbuildtracker:responsibilityChanged", false),
        JOB_COMPLETED("job-completed", "com.atlassian.bamboo.plugin.system.notifications:buildCompleted.allBuilds", false),
        JOB_STATUS_CHANGED("job-status-changed", "com.atlassian.bamboo.plugin.system.notifications:buildCompleted.changedBuildStatus", false),
        JOB_FAILED("job-failed", "com.atlassian.bamboo.plugin.system.notifications:buildCompleted.failedBuilds", false),
        JOB_FIRST_FAILED("job-first-failed", "com.atlassian.bamboo.plugin.system.notifications:buildCompleted.firstJobFailed", false),
        JOB_ERROR("job-error", "com.atlassian.bamboo.plugin.system.notifications:buildError", false),
        JOB_HUNG("job-hung", "com.atlassian.bamboo.plugin.system.notifications:buildHung", false),
        JOB_QUEUE_TIMEOUT("job-queue-timeout", "com.atlassian.bamboo.plugin.system.notifications:buildQueueTimeout", false),
        JOB_QUEUED_WITHOUT_CAPABLE_AGENTS("job-queued-without-capable-agents", "com.atlassian.bamboo.plugin.system.notifications:buildMissingCapableAgent", false);

        private final String value;
        private final String pluginKey;
        private final boolean isApplicableToDeployments;

        private NotificationEventType(String value, String pluginKey, boolean isApplicableToDeployments) {
            this.value = value;
            this.pluginKey = pluginKey;
            this.isApplicableToDeployments = isApplicableToDeployments;
        }

        @NotNull
        public static Optional<NotificationEventType> fromValue(@NotNull String value) {
            return Arrays.stream(NotificationEventType.values()).filter(type -> Objects.equals(type.getValue(), value)).findFirst();
        }

        @NotNull
        public static Optional<NotificationEventType> fromPluginKey(@NotNull String pluginKey) {
            return Arrays.stream(NotificationEventType.values()).filter(type -> Objects.equals(type.getPluginKey(), pluginKey)).findFirst();
        }

        @NotNull
        public String getValue() {
            return this.value;
        }

        public String getPluginKey() {
            return this.pluginKey;
        }

        public boolean isDeploymentEventType() {
            return this.isApplicableToDeployments;
        }

        public boolean isPlanEventType() {
            return !this.isApplicableToDeployments;
        }
    }
}

