/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.yaml.properties.common;

import com.atlassian.bamboo.configuration.external.yaml.properties.common.notifications.BasicNotificationEvent;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.notifications.NotificationEvent;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.recipients.BasicNotificationsRecipients;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.recipients.NotificationRecipients;
import com.atlassian.bamboo.util.BambooConstantUtils;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Immutable
public class Notification {
    private final List<NotificationEvent> notificationEvents;
    private final List<NotificationRecipients> notificationRecipients;

    public Notification(List<NotificationEvent> notificationEvents, List<NotificationRecipients> notificationRecipients) {
        this.notificationEvents = ImmutableList.copyOf(notificationEvents);
        this.notificationRecipients = ImmutableList.copyOf(notificationRecipients);
    }

    public static Notification createDefaultNotification() {
        return new Notification(Collections.singletonList(new BasicNotificationEvent(NotificationEvent.NotificationEventType.PLAN_FAILED)), Arrays.asList(new BasicNotificationsRecipients(NotificationRecipients.NotificationRecipientType.RESPONSIBLE), new BasicNotificationsRecipients(NotificationRecipients.NotificationRecipientType.WATCHERS)));
    }

    public List<NotificationEvent> getNotificationEvents() {
        return this.notificationEvents;
    }

    public List<NotificationRecipients> getNotificationRecipients() {
        return this.notificationRecipients;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Notification that = (Notification)o;
        return Objects.equals(this.notificationEvents, that.notificationEvents) && Objects.equals(this.notificationRecipients, that.notificationRecipients);
    }

    public int hashCode() {
        return Objects.hash(this.notificationEvents, this.notificationRecipients);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE).append(Config.EVENTS, this.notificationEvents).append(Config.RECIPIENTS, this.notificationRecipients).toString();
    }

    public static enum Scope {
        PLAN,
        DEPLOYMENT;

    }

    public static interface Config {
        public static final String EVENTS = (String)BambooConstantUtils.preventInlining((Object)"events");
        public static final String RECIPIENTS = (String)BambooConstantUtils.preventInlining((Object)"recipients");
    }
}

