/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.yaml.properties.common;

import com.atlassian.bamboo.util.BambooConstantUtils;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.NotNull;

@Immutable
public class Docker {
    @NotNull
    private final String image;
    @NotNull
    private final Map<String, String> volumes;
    private boolean useDefaultVolumes;
    private final List<String> dockerRunArguments;

    public Docker(@NotNull String image, @NotNull Map<String, String> volumes, @NotNull List<String> dockerRunArguments, boolean useDefaultVolumes) {
        this.image = image;
        this.volumes = ImmutableMap.copyOf(volumes);
        this.useDefaultVolumes = useDefaultVolumes;
        this.dockerRunArguments = dockerRunArguments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Docker)) {
            return false;
        }
        Docker docker = (Docker)o;
        return Objects.equals(this.image, docker.image) && Objects.equals(this.volumes, docker.volumes) && Objects.equals(this.dockerRunArguments, docker.dockerRunArguments);
    }

    public int hashCode() {
        return Objects.hash(this.image, this.volumes, this.useDefaultVolumes, this.dockerRunArguments);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE).append(Config.IMAGE, (Object)this.image).append(Config.VOLUMES, this.volumes).append(Config.USE_DEFAULT_VOLUMES, this.useDefaultVolumes).append(Config.ARGUMENTS, this.dockerRunArguments).toString();
    }

    @NotNull
    public String getImage() {
        return this.image;
    }

    @NotNull
    public Map<String, String> getVolumes() {
        return this.volumes;
    }

    public boolean isUseDefaultVolumes() {
        return this.useDefaultVolumes;
    }

    @NotNull
    public List<String> getDockerRunArguments() {
        return this.dockerRunArguments;
    }

    public static interface Config {
        public static final String IMAGE = (String)BambooConstantUtils.preventInlining((Object)"image");
        public static final String VOLUMES = (String)BambooConstantUtils.preventInlining((Object)"volumes");
        public static final String USE_DEFAULT_VOLUMES = (String)BambooConstantUtils.preventInlining((Object)"use-default-volumes");
        public static final String ARGUMENTS = (String)BambooConstantUtils.preventInlining((Object)"docker-run-arguments");
    }
}

