/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.yaml.properties.branch;

import com.atlassian.bamboo.util.BambooConstantUtils;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Immutable
public class DeletePlanBranchSettings {
    public static final int DEFAULT_DELETE_TIMEOUT = 1;
    public static final int DEFAULT_INACTIVE_TIMEOUT = 30;
    public static final int DISABLED_TIMEOUT = -1;
    private final boolean enabled;
    private final int deletedDays;
    private final int inactiveDays;

    public DeletePlanBranchSettings(boolean enabled, int deletedDays, int inactiveDays) {
        this.enabled = enabled;
        this.deletedDays = deletedDays;
        this.inactiveDays = inactiveDays;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getDeletedDays() {
        return this.deletedDays;
    }

    public int getInactiveDays() {
        return this.inactiveDays;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeletePlanBranchSettings)) {
            return false;
        }
        DeletePlanBranchSettings that = (DeletePlanBranchSettings)o;
        return this.enabled == that.enabled && this.deletedDays == that.deletedDays && this.inactiveDays == that.inactiveDays;
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.deletedDays, this.inactiveDays);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE).append("enabled", this.enabled).append(Config.DELETED_DAYS, this.deletedDays).append(Config.INACTIVE_DAYS, this.inactiveDays).toString();
    }

    public static interface Config {
        public static final String DISABLED = (String)BambooConstantUtils.preventInlining((Object)"never");
        public static final String DELETED_DAYS = (String)BambooConstantUtils.preventInlining((Object)"after-deleted-days");
        public static final String INACTIVE_DAYS = (String)BambooConstantUtils.preventInlining((Object)"after-inactive-days");
    }
}

