/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.yaml.properties.branch;

import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public class CreatePlanBranchSettings {
    private final Type type;
    @Nullable
    private final String branchPattern;

    public CreatePlanBranchSettings(Type type, @Nullable String branchPattern) {
        this.type = type;
        this.branchPattern = branchPattern;
    }

    @NotNull
    public Type getType() {
        return this.type;
    }

    @Nullable
    public String getBranchPattern() {
        return this.branchPattern;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreatePlanBranchSettings)) {
            return false;
        }
        CreatePlanBranchSettings that = (CreatePlanBranchSettings)o;
        return this.type == that.type && Objects.equals(this.branchPattern, that.branchPattern);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.branchPattern});
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE).append("type", (Object)this.type).append("branchPattern", (Object)this.branchPattern).toString();
    }

    public static enum Type {
        MANUAL("manually"),
        BRANCH("for-new-branch"),
        PR("for-pull-request");

        private final String key;

        private Type(String key) {
            this.key = key;
        }

        @NotNull
        public static Type parse(String key) throws IllegalArgumentException {
            for (Type val : Type.values()) {
                if (!val.key.equals(key)) continue;
                return val;
            }
            String possibleValues = String.join((CharSequence)",", Stream.of(Type.values()).map(v -> v.key).collect(Collectors.toSet()));
            throw new IllegalArgumentException("Can't parse new plan branch type " + key + ". Possible values: " + possibleValues);
        }

        @NotNull
        public String getKey() {
            return this.key;
        }
    }
}

