/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.yaml.properties.branch;

import com.atlassian.bamboo.configuration.external.yaml.properties.branch.BranchIntegrationSettings;
import com.atlassian.bamboo.configuration.external.yaml.properties.branch.CreatePlanBranchSettings;
import com.atlassian.bamboo.configuration.external.yaml.properties.branch.DeletePlanBranchSettings;
import com.atlassian.bamboo.util.BambooConstantUtils;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public class BranchManagementConfiguration {
    private final CreatePlanBranchSettings createPlanBranchSettings;
    private final DeletePlanBranchSettings deletePlanBranchSettings;
    private final BranchIntegrationSettings branchIntegrationSettings;
    private final boolean linkToJira;

    public BranchManagementConfiguration(@NotNull CreatePlanBranchSettings createPlanBranchSettings, @Nullable DeletePlanBranchSettings deletePlanBranchSettings, @Nullable BranchIntegrationSettings branchIntegrationSettings, boolean linkToJira) {
        this.createPlanBranchSettings = createPlanBranchSettings;
        this.deletePlanBranchSettings = deletePlanBranchSettings;
        this.branchIntegrationSettings = branchIntegrationSettings;
        this.linkToJira = linkToJira;
    }

    @NotNull
    public CreatePlanBranchSettings getCreatePlanBranchSettings() {
        return this.createPlanBranchSettings;
    }

    @Nullable
    public DeletePlanBranchSettings getDeletePlanBranchSettings() {
        return this.deletePlanBranchSettings;
    }

    @Nullable
    public BranchIntegrationSettings getBranchIntegrationSettings() {
        return this.branchIntegrationSettings;
    }

    public boolean isLinkToJira() {
        return this.linkToJira;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BranchManagementConfiguration)) {
            return false;
        }
        BranchManagementConfiguration that = (BranchManagementConfiguration)o;
        return this.linkToJira == that.linkToJira && Objects.equals(this.createPlanBranchSettings, that.createPlanBranchSettings) && Objects.equals(this.deletePlanBranchSettings, that.deletePlanBranchSettings) && Objects.equals(this.branchIntegrationSettings, that.branchIntegrationSettings);
    }

    public int hashCode() {
        return Objects.hash(this.createPlanBranchSettings, this.deletePlanBranchSettings, this.branchIntegrationSettings, this.linkToJira);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE).append("createPlanBranchSettings", (Object)this.createPlanBranchSettings).append("deletePlanBranchSettings", (Object)this.deletePlanBranchSettings).append("branchIntegrationSettings", (Object)this.branchIntegrationSettings).append("linkToJira", this.linkToJira).toString();
    }

    public static interface Config {
        public static final String CREATE = (String)BambooConstantUtils.preventInlining((Object)"create");
        public static final String DELETE = (String)BambooConstantUtils.preventInlining((Object)"delete");
        public static final String INTEGRATION = (String)BambooConstantUtils.preventInlining((Object)"integration");
        public static final String LINK_TO_JIRA = (String)BambooConstantUtils.preventInlining((Object)"link-to-jira");
    }
}

