/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.yaml.properties.branch;

import com.atlassian.bamboo.util.BambooConstantUtils;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.Nullable;

@Immutable
public class BranchIntegrationSettings {
    private final Strategy strategy;
    @Nullable
    private final String branch;
    private final boolean push;

    public BranchIntegrationSettings(Strategy strategy, @Nullable String branch, boolean push) {
        this.strategy = strategy;
        this.branch = branch;
        this.push = push;
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    @Nullable
    public String getBranch() {
        return this.branch;
    }

    public boolean isPush() {
        return this.push;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BranchIntegrationSettings)) {
            return false;
        }
        BranchIntegrationSettings that = (BranchIntegrationSettings)o;
        return this.push == that.push && this.strategy == that.strategy && Objects.equals(this.branch, that.branch);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.strategy, this.branch, this.push});
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE).append("strategy", (Object)this.strategy).append("branch", (Object)this.branch).append("push", this.push).toString();
    }

    public static enum Strategy {
        BRANCH_UPDATER,
        GATEKEEPER;

    }

    public static interface Config {
        public static final String MERGE_FROM = (String)BambooConstantUtils.preventInlining((Object)"merge-from");
        public static final String MERGE_TO = (String)BambooConstantUtils.preventInlining((Object)"merge-to");
        public static final String PUSH = (String)BambooConstantUtils.preventInlining((Object)"push-on-success");
    }
}

