/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.yaml.properties;

import com.atlassian.bamboo.configuration.external.yaml.properties.BambooYamlDefinition;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.permissions.PermissionSet;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.NotNull;

@Immutable
public class BambooYamlPlanPermissionsDefinition
implements BambooYamlDefinition {
    @NotNull
    private final String planKey;
    @NotNull
    private final List<PermissionSet> permissions;

    public BambooYamlPlanPermissionsDefinition(@NotNull String planKey, @NotNull Iterable<PermissionSet> permissions) {
        this.planKey = planKey;
        this.permissions = ImmutableList.copyOf(permissions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BambooYamlPlanPermissionsDefinition that = (BambooYamlPlanPermissionsDefinition)o;
        return this.planKey.equals(that.planKey) && this.permissions.equals(that.permissions);
    }

    public int hashCode() {
        return Objects.hash(this.planKey, this.permissions);
    }

    @NotNull
    public String getPlanKey() {
        return this.planKey;
    }

    @NotNull
    public List<PermissionSet> getPermissions() {
        return this.permissions;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE).append("key", (Object)this.planKey).append("plan-permissions", this.permissions).toString();
    }

    public static interface Config {
        public static final String PLAN_PERMISSIONS = "plan-permissions";
        public static final String PLAN_KEY = "key";
    }
}

