/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.yaml.properties;

import com.atlassian.bamboo.configuration.external.yaml.properties.BambooYamlDefinition;
import com.atlassian.bamboo.configuration.external.yaml.properties.branch.BranchManagementConfiguration;
import com.atlassian.bamboo.configuration.external.yaml.properties.branch.PlanBranchConfiguration;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.Docker;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.Notification;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.Trigger;
import com.atlassian.bamboo.configuration.external.yaml.properties.plan.Plan;
import com.atlassian.bamboo.configuration.external.yaml.properties.plan.Stage;
import com.atlassian.bamboo.specs.api.builders.plan.configuration.PluginConfiguration;
import com.atlassian.bamboo.util.BambooConstantUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public class BambooYamlPlanDefinition
implements BambooYamlDefinition {
    @NotNull
    private final Plan plan;
    @NotNull
    private final List<Notification> notifications;
    @NotNull
    private final List<Stage> stages;
    @NotNull
    private final List<Trigger> triggers;
    @NotNull
    private final Map<String, String> variables;
    @Nullable
    private final List<String> labels;
    @Nullable
    private final Docker docker;
    @NotNull
    private final BranchManagementConfiguration branchManagementConfiguration;
    @Nullable
    private final PlanBranchConfiguration planBranchConfiguration;
    @Nullable
    private final List<PluginConfiguration> other;

    public BambooYamlPlanDefinition(@NotNull Plan plan, @NotNull Iterable<Stage> stages, @NotNull Iterable<Notification> notifications, @NotNull Iterable<Trigger> triggers, @NotNull Map<String, String> variables, @Nullable List<String> labels, @Nullable Docker docker, @NotNull BranchManagementConfiguration branchManagementConfiguration, @Nullable PlanBranchConfiguration planBranchConfiguration, @Nullable Iterable<PluginConfiguration> other) {
        this.plan = plan;
        this.stages = ImmutableList.copyOf(stages);
        this.notifications = ImmutableList.copyOf(notifications);
        this.triggers = ImmutableList.copyOf(triggers);
        this.variables = new LinkedHashMap<String, String>((Map<String, String>)ImmutableMap.copyOf(variables));
        this.labels = labels != null ? ImmutableList.copyOf(labels) : null;
        this.docker = docker;
        this.branchManagementConfiguration = branchManagementConfiguration;
        this.planBranchConfiguration = planBranchConfiguration;
        this.other = other != null ? ImmutableList.copyOf(other) : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BambooYamlPlanDefinition)) {
            return false;
        }
        BambooYamlPlanDefinition that = (BambooYamlPlanDefinition)o;
        return Objects.equals(this.plan, that.plan) && Objects.equals(this.stages, that.stages) && Objects.equals(this.notifications, that.notifications) && Objects.equals(this.triggers, that.triggers) && Objects.equals(this.variables, that.variables) && Objects.equals(this.labels, that.labels) && Objects.equals(this.docker, that.docker) && Objects.equals(this.branchManagementConfiguration, that.branchManagementConfiguration) && Objects.equals(this.planBranchConfiguration, that.planBranchConfiguration) && Objects.equals(this.other, that.other);
    }

    public int hashCode() {
        return Objects.hash(this.plan, this.stages, this.triggers, this.variables, this.labels, this.docker, this.branchManagementConfiguration, this.other);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE).append(Config.PLAN, (Object)this.plan).append(Config.STAGES, this.stages).append(Config.NOTIFICATIONS, this.notifications).append(Config.TRIGGERS, this.triggers).append(Config.VARIABLES, this.variables).append(Config.LABELS, this.labels).append(Config.DOCKER, (Object)this.docker).append(Config.BRANCHES, (Object)this.branchManagementConfiguration).append(Config.BRANCH_CONFIG, (Object)this.planBranchConfiguration).append(Config.OTHER, this.other).toString();
    }

    @NotNull
    public Plan getPlan() {
        return this.plan;
    }

    @NotNull
    public List<Stage> getStages() {
        return this.stages;
    }

    @NotNull
    public List<Notification> getNotifications() {
        return this.notifications;
    }

    @NotNull
    public List<Trigger> getTriggers() {
        return this.triggers;
    }

    @NotNull
    public Map<String, String> getVariables() {
        return this.variables;
    }

    @Nullable
    public List<String> getLabels() {
        return this.labels;
    }

    @Nullable
    public Docker getDocker() {
        return this.docker;
    }

    @NotNull
    public BranchManagementConfiguration getBranchManagementConfiguration() {
        return this.branchManagementConfiguration;
    }

    @Nullable
    public PlanBranchConfiguration getPlanBranchConfiguration() {
        return this.planBranchConfiguration;
    }

    @Nullable
    public List<PluginConfiguration> getOther() {
        return this.other;
    }

    public static interface Config {
        public static final String PLAN = (String)BambooConstantUtils.preventInlining((Object)"plan");
        public static final String NOTIFICATIONS = (String)BambooConstantUtils.preventInlining((Object)"notifications");
        public static final String TRIGGERS = (String)BambooConstantUtils.preventInlining((Object)"triggers");
        public static final String VARIABLES = (String)BambooConstantUtils.preventInlining((Object)"variables");
        public static final String DOCKER = (String)BambooConstantUtils.preventInlining((Object)"docker");
        public static final String STAGES = (String)BambooConstantUtils.preventInlining((Object)"stages");
        public static final String LABELS = (String)BambooConstantUtils.preventInlining((Object)"labels");
        public static final String BRANCHES = (String)BambooConstantUtils.preventInlining((Object)"branches");
        public static final String BRANCH_CONFIG = (String)BambooConstantUtils.preventInlining((Object)"branch-config");
        public static final String BRANCH_OVERRIDES = (String)BambooConstantUtils.preventInlining((Object)"branch-overrides");
        public static final String OTHER = (String)BambooConstantUtils.preventInlining((Object)"other");
    }
}

