/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.yaml.properties;

import com.atlassian.bamboo.configuration.external.yaml.properties.BambooYamlDefinition;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.permissions.PermissionSet;
import com.atlassian.bamboo.configuration.external.yaml.properties.deployment.EnvironmentPermissions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.NotNull;

@Immutable
public class BambooYamlDeploymentPermissionsDefinition
implements BambooYamlDefinition {
    @NotNull
    private final String deploymentProjectName;
    @NotNull
    private final List<PermissionSet> deploymentPermissions;
    @NotNull
    private final List<PermissionSet> defaultEnvironmentPermissions;
    @NotNull
    private final List<EnvironmentPermissions> environmentPermissions;

    public BambooYamlDeploymentPermissionsDefinition(@NotNull String deploymentProjectName, @NotNull Iterable<PermissionSet> deploymentPermissions, @NotNull Iterable<PermissionSet> defaultEnvironmentPermissions, @NotNull Iterable<EnvironmentPermissions> environmentPermissions) {
        this.deploymentProjectName = deploymentProjectName;
        this.deploymentPermissions = ImmutableList.copyOf(deploymentPermissions);
        this.defaultEnvironmentPermissions = ImmutableList.copyOf(defaultEnvironmentPermissions);
        this.environmentPermissions = ImmutableList.copyOf(environmentPermissions);
    }

    @NotNull
    public String getDeploymentProjectName() {
        return this.deploymentProjectName;
    }

    @NotNull
    public List<PermissionSet> getDeploymentPermissions() {
        return this.deploymentPermissions;
    }

    @NotNull
    public List<PermissionSet> getDefaultEnvironmentPermissions() {
        return this.defaultEnvironmentPermissions;
    }

    @NotNull
    public List<EnvironmentPermissions> getEnvironmentPermissions() {
        return this.environmentPermissions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BambooYamlDeploymentPermissionsDefinition that = (BambooYamlDeploymentPermissionsDefinition)o;
        return this.deploymentProjectName.equals(that.deploymentProjectName) && this.deploymentPermissions.equals(that.deploymentPermissions) && this.defaultEnvironmentPermissions.equals(that.defaultEnvironmentPermissions) && this.environmentPermissions.equals(that.environmentPermissions);
    }

    public int hashCode() {
        return Objects.hash(this.deploymentProjectName, this.deploymentPermissions, this.defaultEnvironmentPermissions, this.environmentPermissions);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE).append("deploymentProjectName", (Object)this.deploymentProjectName).append("deploymentPermissions", this.deploymentPermissions).append("defaultEnvironmentPermissions", this.defaultEnvironmentPermissions).append("environmentPermissions", this.environmentPermissions).toString();
    }

    public static interface Config {
        public static final String DEPLOYMENT_PERMISSIONS = "deployment-permissions";
        public static final String DEFAULT_ENVIRONMENT_PERMISSIONS = "default-environment-permissions";
        public static final String ENVIRONMENT_PERMISSIONS = "environment-permissions";
    }
}

