/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.yaml.properties;

import com.atlassian.bamboo.configuration.external.yaml.properties.BambooYamlDefinition;
import com.atlassian.bamboo.configuration.external.yaml.properties.deployment.DeploymentProject;
import com.atlassian.bamboo.configuration.external.yaml.properties.deployment.Environment;
import com.atlassian.bamboo.configuration.external.yaml.properties.deployment.ReleaseNaming;
import com.atlassian.bamboo.util.BambooConstantUtils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.NotNull;

@Immutable
public class BambooYamlDeploymentDefinition
implements BambooYamlDefinition {
    @NotNull
    private final DeploymentProject deploymentProject;
    @NotNull
    private final ReleaseNaming releaseNaming;
    @NotNull
    private final List<Environment> environments;

    public BambooYamlDeploymentDefinition(@NotNull DeploymentProject deploymentProject, @NotNull ReleaseNaming releaseNaming, @NotNull Iterable<Environment> environments) {
        this.deploymentProject = deploymentProject;
        this.releaseNaming = releaseNaming;
        this.environments = ImmutableList.copyOf(environments);
    }

    @NotNull
    public String getName() {
        return this.deploymentProject.getName();
    }

    @NotNull
    public String getSourcePlan() {
        return this.deploymentProject.getSourcePlan();
    }

    @NotNull
    public ReleaseNaming getReleaseNaming() {
        return this.releaseNaming;
    }

    @NotNull
    public List<Environment> getEnvironments() {
        return this.environments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BambooYamlDeploymentDefinition that = (BambooYamlDeploymentDefinition)o;
        return this.deploymentProject.equals(that.deploymentProject) && Objects.equals(this.releaseNaming, that.releaseNaming) && Objects.equals(this.environments, that.environments);
    }

    public int hashCode() {
        return Objects.hash(this.deploymentProject, this.releaseNaming, this.environments);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("deploymentProject", (Object)this.deploymentProject).append("releaseNaming", (Object)this.releaseNaming).append("environments", this.environments).toString();
    }

    public static interface Config {
        public static final String DEPLOYMENT = (String)BambooConstantUtils.preventInlining((Object)"deployment");
        public static final String RELEASE_NAMING = (String)BambooConstantUtils.preventInlining((Object)"release-naming");
        public static final String ENVIRONMENTS = (String)BambooConstantUtils.preventInlining((Object)"environments");
    }
}

