/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.yaml.override;

import com.atlassian.bamboo.configuration.external.RssExecutionOutputHandler;
import com.atlassian.bamboo.configuration.external.util.RssExecutionLogUtils;
import com.atlassian.bamboo.configuration.external.yaml.override.BambooYamlOverrider;
import com.atlassian.bamboo.configuration.external.yaml.properties.BambooYamlPlanDefinition;
import com.atlassian.bamboo.configuration.external.yaml.properties.plan.Stage;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.yaml.YamlSpecsValidationException;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDefinition;
import com.atlassian.utils.process.OutputHandler;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BambooYamlOverriderImpl
implements BambooYamlOverrider {
    private static final Logger log = Logger.getLogger(BambooYamlOverriderImpl.class);
    public static final ImmutableList<String> validKeys = ImmutableList.of((Object)BambooYamlPlanDefinition.Config.NOTIFICATIONS, (Object)BambooYamlPlanDefinition.Config.TRIGGERS, (Object)BambooYamlPlanDefinition.Config.VARIABLES, (Object)BambooYamlPlanDefinition.Config.DOCKER, (Object)BambooYamlPlanDefinition.Config.LABELS, (Object)BambooYamlPlanDefinition.Config.BRANCH_CONFIG);
    public static final ImmutableList<String> invalidKeys = ImmutableList.of((Object)BambooYamlPlanDefinition.Config.PLAN, (Object)BambooYamlPlanDefinition.Config.BRANCHES, (Object)BambooYamlPlanDefinition.Config.BRANCH_OVERRIDES, (Object)BambooYamlPlanDefinition.Config.OTHER);

    @Override
    public Map<String, Object> overrideMatchedBranch(@NotNull Map<String, Object> rawYamlStructure, @NotNull VcsBranchDefinition vcsBranchDefinition, @NotNull RssExecutionOutputHandler stdout) throws YamlSpecsValidationException {
        try {
            List<String> sourceOfTruth;
            log.debug((Object)"Branch overriding detected, trying to match branch...");
            String currentBranchName = vcsBranchDefinition.getVcsBranch().getName();
            Object branchOverrides = rawYamlStructure.get(BambooYamlPlanDefinition.Config.BRANCH_OVERRIDES);
            if (!(branchOverrides instanceof List)) {
                throw new YamlSpecsValidationException(String.format("'%s' should be a list", BambooYamlPlanDefinition.Config.BRANCH_OVERRIDES));
            }
            List<Pair<String, Map<String, Object>>> matchedOverrides = this.getMatchingBranches((List)branchOverrides, currentBranchName);
            if (matchedOverrides.isEmpty()) {
                String message = String.format("None of the override rules matched on the current branch '%s'.", currentBranchName);
                RssExecutionLogUtils.appendMessageToLog((OutputHandler)stdout, message);
                log.debug((Object)message);
                rawYamlStructure.remove(BambooYamlPlanDefinition.Config.BRANCH_OVERRIDES);
                return rawYamlStructure;
            }
            Pair<String, Map<String, Object>> matchedBranchOverridePair = matchedOverrides.get(0);
            Map matchedBranchOverride = (Map)matchedBranchOverridePair.getSecond();
            String message = String.format("Override rule '%s' matched the current branch '%s' and will override the configuration.", matchedBranchOverridePair.getFirst(), currentBranchName);
            RssExecutionLogUtils.appendMessageToLog((OutputHandler)stdout, message);
            log.debug((Object)message);
            validKeys.stream().filter(matchedBranchOverride::containsKey).forEach(key -> rawYamlStructure.put((String)key, matchedBranchOverride.get(key)));
            List<String> rootJobNames = this.getJobNames(rawYamlStructure);
            List<String> overrideJobNames = this.getJobNames(matchedBranchOverride);
            if (rootJobNames.size() == 0) {
                throw new YamlSpecsValidationException("At least one job should be defined in the stage declaration at the root of the YAML document");
            }
            LinkedHashMap jobs = new LinkedHashMap();
            ArrayList unusedJobs = new ArrayList();
            if (overrideJobNames.size() > 0) {
                log.debug((Object)"Using the overridden stage job list");
                sourceOfTruth = overrideJobNames;
                rawYamlStructure.put(BambooYamlPlanDefinition.Config.STAGES, matchedBranchOverride.get(BambooYamlPlanDefinition.Config.STAGES));
            } else {
                log.debug((Object)"Using the root stage job list");
                sourceOfTruth = rootJobNames;
            }
            Stream.concat(rootJobNames.stream(), overrideJobNames.stream()).distinct().forEach(jobName -> {
                if (matchedBranchOverride.containsKey(jobName)) {
                    jobs.put(jobName, matchedBranchOverride.get(jobName));
                } else if (rawYamlStructure.containsKey(jobName)) {
                    jobs.put(jobName, rawYamlStructure.get(jobName));
                }
                unusedJobs.add(jobName);
            });
            sourceOfTruth.forEach(job -> {
                rawYamlStructure.put((String)job, jobs.get(job));
                unusedJobs.remove(job);
            });
            log.debug((Object)String.format("New/overridden jobs: %s", sourceOfTruth.toString()));
            log.debug((Object)String.format("Unused jobs removed: %s", ((Object)unusedJobs).toString()));
            unusedJobs.forEach(rawYamlStructure::remove);
            rawYamlStructure.remove(BambooYamlPlanDefinition.Config.BRANCH_OVERRIDES);
            return rawYamlStructure;
        }
        catch (PropertiesValidationException e) {
            throw new YamlSpecsValidationException("Document structure is incorrect: " + e.getMessage(), (Throwable)e);
        }
    }

    @NotNull
    private List<Pair<String, Map<String, Object>>> getMatchingBranches(List<?> rawBranchOverrides, String currentBranchName) {
        return rawBranchOverrides.stream().map(branch -> {
            if (!(branch instanceof Map)) {
                throw new YamlSpecsValidationException(String.format("'%s' has wrong format. Expected map but found something else", BambooYamlPlanDefinition.Config.BRANCH_OVERRIDES));
            }
            if (((Map)branch).keySet().size() != 1) {
                throw new YamlSpecsValidationException(String.format("Every list item in '%s' should contain only one key, currently contains keys: %s", BambooYamlPlanDefinition.Config.BRANCH_OVERRIDES, ((Map)branch).keySet().toString()));
            }
            return Pair.make((Object)((String)((Map)branch).keySet().iterator().next()), ((Map)branch).values().iterator().next());
        }).filter(branch -> currentBranchName.matches((String)branch.getFirst())).limit(1L).map(matchedBranch -> {
            Object matchedBranchMap = matchedBranch.getSecond();
            if (!(matchedBranchMap instanceof Map)) {
                throw new YamlSpecsValidationException(String.format("'%s' has wrong format. Expected a map but found something else", BambooYamlPlanDefinition.Config.BRANCH_OVERRIDES));
            }
            return Pair.make((Object)matchedBranch.getFirst(), (Object)((Map)matchedBranchMap));
        }).collect(Collectors.toList());
    }

    List<String> getJobNames(Map<String, Object> rawStageStructure) {
        ArrayList<String> jobList = new ArrayList<String>();
        Object stages = rawStageStructure.get(BambooYamlPlanDefinition.Config.STAGES);
        if (stages == null) {
            return jobList;
        }
        if (!(stages instanceof List)) {
            throw new YamlSpecsValidationException(String.format("'%s' has wrong format. Expected a list but found something else", BambooYamlPlanDefinition.Config.STAGES));
        }
        for (Object stage : (List)stages) {
            if (!(stage instanceof Map)) {
                throw new YamlSpecsValidationException(String.format("'%s' has wrong format. Expected a map but found something else", BambooYamlPlanDefinition.Config.STAGES));
            }
            Set currentStage = ((Map)stage).entrySet();
            for (Map.Entry entry : currentStage) {
                Object stageStructure = entry.getValue();
                if (stageStructure instanceof List) {
                    List listOfJobs = (List)stageStructure;
                    for (Object o : listOfJobs) {
                        jobList.add(o.toString());
                    }
                    continue;
                }
                if (stageStructure instanceof Map) {
                    Object jobsList = ((Map)stageStructure).get(Stage.Config.JOBS);
                    if (!(jobsList instanceof List)) {
                        throw new YamlSpecsValidationException(String.format("%s / %s has wrong format. Expected a list but found something else", entry.getKey(), Stage.Config.JOBS));
                    }
                    List listOfJobs = (List)jobsList;
                    for (Object o : listOfJobs) {
                        jobList.add(o.toString());
                    }
                    continue;
                }
                throw new YamlSpecsValidationException("A single stage is expected to be a list of jobs or a map");
            }
        }
        return jobList;
    }
}

