/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.yaml.format;

import com.atlassian.bamboo.configuration.external.yaml.format.BambooYamlVersion1Converter;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.yaml.MapNode;
import com.atlassian.bamboo.specs.yaml.Node;
import com.atlassian.bamboo.specs.yaml.StringNode;
import com.atlassian.bamboo.specs.yaml.YamlSpecsValidationException;
import com.atlassian.bamboo.utils.i18n.I18nBean;
import com.atlassian.bamboo.utils.i18n.I18nBeanFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

public class BambooYamlVersion1ConverterImpl
implements BambooYamlVersion1Converter {
    private static final List<String> ALLOWED_TEST_PARSERS = ImmutableList.of((Object)"junit", (Object)"nunit", (Object)"testng", (Object)"mocha");
    private static final List<String> ALLOWED_SCRIPT_INTERPRETERS = ImmutableList.of((Object)"binsh_or_cmdexe", (Object)"shell", (Object)"windows_power_shell", (Object)"/bin/sh", (Object)"cmd.exe", (Object)"cmd", (Object)"powershell");
    @VisibleForTesting
    public static final String DEFAULT_SCRIPT_INTERPRETER = "binsh_or_cmdexe";
    private final I18nBean i18nBean;

    @Inject
    public BambooYamlVersion1ConverterImpl(@NotNull I18nBeanFactory i18nBeanFactory) {
        this.i18nBean = i18nBeanFactory.getI18nBean();
    }

    @Override
    @NotNull
    public Map<String, Object> convertToYamlVersion2(@NotNull Map<String, Object> rawYaml1Structure) throws YamlSpecsValidationException {
        ValidationContext validationContext = ValidationContext.empty();
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            MapNode yaml1Structure = new MapNode(rawYaml1Structure, validationContext);
            this.appendPlanIdentifier(result, yaml1Structure);
            this.appendDockerConfig(result, yaml1Structure);
            this.appendStages(result, yaml1Structure);
            List unusedProperties = yaml1Structure.getUnusedProperties();
            ImporterUtils.checkThat((String)this.i18nBean.getText("rss.import.yaml.unused.plan.properties", Collections.singletonList(Joiner.on((String)", ").join((Iterable)unusedProperties))), (boolean)unusedProperties.isEmpty());
            return result;
        }
        catch (PropertiesValidationException e) {
            throw new YamlSpecsValidationException("Document structure is incorrect: " + e.getMessage(), (Throwable)e);
        }
    }

    private void appendPlanIdentifier(@NotNull Map<String, Object> yaml2Document, @NotNull MapNode yaml1Structure) {
        MapNode projectStructure = yaml1Structure.getMap("project");
        String projectKey = projectStructure.getString("key").get();
        MapNode planStructure = projectStructure.getMap("plan");
        String planKey = planStructure.getString("key").get();
        String planName = planStructure.getString("name").get();
        yaml2Document.put("plan", ImmutableMap.of((Object)"project-key", (Object)projectKey, (Object)"key", (Object)planKey, (Object)"name", (Object)planName));
    }

    private void appendDockerConfig(@NotNull Map<String, Object> yaml2Document, @NotNull MapNode yaml1Structure) {
        yaml1Structure.getOptionalString("dockerImage").map(StringNode::get).ifPresent(dockerImage -> yaml2Document.put("docker", ImmutableMap.of((Object)"image", (Object)dockerImage)));
    }

    private void appendStages(@NotNull Map<String, Object> yaml2Document, @NotNull MapNode yaml1Structure) {
        AtomicInteger stageCounter = new AtomicInteger(1);
        AtomicInteger jobCounter = new AtomicInteger(1);
        yaml2Document.put("stages", new ArrayList());
        yaml1Structure.getList("stages", MapNode.class).stream().forEach(stageStructure -> this.appendStage(yaml2Document, (MapNode)stageStructure, stageCounter, jobCounter));
    }

    private void appendStage(@NotNull Map<String, Object> yaml2Document, @NotNull MapNode stageStructure, @NotNull AtomicInteger stageCounter, @NotNull AtomicInteger jobCounter) {
        String stageName = "Stage " + stageCounter.get();
        stageCounter.incrementAndGet();
        List stages = (List)yaml2Document.get("stages");
        ArrayList jobNames = new ArrayList();
        ImmutableMap stageConfig = ImmutableMap.of((Object)"jobs", jobNames);
        stages.add(ImmutableMap.of((Object)stageName, (Object)stageConfig));
        stageStructure.getList("jobs", MapNode.class).stream().forEach(jobStructure -> this.appendJob(yaml2Document, jobNames, (MapNode)jobStructure, jobCounter));
    }

    private void appendJob(@NotNull Map<String, Object> yaml2Document, @NotNull List<String> jobNames, @NotNull MapNode jobStructure, @NotNull AtomicInteger jobCounter) {
        String jobName = "Job " + jobCounter.get();
        String jobKey = "JOB" + jobCounter.get();
        jobCounter.incrementAndGet();
        HashMap<String, Object> jobConfig = new HashMap<String, Object>();
        ArrayList<ImmutableMap> tasks = new ArrayList<ImmutableMap>();
        jobConfig.put("key", jobKey);
        jobConfig.put("tasks", tasks);
        List scripts = jobStructure.getList("scripts", StringNode.class).stream().map(StringNode::get).collect(Collectors.toList());
        Optional interpreterNode = jobStructure.getOptionalString("interpreter");
        interpreterNode.ifPresent(node -> ImporterUtils.checkThat((ValidationContext)node.getValidationContext(), (boolean)ALLOWED_SCRIPT_INTERPRETERS.contains(node.get().toLowerCase(Locale.US)), (String)"Unknown script interpreter - %s. Available ones are: %s", (Object[])new Object[]{node.get(), String.join((CharSequence)", ", ALLOWED_SCRIPT_INTERPRETERS)}));
        String interpreter = jobStructure.getOptionalString("interpreter").map(StringNode::get).orElse(DEFAULT_SCRIPT_INTERPRETER);
        tasks.add(ImmutableMap.of((Object)"script", (Object)ImmutableMap.of((Object)"interpreter", (Object)interpreter, (Object)"scripts", scripts)));
        jobStructure.getOptionalList("testParsers", Node.class).map(testParsers -> testParsers.stream().map(this::convertTestParser).collect(Collectors.toList())).ifPresent(testParsers -> testParsers.forEach(testParser -> tasks.add(ImmutableMap.of((Object)"test-parser", (Object)testParser))));
        jobStructure.getOptionalList("requirements", StringNode.class).map(requirementsList -> requirementsList.stream().map(StringNode::get).collect(Collectors.toList())).ifPresent(requirements -> jobConfig.put("requirements", requirements));
        jobStructure.getOptionalList("artifacts", MapNode.class).map(artifactsList -> artifactsList.stream().map(this::convertArtifact).collect(Collectors.toList())).ifPresent(artifacts -> jobConfig.put("artifacts", artifacts));
        this.appendDockerConfig(jobConfig, jobStructure);
        jobNames.add(jobName);
        yaml2Document.put(jobName, jobConfig);
    }

    @NotNull
    private Map<String, Object> convertArtifact(@NotNull MapNode artifactStructure) {
        String name = artifactStructure.getString("name").get();
        String path = artifactStructure.getString("path").get();
        return ImmutableMap.of((Object)"name", (Object)name, (Object)"pattern", (Object)path, (Object)"shared", (Object)true, (Object)"required", (Object)true);
    }

    @NotNull
    private Object convertTestParser(@NotNull Node parserStructure) {
        if (parserStructure instanceof StringNode) {
            String parserType = ((StringNode)parserStructure).get();
            this.validateParserType(parserStructure.getValidationContext(), parserType);
            return parserType;
        }
        if (parserStructure instanceof MapNode) {
            Optional<List<String>> testResults;
            MapNode typedParserStructure = (MapNode)parserStructure;
            String parserType = typedParserStructure.getString("type").get();
            this.validateParserType(parserStructure.getValidationContext(), parserType);
            try {
                testResults = Optional.of(Collections.singletonList(typedParserStructure.getString("testResults").get()));
            }
            catch (PropertiesValidationException e) {
                testResults = typedParserStructure.getOptionalList("testResults", StringNode.class).map(listNode -> listNode.stream().map(StringNode::get).collect(Collectors.toList()));
            }
            HashMap<String, String> parserConfig = new HashMap<String, String>();
            parserConfig.put("type", parserType);
            testResults.ifPresent(results -> parserConfig.put("test-results", (String)results));
            return parserConfig;
        }
        throw new PropertiesValidationException(parserStructure.getValidationContext(), String.format("Element of %s should be of type String or Map. Object found instead: %s", "testParsers", parserStructure.toString()));
    }

    private void validateParserType(@NotNull ValidationContext validationContext, @NotNull String parserType) {
        ImporterUtils.checkThat((ValidationContext)validationContext, (boolean)ALLOWED_TEST_PARSERS.contains(parserType), (String)"Parser type %s is not supported. Supported types are: %s", (Object[])new Object[]{parserType, String.join((CharSequence)", ", ALLOWED_TEST_PARSERS)});
    }
}

