/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.yaml.export;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.bamboo.configuration.external.helpers.TaskDefinitionExportHelper;
import com.atlassian.bamboo.configuration.external.helpers.TriggerDefinitionExportHelper;
import com.atlassian.bamboo.configuration.external.yaml.BambooYamlVersion;
import com.atlassian.bamboo.configuration.external.yaml.export.YamlEmitter;
import com.atlassian.bamboo.configuration.external.yaml.properties.BambooYamlDeploymentDefinition;
import com.atlassian.bamboo.configuration.external.yaml.properties.BambooYamlPlanDefinition;
import com.atlassian.bamboo.configuration.external.yaml.properties.branch.BranchIntegrationSettings;
import com.atlassian.bamboo.configuration.external.yaml.properties.branch.BranchManagementConfiguration;
import com.atlassian.bamboo.configuration.external.yaml.properties.branch.CreatePlanBranchSettings;
import com.atlassian.bamboo.configuration.external.yaml.properties.branch.DeletePlanBranchSettings;
import com.atlassian.bamboo.configuration.external.yaml.properties.branch.MasterBranch;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.Docker;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.Notification;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.notifications.JobErrorNotificationEvent;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.notifications.NotificationEvent;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.notifications.PlanFailedNotificationEvent;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.permissions.Permission;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.permissions.PermissionSet;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.recipients.NotificationRecipients;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.recipients.WebhookNotificationRecipients;
import com.atlassian.bamboo.configuration.external.yaml.properties.deployment.DeploymentProject;
import com.atlassian.bamboo.configuration.external.yaml.properties.deployment.Environment;
import com.atlassian.bamboo.configuration.external.yaml.properties.deployment.ReleaseNaming;
import com.atlassian.bamboo.configuration.external.yaml.properties.plan.Artifact;
import com.atlassian.bamboo.configuration.external.yaml.properties.plan.Job;
import com.atlassian.bamboo.configuration.external.yaml.properties.plan.Other;
import com.atlassian.bamboo.configuration.external.yaml.properties.plan.Plan;
import com.atlassian.bamboo.configuration.external.yaml.properties.plan.Stage;
import com.atlassian.bamboo.deployments.configuration.CustomEnvironmentConfigPluginModuleDescriptor;
import com.atlassian.bamboo.notification.NotificationRecipientExporter;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.plugin.descriptor.NotificationRecipientModuleDescriptor;
import com.atlassian.bamboo.plugin.descriptor.TaskConditionModuleDescriptor;
import com.atlassian.bamboo.specs.api.builders.AtlassianModule;
import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.permission.PermissionType;
import com.atlassian.bamboo.specs.api.builders.requirement.Requirement;
import com.atlassian.bamboo.specs.api.builders.task.AnyTask;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationException;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.model.VariableProperties;
import com.atlassian.bamboo.specs.api.model.deployment.DeploymentProperties;
import com.atlassian.bamboo.specs.api.model.deployment.EnvironmentProperties;
import com.atlassian.bamboo.specs.api.model.deployment.ReleaseNamingProperties;
import com.atlassian.bamboo.specs.api.model.deployment.configuration.AnyPluginConfigurationProperties;
import com.atlassian.bamboo.specs.api.model.deployment.configuration.EnvironmentPluginConfigurationProperties;
import com.atlassian.bamboo.specs.api.model.docker.DockerConfigurationProperties;
import com.atlassian.bamboo.specs.api.model.label.EmptyLabelsListProperties;
import com.atlassian.bamboo.specs.api.model.label.LabelProperties;
import com.atlassian.bamboo.specs.api.model.notification.EmptyNotificationsListProperties;
import com.atlassian.bamboo.specs.api.model.notification.NotificationProperties;
import com.atlassian.bamboo.specs.api.model.notification.NotificationRecipientProperties;
import com.atlassian.bamboo.specs.api.model.notification.NotificationTypeProperties;
import com.atlassian.bamboo.specs.api.model.permission.AnonymousUserPermissionsProperties;
import com.atlassian.bamboo.specs.api.model.permission.DeploymentPermissionsProperties;
import com.atlassian.bamboo.specs.api.model.permission.EnvironmentPermissionsProperties;
import com.atlassian.bamboo.specs.api.model.permission.GroupPermissionProperties;
import com.atlassian.bamboo.specs.api.model.permission.LoggedInUserPermissionsProperties;
import com.atlassian.bamboo.specs.api.model.permission.PermissionsProperties;
import com.atlassian.bamboo.specs.api.model.permission.PlanPermissionsProperties;
import com.atlassian.bamboo.specs.api.model.permission.UserPermissionProperties;
import com.atlassian.bamboo.specs.api.model.plan.AbstractPlanProperties;
import com.atlassian.bamboo.specs.api.model.plan.JobProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanBranchIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanProperties;
import com.atlassian.bamboo.specs.api.model.plan.StageProperties;
import com.atlassian.bamboo.specs.api.model.plan.artifact.ArtifactProperties;
import com.atlassian.bamboo.specs.api.model.plan.branches.BranchCleanupProperties;
import com.atlassian.bamboo.specs.api.model.plan.branches.BranchIntegrationProperties;
import com.atlassian.bamboo.specs.api.model.plan.branches.CreatePlanBranchesProperties;
import com.atlassian.bamboo.specs.api.model.plan.branches.PlanBranchManagementProperties;
import com.atlassian.bamboo.specs.api.model.plan.condition.ConditionProperties;
import com.atlassian.bamboo.specs.api.model.plan.configuration.PluginConfigurationProperties;
import com.atlassian.bamboo.specs.api.model.plan.requirement.RequirementProperties;
import com.atlassian.bamboo.specs.api.model.repository.PlanRepositoryLinkProperties;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.model.trigger.TriggerProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.codegen.BambooSpecsGenerator;
import com.atlassian.bamboo.specs.model.notification.BuildErrorNotificationProperties;
import com.atlassian.bamboo.specs.model.notification.EmailRecipientProperties;
import com.atlassian.bamboo.specs.model.notification.GroupRecipientProperties;
import com.atlassian.bamboo.specs.model.notification.UserRecipientProperties;
import com.atlassian.bamboo.specs.model.notification.WebhookRecipientProperties;
import com.atlassian.bamboo.specs.model.notification.XFailedChainsNotificationProperties;
import com.atlassian.bamboo.specs.model.task.VcsCheckoutTaskProperties;
import com.atlassian.bamboo.specs.model.trigger.BitbucketServerTriggerProperties;
import com.atlassian.bamboo.specs.yaml.BambooYamlParserUtils;
import com.atlassian.bamboo.specs.yaml.ListNode;
import com.atlassian.bamboo.specs.yaml.MapNode;
import com.atlassian.bamboo.specs.yaml.Node;
import com.atlassian.bamboo.specs.yaml.StringNode;
import com.atlassian.bamboo.specs.yaml.YamlSpecsValidationException;
import com.atlassian.bamboo.task.condition.TaskCondition;
import com.atlassian.bamboo.task.export.DefaultTaskDefinitionExporter;
import com.atlassian.bamboo.task.export.TaskDefinitionExporter;
import com.atlassian.bamboo.trigger.export.DefaultTriggerDefinitionExporter;
import com.atlassian.bamboo.trigger.export.TriggerDefinitionExporter;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.ImportExportAwarePlugin;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.predicate.EnabledModulePredicate;
import com.atlassian.plugin.predicate.ModuleDescriptorOfClassPredicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class YamlEmitterImpl
implements YamlEmitter {
    private static final Logger log = Logger.getLogger(YamlEmitterImpl.class);
    private static final String YAML_COMMENT_PLACEHOLDER = "i_M_BaMboO_cOmMeNt_IgNoRe_Me";
    private static final String COMMENT_PATTERN = "\\s*[-]*\\s+i_M_BaMboO_cOmMeNt_IgNoRe_Me:";
    private final PluginAccessor pluginAccessor;
    private final CachedPlanManager cachedPlanManager;
    private final TaskDefinitionExportHelper taskDefinitionExporterHelper;
    private final TriggerDefinitionExportHelper triggerDefinitionExportHelper;

    @Inject
    public YamlEmitterImpl(CachedPlanManager cachedPlanManager, PluginAccessor pluginAccessor, TaskDefinitionExportHelper taskDefinitionExporterHelper, TriggerDefinitionExportHelper triggerDefinitionExportHelper) {
        this.cachedPlanManager = cachedPlanManager;
        this.pluginAccessor = pluginAccessor;
        this.taskDefinitionExporterHelper = taskDefinitionExporterHelper;
        this.triggerDefinitionExportHelper = triggerDefinitionExportHelper;
    }

    @Override
    @NotNull
    public String emitYamlDocuments(@NotNull List<? extends EntityProperties> entityPropertiesList) throws CodeGenerationException {
        StringBuilder sb = new StringBuilder();
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setDefaultScalarStyle(DumperOptions.ScalarStyle.PLAIN);
        options.setSplitLines(false);
        options.setExplicitStart(true);
        int index = 0;
        ArrayList<EntityProperties> documents = new ArrayList<EntityProperties>();
        LinkedHashMap<String, AllDeploymentPermissions> deploymentPermissionsDocuments = new LinkedHashMap<String, AllDeploymentPermissions>();
        Function<String, AllDeploymentPermissions> createDeploymentPermissionsObj = k -> {
            AllDeploymentPermissions allDeploymentPermissions = new AllDeploymentPermissions();
            documents.add((EntityProperties)allDeploymentPermissions);
            return allDeploymentPermissions;
        };
        for (EntityProperties entityProperties : entityPropertiesList) {
            if (entityProperties instanceof DeploymentPermissionsProperties) {
                DeploymentPermissionsProperties deploymentPermissionsProperties = (DeploymentPermissionsProperties)entityProperties;
                deploymentPermissionsDocuments.computeIfAbsent(deploymentPermissionsProperties.getDeploymentName(), createDeploymentPermissionsObj).setDeploymentPermissions(deploymentPermissionsProperties);
                continue;
            }
            if (entityProperties instanceof EnvironmentPermissionsProperties) {
                EnvironmentPermissionsProperties environmentPermissionsProperties = (EnvironmentPermissionsProperties)entityProperties;
                deploymentPermissionsDocuments.computeIfAbsent(environmentPermissionsProperties.getDeploymentName(), createDeploymentPermissionsObj).addEnvironmentPermissions(environmentPermissionsProperties);
                continue;
            }
            documents.add(entityProperties);
        }
        for (Object object : documents) {
            log.debug((Object)("Export to YAML: " + object));
            options.setExplicitEnd(index + 1 == documents.size());
            if (object instanceof BambooSpecsGenerator.Comment) {
                options.setExplicitStart(false);
            }
            Yaml yaml = new Yaml(options);
            if (object instanceof PlanProperties) {
                sb.append(this.emitYamlForPlan(yaml, (PlanProperties)object));
            } else if (object instanceof PlanPermissionsProperties) {
                sb.append(this.emitYamlForPlanPermissions(yaml, (PlanPermissionsProperties)object));
            } else if (object instanceof DeploymentProperties) {
                sb.append(this.emitYamlForDeploymentProject(yaml, (DeploymentProperties)object));
            } else if (object instanceof AllDeploymentPermissions) {
                sb.append(this.emitYamlForDeploymentPermissions(yaml, (AllDeploymentPermissions)object));
            } else if (object instanceof BambooSpecsGenerator.Comment) {
                sb.append("# ");
                sb.append(object.toString());
                sb.append('\n');
                if (index + 1 == documents.size()) {
                    sb.append("...\n");
                }
            } else {
                sb.append("# Export of entity of type ").append(object.getClass().getName()).append(" is not supported \n");
            }
            ++index;
        }
        return sb.toString();
    }

    private String emitYamlForDeploymentProject(@NotNull Yaml yaml, @NotNull DeploymentProperties deploymentProperties) {
        Map<String, Object> data = this.newDocument();
        data.put(BambooYamlDeploymentDefinition.Config.DEPLOYMENT, this.dumpDeploymentInfo(deploymentProperties));
        data.put(BambooYamlDeploymentDefinition.Config.RELEASE_NAMING, this.dumpReleaseNaming(deploymentProperties.getReleaseNaming()));
        data.put(BambooYamlDeploymentDefinition.Config.ENVIRONMENTS, this.dumpEnvironmentList(deploymentProperties.getEnvironments()));
        EmitterContext context = new EmitterContext();
        deploymentProperties.getEnvironments().forEach(e -> data.put(e.getName(), this.dumpEnvironment((EnvironmentProperties)e, context)));
        return this.dumpToYamlString(yaml, data, context);
    }

    @NotNull
    public String emitYamlForPlan(Yaml yaml, PlanProperties planProperties) throws CodeGenerationException {
        Map<String, Object> data = this.newDocument();
        log.debug((Object)("started to export plan " + planProperties.getKey()));
        data.put(BambooYamlPlanDefinition.Config.PLAN, this.dumpPlanInfo(planProperties));
        data.put(BambooYamlPlanDefinition.Config.STAGES, this.dumpStages(planProperties.getStages()));
        EmitterContext context = new EmitterContext();
        this.dumpJobs(data, planProperties.getStages(), context);
        Map<String, String> variables = this.dumpVariables(planProperties.getVariables());
        if (!variables.isEmpty()) {
            data.put(BambooYamlPlanDefinition.Config.VARIABLES, variables);
        }
        this.dumpPlanTriggers(planProperties, data);
        data.put(BambooYamlPlanDefinition.Config.BRANCHES, this.dumpBranchManagement(planProperties));
        data.put(BambooYamlPlanDefinition.Config.NOTIFICATIONS, this.dumpNotifications(planProperties.getNotifications()));
        data.put(BambooYamlPlanDefinition.Config.LABELS, this.dumpLabels(planProperties.getLabels()));
        this.dumpOtherConfig(data, planProperties);
        String result = this.dumpToYamlString(yaml, data, context);
        log.debug((Object)("finished plan export " + planProperties.getKey()));
        return result;
    }

    @NotNull
    public String emitYamlForPlanPermissions(@NotNull Yaml yaml, @NotNull PlanPermissionsProperties planPermissions) {
        Map<String, Object> data = this.newDocument();
        data.put(BambooYamlPlanDefinition.Config.PLAN, this.dumpPlanReference(planPermissions));
        data.put("plan-permissions", this.dumpPermissions(planPermissions.getPermissions(), false));
        return this.dumpToYamlString(yaml, data, new EmitterContext());
    }

    private void dumpPlanTriggers(PlanProperties planProperties, Map<String, Object> data) {
        TriggerProperties trigger;
        if (planProperties.getTriggers().size() == 1 && (trigger = (TriggerProperties)planProperties.getTriggers().iterator().next()) instanceof BitbucketServerTriggerProperties) {
            log.debug((Object)"found BBS trigger, skip trigger section declaration");
            return;
        }
        data.put(BambooYamlPlanDefinition.Config.TRIGGERS, this.dumpTriggers(planProperties.getTriggers()));
    }

    private Map<String, String> dumpPlanReference(PlanPermissionsProperties planPermissions) {
        PlanKey key = PlanKeys.getPlanKey((String)planPermissions.getPlanIdentifier().getProjectKey().getKey(), (String)planPermissions.getPlanIdentifier().getKey().getKey());
        return ImmutableMap.of((Object)"key", (Object)key.getKey());
    }

    @NotNull
    private String emitYamlForDeploymentPermissions(@NotNull Yaml yaml, @NotNull AllDeploymentPermissions deploymentPermissions) {
        Map<String, Object> data = this.newDocument();
        data.put(BambooYamlDeploymentDefinition.Config.DEPLOYMENT, this.dumpDeploymentReference(deploymentPermissions));
        if (deploymentPermissions.getDeploymentPermissions() != null) {
            data.put("deployment-permissions", this.dumpPermissions(deploymentPermissions.getDeploymentPermissions().getPermissions(), true));
        }
        if (!deploymentPermissions.getEnvironmentPermissions().isEmpty()) {
            ArrayList<ImmutableMap> envPermissionsList = new ArrayList<ImmutableMap>();
            for (EnvironmentPermissionsProperties environmentPermissions : deploymentPermissions.getEnvironmentPermissions()) {
                envPermissionsList.add(ImmutableMap.of((Object)environmentPermissions.getEnvironmentName(), this.dumpPermissions(environmentPermissions.getPermissions(), true)));
            }
            data.put("environment-permissions", envPermissionsList);
        }
        return this.dumpToYamlString(yaml, data, new EmitterContext());
    }

    private Map<String, String> dumpDeploymentReference(@NotNull AllDeploymentPermissions deploymentPermissions) {
        String name = deploymentPermissions.getDeploymentPermissions() != null ? deploymentPermissions.getDeploymentPermissions().getDeploymentName() : deploymentPermissions.getEnvironmentPermissions().get(0).getDeploymentName();
        return ImmutableMap.of((Object)DeploymentProject.Config.NAME, (Object)name);
    }

    private List<Map<String, Object>> dumpPermissions(@NotNull PermissionsProperties permissionsProperties, boolean forDeployment) {
        LoggedInUserPermissionsProperties loggedInUserPermissions;
        ArrayList<Map<String, Object>> permissions = new ArrayList<Map<String, Object>>();
        HashMultimap permissionTypesToIdentities = HashMultimap.create();
        for (GroupPermissionProperties groupPermissionProperties : permissionsProperties.getGroupPermissions()) {
            if (groupPermissionProperties.getPermissionTypes().isEmpty()) continue;
            permissionTypesToIdentities.put(EnumSet.copyOf(groupPermissionProperties.getPermissionTypes()), (Object)groupPermissionProperties);
        }
        for (UserPermissionProperties userPermissionProperties : permissionsProperties.getUserPermissions()) {
            if (userPermissionProperties.getPermissionTypes().isEmpty()) continue;
            permissionTypesToIdentities.put(EnumSet.copyOf(userPermissionProperties.getPermissionTypes()), (Object)userPermissionProperties);
        }
        AnonymousUserPermissionsProperties anonymousUserPermissionsProperties = permissionsProperties.getAnonymousUserPermissions();
        if (!anonymousUserPermissionsProperties.getPermissionTypes().isEmpty()) {
            permissionTypesToIdentities.put(EnumSet.copyOf(anonymousUserPermissionsProperties.getPermissionTypes()), (Object)anonymousUserPermissionsProperties);
        }
        if (!(loggedInUserPermissions = permissionsProperties.getLoggedInUserPermissions()).getPermissionTypes().isEmpty()) {
            permissionTypesToIdentities.put(EnumSet.copyOf(loggedInUserPermissions.getPermissionTypes()), (Object)loggedInUserPermissions);
        }
        for (EnumSet permissionTypes : permissionTypesToIdentities.keySet()) {
            LinkedHashMap<String, List<Object>> permissionMap = new LinkedHashMap<String, List<Object>>();
            Collection identities = permissionTypesToIdentities.get((Object)permissionTypes);
            List users = BambooIterables.stream((Iterable)identities).filter(UserPermissionProperties.class::isInstance).map(UserPermissionProperties.class::cast).collect(Collectors.toList());
            if (!users.isEmpty()) {
                permissionMap.put("users", users.stream().map(UserPermissionProperties::getUsername).collect(Collectors.toList()));
            }
            List groups = BambooIterables.stream((Iterable)identities).filter(GroupPermissionProperties.class::isInstance).map(GroupPermissionProperties.class::cast).collect(Collectors.toList());
            if (!groups.isEmpty()) {
                permissionMap.put("groups", groups.stream().map(GroupPermissionProperties::getGroup).collect(Collectors.toList()));
            }
            ArrayList<String> roles = new ArrayList<String>();
            if (BambooIterables.stream((Iterable)identities).anyMatch(LoggedInUserPermissionsProperties.class::isInstance)) {
                roles.add(PermissionSet.Role.LOGGED_IN.getLabel());
            }
            if (BambooIterables.stream((Iterable)identities).anyMatch(AnonymousUserPermissionsProperties.class::isInstance)) {
                roles.add(PermissionSet.Role.ANONYMOUS.getLabel());
            }
            if (!roles.isEmpty()) {
                permissionMap.put("roles", roles);
            }
            Function<PermissionType, String> type2StringFunction = forDeployment ? p -> {
                if (p == PermissionType.BUILD) {
                    return Permission.DEPLOY.getLabel();
                }
                return p.name();
            } : Enum::name;
            permissionMap.put("permissions", permissionTypes.stream().map(type2StringFunction).map(s -> s.toLowerCase(Locale.ENGLISH)).collect(Collectors.toList()));
            permissions.add(permissionMap);
        }
        return permissions;
    }

    @NotNull
    private String dumpToYamlString(@NotNull Yaml yaml, @NotNull Map<String, Object> data, EmitterContext context) {
        String result = this.seedWithComments(yaml.dump(data));
        return this.handleNodesWithCommentsOnly(result, context);
    }

    private String handleNodesWithCommentsOnly(String yaml, EmitterContext context) {
        String result = yaml;
        if (context.hasTasks && !context.hasKnownTasks) {
            result = result.replaceAll(" " + Job.Config.TASKS + ":", " " + Job.Config.TASKS + ": []");
        }
        if (context.hasFinalTasks && !context.hasKnownFinalTasks) {
            result = result.replaceAll(" " + Job.Config.FINAL_TASKS + ":", " " + Job.Config.FINAL_TASKS + ": []");
        }
        return result;
    }

    private Map<String, Object> newDocument() {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put(BambooYamlParserUtils.CFG_VERSION, Long.valueOf(BambooYamlVersion.VERSION_2.getVersion()));
        return data;
    }

    private String seedWithComments(String text) {
        return text.replaceAll(COMMENT_PATTERN, "\n#");
    }

    private List<Map<String, Object>> dumpNotifications(List<NotificationProperties> notifications) {
        ArrayList<Map<String, Object>> notificationsList = new ArrayList<Map<String, Object>>();
        for (NotificationProperties notification : notifications) {
            LinkedHashMap notificationConfig = new LinkedHashMap();
            if (notification instanceof EmptyNotificationsListProperties) break;
            notificationConfig.put(Notification.Config.EVENTS, Collections.singletonList(this.parseNotificationEventTypes(notification.getType())));
            notificationConfig.put(Notification.Config.RECIPIENTS, this.parseNotificationRecipients(notification.getRecipients()));
            notificationsList.add(notificationConfig);
        }
        return notificationsList;
    }

    private List<?> parseNotificationRecipients(List<NotificationRecipientProperties> recipientsList) {
        ArrayList<Object> recipients = new ArrayList<Object>();
        for (NotificationRecipientProperties notificationRecipient : recipientsList) {
            if (notificationRecipient instanceof UserRecipientProperties) {
                UserRecipientProperties user = (UserRecipientProperties)notificationRecipient;
                recipients.add(ImmutableMap.of((Object)NotificationRecipients.NotificationRecipientType.USERS.getValue(), Collections.singletonList(user.getUserName())));
                continue;
            }
            if (notificationRecipient instanceof GroupRecipientProperties) {
                GroupRecipientProperties group = (GroupRecipientProperties)notificationRecipient;
                recipients.add(ImmutableMap.of((Object)NotificationRecipients.NotificationRecipientType.GROUPS.getValue(), Collections.singletonList(group.getGroupName())));
                continue;
            }
            if (notificationRecipient instanceof EmailRecipientProperties) {
                EmailRecipientProperties email = (EmailRecipientProperties)notificationRecipient;
                recipients.add(ImmutableMap.of((Object)NotificationRecipients.NotificationRecipientType.EMAILS.getValue(), Collections.singletonList(email.getEmail())));
                continue;
            }
            if (notificationRecipient instanceof WebhookRecipientProperties) {
                WebhookRecipientProperties webhook = (WebhookRecipientProperties)notificationRecipient;
                recipients.add(ImmutableMap.of((Object)NotificationRecipients.NotificationRecipientType.WEBHOOK.getValue(), (Object)ImmutableMap.of((Object)WebhookNotificationRecipients.Config.NAME, (Object)webhook.getWebhookName(), (Object)WebhookNotificationRecipients.Config.URL, (Object)webhook.getUrl())));
                continue;
            }
            String pluginKey = notificationRecipient.getAtlassianPlugin().getCompleteModuleKey();
            Optional<NotificationRecipients.NotificationRecipientType> notificationRecipientType = NotificationRecipients.NotificationRecipientType.fromPluginKey(pluginKey);
            if (notificationRecipientType.isPresent()) {
                recipients.add(notificationRecipientType.get().getValue());
                continue;
            }
            boolean foundPlugin = this.dumpNotificationForPlugins(recipients, notificationRecipient, pluginKey);
            if (foundPlugin) continue;
            recipients.add(YamlEmitterImpl.comment(String.format("Notification recipient %s is not supported yet", pluginKey)));
        }
        return recipients;
    }

    private boolean dumpNotificationForPlugins(List recipients, final NotificationRecipientProperties notificationRecipient, String pluginKey) {
        Collection moduleDescriptors = this.pluginAccessor.getModuleDescriptors(new ModuleDescriptorOfClassPredicate(NotificationRecipientModuleDescriptor.class).and((Predicate)new EnabledModulePredicate()).and(notificationRecipientModuleDescriptor -> pluginKey.equals(notificationRecipientModuleDescriptor.getCompleteKey())));
        for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
            Node recipient;
            NotificationRecipientModuleDescriptor notificationRecipientModuleDescriptor2 = (NotificationRecipientModuleDescriptor)moduleDescriptor;
            final NotificationRecipientExporter exporter = notificationRecipientModuleDescriptor2.getExporter();
            if (exporter == null || (recipient = (Node)BambooPluginUtils.callUnsafeCode((BambooPluginUtils.Callable)new BambooPluginUtils.Callable<Node>("Error"){

                @Nullable
                public Node call() {
                    return exporter.toYaml(notificationRecipient);
                }
            })) == null) continue;
            Object result = YamlEmitterImpl.readProperty(recipient);
            if (result instanceof List) {
                recipients.add(YamlEmitterImpl.comment(pluginKey + " produced unsupported ListNode recipient"));
                continue;
            }
            recipients.add(result);
            return true;
        }
        return false;
    }

    @VisibleForTesting
    @NotNull
    public static Object readProperty(@NotNull Node node) {
        if (node instanceof StringNode) {
            return ((StringNode)node).get();
        }
        if (node instanceof MapNode) {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            MapNode mapNode = (MapNode)node;
            for (String property : mapNode.getProperties()) {
                result.put(property, YamlEmitterImpl.readProperty(mapNode.getNode(property)));
            }
            return result;
        }
        if (node instanceof ListNode) {
            ListNode listNode = (ListNode)node;
            ArrayList<Object> result = new ArrayList<Object>();
            for (Node o : listNode.getList()) {
                result.add(YamlEmitterImpl.readProperty(o));
            }
            return result;
        }
        return YamlEmitterImpl.comment("unknown node type " + node);
    }

    private Object parseNotificationEventTypes(NotificationTypeProperties type) {
        if (type instanceof BuildErrorNotificationProperties) {
            BuildErrorNotificationProperties buildErrorNotificationProperties = (BuildErrorNotificationProperties)type;
            if (buildErrorNotificationProperties.isFirstOccurrenceOnly()) {
                return NotificationEvent.NotificationEventType.JOB_ERROR.getValue();
            }
            return ImmutableMap.of((Object)NotificationEvent.NotificationEventType.JOB_ERROR.getValue(), (Object)ImmutableMap.of((Object)JobErrorNotificationEvent.Config.FIRST_ONLY, (Object)false));
        }
        if (type instanceof XFailedChainsNotificationProperties) {
            XFailedChainsNotificationProperties failedChainsNotificationProperties = (XFailedChainsNotificationProperties)type;
            if (failedChainsNotificationProperties.getNumberOfFailures() > 1) {
                return ImmutableMap.of((Object)NotificationEvent.NotificationEventType.PLAN_FAILED.getValue(), (Object)ImmutableMap.of((Object)PlanFailedNotificationEvent.Config.FAILURES, (Object)failedChainsNotificationProperties.getNumberOfFailures()));
            }
            return NotificationEvent.NotificationEventType.PLAN_FAILED.getValue();
        }
        Optional<NotificationEvent.NotificationEventType> notificationEventType = NotificationEvent.NotificationEventType.fromPluginKey(type.getAtlassianPlugin().getCompleteModuleKey());
        if (notificationEventType.isPresent()) {
            return notificationEventType.get().getValue();
        }
        return YamlEmitterImpl.comment("Notification type " + type.getAtlassianPlugin().getCompleteModuleKey() + " is not supported yet");
    }

    public static Map<String, String> comment(String commentText) {
        return ImmutableMap.of((Object)YAML_COMMENT_PLACEHOLDER, (Object)commentText);
    }

    private Map<String, Object> dumpBranchManagement(PlanProperties planProperties) throws CodeGenerationException {
        BranchIntegrationProperties branchIntegrationProperties;
        BranchCleanupProperties deletePlanBranch;
        PlanBranchManagementProperties managementProperties = planProperties.getPlanBranchManagementProperties();
        LinkedHashMap<String, Object> branchConfig = new LinkedHashMap<String, Object>();
        CreatePlanBranchesProperties createPlanBranch = managementProperties.getCreatePlanBranch();
        if (createPlanBranch != null) {
            CreatePlanBranchesProperties.Trigger trigger = createPlanBranch.getTrigger();
            switch (trigger) {
                case MANUAL: {
                    branchConfig.put(BranchManagementConfiguration.Config.CREATE, CreatePlanBranchSettings.Type.MANUAL.getKey());
                    break;
                }
                case PULL_REQUEST: {
                    branchConfig.put(BranchManagementConfiguration.Config.CREATE, CreatePlanBranchSettings.Type.PR.getKey());
                    break;
                }
                case BRANCH: {
                    String matchingPattern = createPlanBranch.getMatchingPattern();
                    if (StringUtils.isBlank((CharSequence)matchingPattern)) {
                        branchConfig.put(BranchManagementConfiguration.Config.CREATE, CreatePlanBranchSettings.Type.BRANCH.getKey());
                        break;
                    }
                    LinkedHashMap<String, String> branchCreateMap = new LinkedHashMap<String, String>();
                    branchCreateMap.put(CreatePlanBranchSettings.Type.BRANCH.getKey(), matchingPattern);
                    branchConfig.put(BranchManagementConfiguration.Config.CREATE, branchCreateMap);
                    break;
                }
                default: {
                    branchConfig.putAll(YamlEmitterImpl.comment("Unknown plan branch creation trigger " + trigger));
                }
            }
        }
        if ((deletePlanBranch = managementProperties.getDeletePlanBranch()) != null) {
            boolean removeDeletedFromRepository = deletePlanBranch.isRemoveDeletedFromRepository();
            boolean removeInactiveInRepository = deletePlanBranch.isRemoveInactiveInRepository();
            if (!removeDeletedFromRepository && !removeInactiveInRepository) {
                branchConfig.put(BranchManagementConfiguration.Config.DELETE, DeletePlanBranchSettings.Config.DISABLED);
            } else {
                HashMap<String, Object> deleteConfig = new HashMap<String, Object>();
                if (removeDeletedFromRepository) {
                    deleteConfig.put(DeletePlanBranchSettings.Config.DELETED_DAYS, deletePlanBranch.getRemoveDeletedFromRepositoryPeriod().toDays());
                } else {
                    deleteConfig.put(DeletePlanBranchSettings.Config.DELETED_DAYS, DeletePlanBranchSettings.Config.DISABLED);
                }
                if (removeInactiveInRepository) {
                    deleteConfig.put(DeletePlanBranchSettings.Config.INACTIVE_DAYS, deletePlanBranch.getRemoveInactiveInRepositoryPeriod().toDays());
                } else {
                    deleteConfig.put(DeletePlanBranchSettings.Config.INACTIVE_DAYS, DeletePlanBranchSettings.Config.DISABLED);
                }
                branchConfig.put(BranchManagementConfiguration.Config.DELETE, deleteConfig);
            }
        }
        if ((branchIntegrationProperties = managementProperties.getBranchIntegrationProperties()) != null && branchIntegrationProperties.isEnabled()) {
            HashMap<String, Object> integrationConfig = new HashMap<String, Object>();
            if (branchIntegrationProperties.isGatekeeper()) {
                integrationConfig.put(BranchIntegrationSettings.Config.MERGE_TO, this.getBranchNameForIntegration(planProperties, branchIntegrationProperties));
            } else {
                integrationConfig.put(BranchIntegrationSettings.Config.MERGE_FROM, this.getBranchNameForIntegration(planProperties, branchIntegrationProperties));
            }
            integrationConfig.put(BranchIntegrationSettings.Config.PUSH, branchIntegrationProperties.isPushOn());
            branchConfig.put(BranchManagementConfiguration.Config.INTEGRATION, integrationConfig);
        }
        branchConfig.put(BranchManagementConfiguration.Config.LINK_TO_JIRA, managementProperties.isIssueLinkingEnabled());
        return branchConfig;
    }

    private String getBranchNameForIntegration(@NotNull PlanProperties planProperties, @NotNull BranchIntegrationProperties branchIntegrationProperties) throws CodeGenerationException {
        PlanBranchIdentifierProperties integrationBranch = branchIntegrationProperties.getIntegrationBranch();
        if (integrationBranch == null) {
            return planProperties.getName();
        }
        BambooOidProperties integrationBranchOid = integrationBranch.getOid();
        if (integrationBranchOid != null && integrationBranchOid.getOid().equals(planProperties.getOid().getOid())) {
            return planProperties.getName();
        }
        if (integrationBranch.isKeyDefined() && Objects.equals(planProperties.getKey(), integrationBranch.getKey())) {
            return planProperties.getName();
        }
        ImmutablePlan plan = this.cachedPlanManager.getPlanByKey(PlanKeys.getPlanKey((String)planProperties.getProject().getKey().getKey(), (String)integrationBranch.getKey().getKey()));
        if (plan != null) {
            return plan.getBuildName();
        }
        throw new CodeGenerationException("Integration branch not found");
    }

    private Map<String, Object> dumpPlanInfo(PlanProperties planProperties) {
        LinkedHashMap<String, Object> planInfo = new LinkedHashMap<String, Object>();
        planInfo.put(Plan.Config.PROJECT_KEY, planProperties.getProject().getKey().getKey());
        planInfo.put(Plan.Config.KEY, planProperties.getKey().getKey());
        planInfo.put(Plan.Config.NAME, planProperties.getName());
        if (!planProperties.getRepositoryBranches().isEmpty()) {
            String defaultRepositoryName = StringUtils.defaultString((String)((PlanRepositoryLinkProperties)planProperties.getRepositories().get(0)).getRepositoryDefinition().getParentName());
            planProperties.getRepositoryBranches().stream().filter(vrbp -> defaultRepositoryName.equals(vrbp.getRepositoryName())).findFirst().ifPresent(branchProperties -> {
                if (Objects.equals(branchProperties.getBranchName(), branchProperties.getBranchDisplayName()) || StringUtils.isBlank((CharSequence)branchProperties.getBranchDisplayName())) {
                    planInfo.put(Plan.Config.BRANCH, branchProperties.getBranchName());
                } else {
                    planInfo.put(Plan.Config.BRANCH, ImmutableMap.of((Object)MasterBranch.Config.NAME, (Object)branchProperties.getBranchName(), (Object)MasterBranch.Config.DISPLAY_NAME, (Object)branchProperties.getBranchDisplayName()));
                }
            });
        }
        return planInfo;
    }

    private List<Object> dumpStages(List<StageProperties> stageProperties) {
        return stageProperties.stream().map(stage -> {
            LinkedHashMap<String, Object> stageDataMap = new LinkedHashMap<String, Object>();
            stageDataMap.put(Stage.Config.MANUAL, stage.isManual());
            stageDataMap.put(Stage.Config.FINAL, stage.isFinalStage());
            List jobNames = stage.getJobs().stream().map(AbstractPlanProperties::getName).collect(Collectors.toList());
            stageDataMap.put(Stage.Config.JOBS, jobNames);
            LinkedHashMap<String, LinkedHashMap<String, Object>> stageMap = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
            stageMap.put(stage.getName(), stageDataMap);
            return stageMap;
        }).collect(Collectors.toList());
    }

    private void dumpJobs(Map<String, Object> data, List<StageProperties> stageProperties, EmitterContext context) {
        stageProperties.stream().flatMap(stage -> stage.getJobs().stream()).forEach(jobProperties -> {
            LinkedHashMap<String, Object> jobData = new LinkedHashMap<String, Object>();
            jobData.put(Job.Config.KEY, jobProperties.getKey().getKey());
            this.dumpOtherConfig((Map<String, Object>)jobData, (JobProperties)jobProperties);
            if (jobProperties.getDockerConfiguration().isEnabled()) {
                jobData.put(Job.Config.DOCKER, this.dumpDocker(jobProperties.getDockerConfiguration()));
            }
            if (!jobProperties.getTasks().isEmpty()) {
                jobData.put(Job.Config.TASKS, this.dumpTasks(jobProperties.getTasks(), context, false));
            }
            this.addWarningIfCheckoutTaskIsNotDefined((JobProperties)jobProperties, (Map<String, Object>)jobData, context);
            if (!jobProperties.getFinalTasks().isEmpty()) {
                jobData.put(Job.Config.FINAL_TASKS, this.dumpTasks(jobProperties.getFinalTasks(), context, true));
            }
            if (!jobProperties.getArtifacts().isEmpty()) {
                jobData.put(Job.Config.ARTIFACTS, this.parseArtifacts(jobProperties.getArtifacts()));
            }
            if (!jobProperties.getRequirements().isEmpty()) {
                jobData.put(Job.Config.REQUIREMENTS, this.dumpRequirements(jobProperties.getRequirements()));
            }
            data.put(jobProperties.getName(), jobData);
        });
    }

    private void addWarningIfCheckoutTaskIsNotDefined(JobProperties jobProperties, Map<String, Object> jobData, EmitterContext context) {
        boolean taskExists = Stream.concat(jobProperties.getTasks().stream(), jobProperties.getFinalTasks().stream()).anyMatch(task -> task instanceof VcsCheckoutTaskProperties);
        if (!taskExists) {
            Map<String, String> commentObj = YamlEmitterImpl.comment("Checkout Task will be added implicitly during Specs import");
            if (jobData.containsKey(Job.Config.TASKS)) {
                List tasks = (List)jobData.get(Job.Config.TASKS);
                tasks.add(0, commentObj);
                context.hasTasks = true;
            } else {
                jobData.putAll(commentObj);
            }
        }
    }

    private boolean containsCommentsOnly(Map<String, Object> map) {
        return map.keySet().stream().allMatch(obj -> obj.startsWith(YAML_COMMENT_PLACEHOLDER));
    }

    private Object dumpDocker(DockerConfigurationProperties dockerConfiguration) {
        LinkedHashMap<String, Object> dockerData = new LinkedHashMap<String, Object>();
        dockerData.put(Docker.Config.IMAGE, dockerConfiguration.getImage());
        dockerData.put(Docker.Config.VOLUMES, dockerConfiguration.getVolumes());
        dockerData.put(Docker.Config.ARGUMENTS, dockerConfiguration.getDockerRunArguments());
        return dockerData;
    }

    private List<Object> dumpTasks(List<TaskProperties> tasks, EmitterContext context, boolean isFinalTasks) {
        if (!tasks.isEmpty()) {
            if (isFinalTasks) {
                context.hasFinalTasks = true;
            } else {
                context.hasTasks = true;
            }
        }
        return tasks.stream().flatMap(genericTaskProperties -> {
            log.debug((Object)("Export task " + genericTaskProperties.getAtlassianPlugin().getCompleteModuleKey()));
            if (!genericTaskProperties.isEnabled()) {
                return Stream.of(YamlEmitterImpl.comment(String.format("%s is disabled. This state is not supported at YAML", genericTaskProperties.getAtlassianPlugin().getCompleteModuleKey())));
            }
            final TaskDefinitionExporter taskExporter = this.taskDefinitionExporterHelper.getExporter(genericTaskProperties.getAtlassianPlugin().getCompleteModuleKey());
            Node node = (Node)BambooPluginUtils.callUnsafeCode((BambooPluginUtils.Callable)new BambooPluginUtils.Callable<Node>("Error exporting task definition to YAML"){

                @Nullable
                public Node call() {
                    return taskExporter.toYaml(genericTaskProperties);
                }
            });
            if (node == null) {
                node = this.tryToDumpYamlByDefaultTaskExporter((TaskProperties)genericTaskProperties, taskExporter);
            }
            if (node != null) {
                Object result;
                if (isFinalTasks) {
                    context.hasKnownFinalTasks = true;
                } else {
                    context.hasKnownTasks = true;
                }
                if (!genericTaskProperties.getConditions().isEmpty()) {
                    ListNode taskConditions = this.generateTaskConditions(genericTaskProperties.getConditions());
                    node = this.appendConditions(node, taskConditions);
                }
                if ((result = YamlEmitterImpl.readProperty(node)) instanceof Collection) {
                    return ((Collection)result).stream();
                }
                return Stream.of(result);
            }
            return Stream.of(YamlEmitterImpl.comment("Task " + genericTaskProperties.getAtlassianPlugin().getCompleteModuleKey() + " is not supported yet"));
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    private Node tryToDumpYamlByDefaultTaskExporter(final TaskProperties taskProperties, final TaskDefinitionExporter taskExporter) {
        Map config;
        if (!(taskExporter instanceof DefaultTaskDefinitionExporter) && (config = (Map)BambooPluginUtils.callUnsafeCode((BambooPluginUtils.Callable)new BambooPluginUtils.Callable<Map<String, String>>("Couldn't convert task properties to task config"){

            public Map<String, String> call() {
                return taskExporter.toTaskConfiguration(Collections::emptyList, taskProperties);
            }
        })) != null) {
            AnyTask anyTask = new AnyTask(new AtlassianModule(taskProperties.getAtlassianPlugin().getCompleteModuleKey())).configuration(config);
            return new DefaultTaskDefinitionExporter().toYaml((TaskProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)anyTask));
        }
        return null;
    }

    private Node appendConditions(Node node, ListNode taskConditions) {
        if (node instanceof StringNode) {
            String nodeValue = ((StringNode)node).get();
            return new MapNode((Map)ImmutableMap.of((Object)nodeValue, (Object)ImmutableMap.of((Object)Job.Config.TASK_CONDITIONS, (Object)YamlEmitterImpl.readProperty((Node)taskConditions))), node.getValidationContext());
        }
        if (node instanceof MapNode) {
            if (((MapNode)node).getNode((String)((MapNode)node).getProperties().iterator().next()) instanceof MapNode) {
                Map task = (Map)YamlEmitterImpl.readProperty(node);
                ((Map)task.get(task.keySet().iterator().next())).put(Job.Config.TASK_CONDITIONS, YamlEmitterImpl.readProperty((Node)taskConditions));
                return new MapNode(task, node.getValidationContext());
            }
            throw new YamlSpecsValidationException("Task condition can't be added to " + node.getValidationContext() + " because 'key: value' task format is not supported. Contact plugin vendor to fix the issue.");
        }
        if (node instanceof ListNode) {
            ArrayList<Node> result = new ArrayList<Node>();
            for (Object item : ((ListNode)node).getList()) {
                Node converted = this.appendConditions((Node)item, taskConditions);
                result.add(converted);
            }
            return new ListNode(result, node.getValidationContext());
        }
        throw new UnsupportedOperationException("Unknown node type " + node);
    }

    private ListNode generateTaskConditions(@NotNull Collection<? extends ConditionProperties> conditions) {
        ArrayList<Object> yamlTaskConditions = new ArrayList<Object>();
        for (final ConditionProperties conditionProperties : conditions) {
            final TaskConditionModuleDescriptor taskCondition = (TaskConditionModuleDescriptor)Narrow.downTo((Object)this.pluginAccessor.getEnabledPluginModule(conditionProperties.getAtlassianPlugin().getCompleteModuleKey()), TaskConditionModuleDescriptor.class);
            if (taskCondition == null) continue;
            Node yamlTaskCondition = (Node)BambooPluginUtils.callUnsafeCode((BambooPluginUtils.Callable)new BambooPluginUtils.Callable<Node>("Error exporting task condition to YAML"){

                @Nullable
                public Node call() {
                    return ((TaskCondition)taskCondition.getModule()).toYaml(conditionProperties);
                }
            });
            if (yamlTaskCondition != null) {
                yamlTaskConditions.add(yamlTaskCondition);
                continue;
            }
            yamlTaskConditions.add(new MapNode(YamlEmitterImpl.comment("Condition " + conditionProperties.getAtlassianPlugin().getCompleteModuleKey() + " is not supported yet"), ValidationContext.empty()));
        }
        return new ListNode(yamlTaskConditions, ValidationContext.of((String)Job.Config.TASK_CONDITIONS));
    }

    private Object parseArtifacts(List<ArtifactProperties> artifacts) {
        return artifacts.stream().map(artifact -> {
            LinkedHashMap<String, Object> artifactData = new LinkedHashMap<String, Object>();
            artifactData.put(Artifact.Config.NAME, artifact.getName());
            if (StringUtils.isNotBlank((CharSequence)artifact.getLocation())) {
                artifactData.put(Artifact.Config.LOCATION, artifact.getLocation());
            }
            artifactData.put(Artifact.Config.PATTERN, artifact.getCopyPattern());
            artifactData.put(Artifact.Config.SHARED, artifact.isShared());
            artifactData.put(Artifact.Config.REQUIRED, artifact.isRequired());
            return artifactData;
        }).collect(Collectors.toList());
    }

    private Object dumpRequirements(List<RequirementProperties> requirements) {
        return requirements.stream().map(requirement -> {
            if (requirement.getMatchType() == Requirement.MatchType.EXISTS) {
                return requirement.getKey();
            }
            LinkedHashMap<String, String> requirementData = new LinkedHashMap<String, String>();
            requirementData.put(requirement.getKey(), requirement.getMatchValue());
            return requirementData;
        }).collect(Collectors.toList());
    }

    private void appendPluginConfigurations(Map<String, Object> otherConfig, List<PluginConfigurationProperties> pluginConfigurations) {
        pluginConfigurations.stream().map(pluginConfigurationProperties -> {
            String moduleKey = pluginConfigurationProperties.getAtlassianPlugin().getCompleteModuleKey();
            if ("com.atlassian.bamboo:#allotherplugins".equals(moduleKey)) {
                return YamlEmitterImpl.comment("Some plugin configurations are not supported by YAML Specs");
            }
            ModuleDescriptor plugin = this.pluginAccessor.getEnabledPluginModule(moduleKey);
            if (plugin == null) {
                throw new PropertiesValidationException("Plugin " + moduleKey + " is not installed or is disabled");
            }
            final ImportExportAwarePlugin importExportAwarePlugin = (ImportExportAwarePlugin)Narrow.downTo((Object)plugin.getModule(), ImportExportAwarePlugin.class);
            if (importExportAwarePlugin == null) {
                throw new PropertiesValidationException("Plugin " + moduleKey + " does not support export");
            }
            Node node = (Node)BambooPluginUtils.callUnsafeCode((BambooPluginUtils.Callable)new BambooPluginUtils.Callable<Node>("Error"){

                @Nullable
                public Node call() {
                    return importExportAwarePlugin.toYaml(pluginConfigurationProperties);
                }
            });
            if (node != null) {
                Object result = YamlEmitterImpl.readProperty(node);
                if (result instanceof Map) {
                    return (Map)result;
                }
                return YamlEmitterImpl.comment("Plugin " + moduleKey + " produced unsupported YAML data");
            }
            return YamlEmitterImpl.comment("Plugin " + moduleKey + " does not support export to YAML Specs");
        }).forEach(otherConfig::putAll);
    }

    private void dumpOtherConfig(Map<String, Object> container, @NotNull PlanProperties planProperties) {
        LinkedHashMap<String, Object> otherConfig = new LinkedHashMap<String, Object>();
        this.appendPluginConfigurations(otherConfig, planProperties.getPluginConfigurations());
        if (!otherConfig.isEmpty()) {
            if (this.containsCommentsOnly(otherConfig)) {
                container.put(YAML_COMMENT_PLACEHOLDER, otherConfig);
            } else {
                container.put(BambooYamlPlanDefinition.Config.OTHER, otherConfig);
            }
        }
    }

    private void dumpOtherConfig(Map<String, Object> container, @NotNull JobProperties jobProperties) {
        LinkedHashMap<String, Object> otherConfig = new LinkedHashMap<String, Object>();
        if (jobProperties.isCleanWorkingDirectory()) {
            otherConfig.put(Other.Config.CLEAN_WORKING_DIR, true);
        }
        this.appendPluginConfigurations(otherConfig, jobProperties.getPluginConfigurations());
        if (!otherConfig.isEmpty()) {
            if (this.containsCommentsOnly(otherConfig)) {
                container.put(YAML_COMMENT_PLACEHOLDER, otherConfig);
            } else {
                container.put(Job.Config.OTHER, otherConfig);
            }
        }
    }

    private Object dumpLabels(List<LabelProperties> labelsProperties) {
        return labelsProperties.stream().filter(lp -> !(lp instanceof EmptyLabelsListProperties)).map(LabelProperties::getName).collect(Collectors.toList());
    }

    private Map<String, String> dumpVariables(List<VariableProperties> variablesProperties) {
        return variablesProperties.stream().collect(Collectors.toMap(VariableProperties::getName, VariableProperties::getValue, (s, s2) -> s, LinkedHashMap::new));
    }

    private List<Object> dumpTriggers(List<TriggerProperties> triggers) {
        if (triggers.isEmpty()) {
            return Collections.emptyList();
        }
        return triggers.stream().map(this::dumpTrigger).map(YamlEmitterImpl::readProperty).collect(Collectors.toList());
    }

    private Node dumpTrigger(final TriggerProperties triggerProperties) {
        Node node;
        if (!triggerProperties.isEnabled()) {
            return new MapNode(YamlEmitterImpl.comment(String.format("Trigger %s is disabled. This state is not supported by YAML.", triggerProperties.getAtlassianPlugin().getCompleteModuleKey())), ValidationContext.empty());
        }
        final TriggerDefinitionExporter exporter = this.triggerDefinitionExportHelper.getExporter(triggerProperties);
        if (exporter != null && !(exporter instanceof DefaultTriggerDefinitionExporter) && (node = (Node)BambooPluginUtils.callUnsafeCode((BambooPluginUtils.Callable)new BambooPluginUtils.Callable<Node>("Error while export trigger to YAML"){

            @Nullable
            public Node call() {
                return exporter.toYaml(triggerProperties);
            }
        })) != null) {
            return node;
        }
        Map<String, String> comment = YamlEmitterImpl.comment("Trigger type " + triggerProperties + " is not supported yet");
        return new MapNode((Map)ImmutableMap.of((Object)YAML_COMMENT_PLACEHOLDER, (Object)comment.get(YAML_COMMENT_PLACEHOLDER)), ValidationContext.empty());
    }

    private Map<String, String> dumpDeploymentInfo(@NotNull DeploymentProperties deploymentProperties) {
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        data.put(DeploymentProject.Config.NAME, deploymentProperties.getName());
        PlanKey planKey = PlanKeys.getPlanKey((String)deploymentProperties.getPlan().getProjectKey().getKey(), (String)deploymentProperties.getPlan().getKey().getKey());
        data.put(DeploymentProject.Config.SOURCE_PLAN, planKey.getKey());
        return data;
    }

    private Object dumpReleaseNaming(@NotNull ReleaseNamingProperties releaseNaming) {
        boolean useSimplifiedDump;
        boolean bl = useSimplifiedDump = !releaseNaming.isAutoIncrement() && !releaseNaming.isApplicableToBranches() && releaseNaming.getVariablesToAutoIncrement().isEmpty();
        if (useSimplifiedDump) {
            return releaseNaming.getNextVersionName();
        }
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put(ReleaseNaming.Config.NAME, releaseNaming.getNextVersionName());
        data.put(ReleaseNaming.Config.APPLIES_TO_BRANCHES, releaseNaming.isApplicableToBranches());
        data.put(ReleaseNaming.Config.AUTOINCREMENT, releaseNaming.isAutoIncrement());
        data.put(ReleaseNaming.Config.AUTOINCREMENT_VARIABLES, ImmutableList.copyOf((Collection)releaseNaming.getVariablesToAutoIncrement()));
        return data;
    }

    private List<String> dumpEnvironmentList(@NotNull List<EnvironmentProperties> environments) {
        return environments.stream().map(EnvironmentProperties::getName).collect(Collectors.toList());
    }

    private Map<String, Object> dumpEnvironment(@NotNull EnvironmentProperties e, EmitterContext context) {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        if (e.getDockerConfiguration().isEnabled()) {
            data.put(Environment.Config.DOCKER, this.dumpDocker(e.getDockerConfiguration()));
        }
        data.put(Environment.Config.TRIGGERS, this.dumpTriggers(e.getTriggers()));
        data.put(Environment.Config.TASKS, this.dumpTasks(e.getTasks(), context, false));
        data.put(Environment.Config.FINAL_TASKS, this.dumpTasks(e.getFinalTasks(), context, true));
        data.put(Environment.Config.VARIABLES, this.dumpVariables(e.getVariables()));
        data.put(Environment.Config.REQUIREMENTS, this.dumpRequirements(e.getRequirements()));
        data.put(Environment.Config.NOTIFICATIONS, this.dumpNotifications(e.getNotifications()));
        this.dumpOtherConfig(data, e);
        return data;
    }

    private void dumpOtherConfig(Map<String, Object> container, @NotNull EnvironmentProperties environmentProperties) {
        LinkedHashMap<String, Object> otherConfig = new LinkedHashMap<String, Object>();
        this.appendEnvironmentPluginConfigurations(otherConfig, environmentProperties.getPluginConfigurations());
        if (!otherConfig.isEmpty()) {
            if (this.containsCommentsOnly(otherConfig)) {
                container.put(YAML_COMMENT_PLACEHOLDER, otherConfig);
            } else {
                container.put(BambooYamlPlanDefinition.Config.OTHER, otherConfig);
            }
        }
    }

    private void appendEnvironmentPluginConfigurations(Map<String, Object> otherConfig, List<EnvironmentPluginConfigurationProperties> pluginConfigurations) {
        pluginConfigurations.stream().map(pluginConfigurationProperties -> {
            String moduleKey = pluginConfigurationProperties.getAtlassianPlugin().getCompleteModuleKey();
            if (pluginConfigurationProperties instanceof AnyPluginConfigurationProperties) {
                return YamlEmitterImpl.comment("Plugin " + moduleKey + " does not support export to YAML specs");
            }
            ModuleDescriptor plugin = this.pluginAccessor.getEnabledPluginModule(moduleKey);
            if (plugin == null) {
                throw new PropertiesValidationException("Plugin " + moduleKey + " is not installed or is disabled");
            }
            final CustomEnvironmentConfigPluginModuleDescriptor importExportAwarePlugin = (CustomEnvironmentConfigPluginModuleDescriptor)Narrow.downTo((Object)plugin, CustomEnvironmentConfigPluginModuleDescriptor.class);
            if (importExportAwarePlugin == null || importExportAwarePlugin.getExporter() == null) {
                throw new PropertiesValidationException("Plugin " + moduleKey + " does not support export");
            }
            Node node = (Node)BambooPluginUtils.callUnsafeCode((BambooPluginUtils.Callable)new BambooPluginUtils.Callable<Node>("Error"){

                @Nullable
                public Node call() {
                    return importExportAwarePlugin.getExporter().toYaml(pluginConfigurationProperties);
                }
            });
            if (node != null) {
                Object result = YamlEmitterImpl.readProperty(node);
                if (result instanceof Map) {
                    return (Map)result;
                }
                return YamlEmitterImpl.comment("Plugin " + moduleKey + " produced unsupported YAML data");
            }
            return YamlEmitterImpl.comment("Plugin " + moduleKey + " does not support export to YAML specs");
        }).forEach(otherConfig::putAll);
    }

    private static class EmitterContext {
        public boolean hasTasks = false;
        public boolean hasKnownTasks = false;
        public boolean hasFinalTasks = false;
        public boolean hasKnownFinalTasks = false;

        private EmitterContext() {
        }
    }

    private static class AllDeploymentPermissions {
        private DeploymentPermissionsProperties deploymentPermissions;
        private final List<EnvironmentPermissionsProperties> environmentPermissions = new ArrayList<EnvironmentPermissionsProperties>();

        private AllDeploymentPermissions() {
        }

        public void setDeploymentPermissions(DeploymentPermissionsProperties deploymentPermissions) {
            this.deploymentPermissions = deploymentPermissions;
        }

        public void addEnvironmentPermissions(EnvironmentPermissionsProperties environmentPermissionsProperties) {
            this.environmentPermissions.add(environmentPermissionsProperties);
        }

        public DeploymentPermissionsProperties getDeploymentPermissions() {
            return this.deploymentPermissions;
        }

        public List<EnvironmentPermissionsProperties> getEnvironmentPermissions() {
            return this.environmentPermissions;
        }
    }
}

