/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.yaml;

import com.atlassian.bamboo.specs.yaml.YamlSpecsValidationException;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public enum BambooYamlVersion {
    VERSION_1("1"),
    VERSION_2("2");

    private final String version;

    private BambooYamlVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    @NotNull
    public static BambooYamlVersion fromVersion(@NotNull String version) throws YamlSpecsValidationException {
        return Arrays.stream(BambooYamlVersion.values()).filter(yamlVersion -> Objects.equals(version, yamlVersion.getVersion())).findFirst().orElseThrow(() -> new YamlSpecsValidationException("Invalid Bamboo YAML version: " + version));
    }
}

