/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.yaml;

import com.atlassian.bamboo.configuration.external.RssPermissions;
import com.atlassian.bamboo.configuration.external.RssPermissionsService;
import com.atlassian.bamboo.configuration.external.yaml.BambooYamlValidator;
import com.atlassian.bamboo.configuration.external.yaml.properties.BambooYamlDeploymentDefinition;
import com.atlassian.bamboo.configuration.external.yaml.properties.BambooYamlDeploymentPermissionsDefinition;
import com.atlassian.bamboo.configuration.external.yaml.properties.BambooYamlPlanDefinition;
import com.atlassian.bamboo.configuration.external.yaml.properties.BambooYamlPlanPermissionsDefinition;
import com.atlassian.bamboo.configuration.external.yaml.properties.branch.MasterBranch;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.Requirement;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.permissions.Permission;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.permissions.PermissionSet;
import com.atlassian.bamboo.configuration.external.yaml.properties.deployment.Environment;
import com.atlassian.bamboo.configuration.external.yaml.properties.deployment.ReleaseNaming;
import com.atlassian.bamboo.configuration.external.yaml.properties.plan.Job;
import com.atlassian.bamboo.configuration.external.yaml.properties.plan.Stage;
import com.atlassian.bamboo.crypto.instance.SecretEncryptionService;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.specs.api.builders.plan.Plan;
import com.atlassian.bamboo.specs.yaml.YamlSpecsValidationException;
import com.atlassian.bamboo.util.BambooStringUtils;
import com.atlassian.bamboo.util.PasswordMaskingUtils;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.i18n.DocumentationLinkProvider;
import com.atlassian.bamboo.validation.ValidationService;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooYamlValidatorImpl
implements BambooYamlValidator {
    @VisibleForTesting
    static final String ERROR_ANONYMOUS_USER_CAN_HAVE_ONLY_VIEW_PERMISSION = "Anonymous user can have only view permission";
    @VisibleForTesting
    static final String ERROR_WRONG_DEPLOYMENT_PERMISSION = "Deployment project doesn't support permission: %s";
    @VisibleForTesting
    static final String ERROR_WRONG_ENVIRONMENT_PERMISSION = "Environment doesn't support permission: %s";
    @VisibleForTesting
    static final String ERROR_WRONG_PLAN_PERMISSION = "Plan doesn't support permission: %s";
    private final PlanManager planManager;
    private final ProjectManager projectManager;
    private final RssPermissionsService rssPermissionsService;
    private final ValidationService validationService;
    private final SecretEncryptionService secretEncryptionService;
    private final DocumentationLinkProvider documentationLinkProvider;

    @Inject
    public BambooYamlValidatorImpl(PlanManager planManager, ProjectManager projectManager, RssPermissionsService rssPermissionsService, ValidationService validationService, SecretEncryptionService secretEncryptionService, DocumentationLinkProvider documentationLinkProvider) {
        this.planManager = planManager;
        this.projectManager = projectManager;
        this.rssPermissionsService = rssPermissionsService;
        this.validationService = validationService;
        this.secretEncryptionService = secretEncryptionService;
        this.documentationLinkProvider = documentationLinkProvider;
    }

    @Override
    public void validatePlan(@NotNull BambooYamlPlanDefinition bambooYamlDefinition, @NotNull VcsRepositoryData repository) {
        long existingPlanId;
        String projectKey = bambooYamlDefinition.getPlan().getProjectKey();
        String planKey = bambooYamlDefinition.getPlan().getKey();
        String planName = bambooYamlDefinition.getPlan().getName();
        Project project = this.projectManager.getProjectByKey(projectKey);
        if (project == null) {
            throw new YamlSpecsValidationException(String.format("Project with key %s does not exist", projectKey));
        }
        RssPermissions rssPermissions = this.rssPermissionsService.buildRssPermissions(repository);
        if (!rssPermissions.isProjectAllowed(projectKey)) {
            throw new YamlSpecsValidationException(String.format("Repository \"%s\" doesn't have access to project \"%s\" (%s)", repository.getName(), project.getName(), projectKey));
        }
        com.atlassian.bamboo.plan.Plan existingPlan = this.planManager.getPlanByKey(PlanKeys.getPlanKey((String)projectKey, (String)planKey));
        long l = existingPlanId = existingPlan != null ? existingPlan.getId() : -1L;
        if (this.planManager.isChainNameConflicting(projectKey, existingPlanId, planName)) {
            throw new YamlSpecsValidationException(String.format("Plan with name: '%s' already exists in project '%s'. Can't create a new one with same name.", planName, projectKey));
        }
        this.validateName(planName, "plan");
        bambooYamlDefinition.getStages().forEach(this::validateStage);
        bambooYamlDefinition.getVariables().forEach(this::validateVariable);
        this.validateBranch(bambooYamlDefinition.getPlan().getMasterBranch());
    }

    private void validateBranch(@Nullable MasterBranch repositoryBranch) {
        if (repositoryBranch == null) {
            return;
        }
        if (BambooStringUtils.containsShellInjectionRelatedCharacters((String)repositoryBranch.getName())) {
            throw new YamlSpecsValidationException("Branch name contains invalid characters");
        }
        if (BambooStringUtils.containsRelaxedXssRelatedCharacters((String)repositoryBranch.getDisplayName())) {
            throw new YamlSpecsValidationException("Branch display name contains invalid characters");
        }
    }

    private void validateVariable(String variableName, String variableValue) {
        if (PasswordMaskingUtils.shouldBeMasked((String)variableName) && StringUtils.isNotBlank((CharSequence)variableValue) && !this.secretEncryptionService.isEncrypted(variableValue)) {
            throw new YamlSpecsValidationException(String.format("Variable %s is a password-type variable and must be encrypted. Learn more at: %s", variableName, this.documentationLinkProvider.getUrl("specs.encryption")));
        }
    }

    @Override
    public void validatePlanPermissions(@NotNull BambooYamlPlanPermissionsDefinition planPermissionsDefinition) {
        Consumer<PermissionSet> assertAnonymousPermission = this.getAnonymousPermissionsValidator();
        planPermissionsDefinition.getPermissions().stream().filter(PermissionSet::isAnonymous).forEach(assertAnonymousPermission);
        planPermissionsDefinition.getPermissions().stream().flatMap(perm -> perm.getPermissions().stream()).filter(perm -> !perm.supports(Permission.Entity.PLAN)).findFirst().ifPresent(perm -> {
            throw new YamlSpecsValidationException(String.format(ERROR_WRONG_PLAN_PERMISSION, perm.getLabel()));
        });
    }

    @Override
    public void validateDeploymentPermissions(@NotNull BambooYamlDeploymentPermissionsDefinition deploymentPermissionsDefinition) {
        if (StringUtils.isBlank((CharSequence)deploymentPermissionsDefinition.getDeploymentProjectName())) {
            throw new YamlSpecsValidationException("deployment project name should be not empty");
        }
        this.validateAnonymousPermissions(deploymentPermissionsDefinition);
        this.validateDeploymentSupportedPermissions(deploymentPermissionsDefinition);
    }

    private void validateDeploymentSupportedPermissions(BambooYamlDeploymentPermissionsDefinition deploymentPermissionsDefinition) {
        deploymentPermissionsDefinition.getDeploymentPermissions().stream().flatMap(perm -> perm.getPermissions().stream()).filter(perm -> !perm.supports(Permission.Entity.DEPLOYMENT_PROJECT)).findFirst().ifPresent(perm -> {
            throw new YamlSpecsValidationException(String.format(ERROR_WRONG_DEPLOYMENT_PERMISSION, perm.getLabel()));
        });
        Stream.concat(deploymentPermissionsDefinition.getDefaultEnvironmentPermissions().stream(), deploymentPermissionsDefinition.getEnvironmentPermissions().stream().flatMap(env -> env.getPermissionSets().stream())).flatMap(perm1 -> perm1.getPermissions().stream()).filter(perm -> !perm.supports(Permission.Entity.ENVIRONMENT)).findFirst().ifPresent(perm -> {
            throw new YamlSpecsValidationException(String.format(ERROR_WRONG_ENVIRONMENT_PERMISSION, perm.getLabel()));
        });
    }

    private void validateAnonymousPermissions(@NotNull BambooYamlDeploymentPermissionsDefinition deploymentPermissionsDefinition) {
        Consumer<PermissionSet> assertAnonymousPermission = this.getAnonymousPermissionsValidator();
        deploymentPermissionsDefinition.getDeploymentPermissions().stream().filter(PermissionSet::isAnonymous).forEach(assertAnonymousPermission);
        deploymentPermissionsDefinition.getDefaultEnvironmentPermissions().stream().filter(PermissionSet::isAnonymous).forEach(assertAnonymousPermission);
        deploymentPermissionsDefinition.getEnvironmentPermissions().stream().flatMap(env -> env.getPermissionSets().stream()).filter(PermissionSet::isAnonymous).forEach(assertAnonymousPermission);
    }

    @NotNull
    private Consumer<PermissionSet> getAnonymousPermissionsValidator() {
        return perm -> {
            if (!perm.getPermissions().contains((Object)Permission.VIEW) || perm.getPermissions().size() != 1) {
                throw new YamlSpecsValidationException(ERROR_ANONYMOUS_USER_CAN_HAVE_ONLY_VIEW_PERMISSION);
            }
        };
    }

    @Override
    public void validateDeployment(@NotNull BambooYamlDeploymentDefinition deploymentDefinition, @NotNull List<Plan> plansInYaml) throws YamlSpecsValidationException {
        PlanKey planKey;
        try {
            planKey = PlanKeys.getPlanKey((String)deploymentDefinition.getSourcePlan());
        }
        catch (Exception e) {
            throw new YamlSpecsValidationException(e.getMessage(), (Throwable)e);
        }
        com.atlassian.bamboo.plan.Plan existingPlan = this.planManager.getPlanByKey(planKey);
        if (existingPlan == null && !this.planExistsInYamlFile(planKey, plansInYaml)) {
            throw new YamlSpecsValidationException("Plan " + planKey + " does not exist");
        }
        this.validateName(deploymentDefinition.getName(), "deployment.project");
        this.validateReleaseNaming(deploymentDefinition.getReleaseNaming());
        deploymentDefinition.getEnvironments().forEach(this::validateEnvironment);
    }

    private boolean planExistsInYamlFile(PlanKey planKey, List<Plan> plansFromYaml) {
        return plansFromYaml.stream().anyMatch(p -> {
            String projectKeyFromYaml = p.getIdentifier().getProjectKey().toString();
            String planKeyFromYaml = p.getIdentifier().getPlanKey().toString();
            PlanKey fullKeyFromYaml = PlanKeys.getPlanKey((String)projectKeyFromYaml, (String)planKeyFromYaml);
            return fullKeyFromYaml.equals((Object)planKey);
        });
    }

    private void validateReleaseNaming(@NotNull ReleaseNaming releaseNaming) {
        if (StringUtils.isBlank((CharSequence)releaseNaming.getNextVersionName())) {
            throw new YamlSpecsValidationException(ReleaseNaming.Config.NAME + " is required");
        }
    }

    private void validateStage(@NotNull Stage stage) {
        this.validateName(stage.getName(), "stage");
        stage.getJobs().forEach(this::validateJob);
    }

    private void validateJob(Job job) {
        this.validateName(job.getName(), "job");
        this.validateRequirements(job.getRequirements());
    }

    private void validateRequirements(List<Requirement> requirements) {
        requirements.forEach(req -> {
            if (req.getType() == Requirement.Type.MATCHES && StringUtils.isBlank((CharSequence)req.getValue())) {
                throw new YamlSpecsValidationException("Requirement pattern is empty for " + req.getName());
            }
        });
    }

    private void validateEnvironment(@NotNull Environment environment) {
        this.validateName(environment.getName(), "deployment.environment");
        environment.getVariables().forEach(this::validateVariable);
        this.validateRequirements(environment.getRequirements());
    }

    private void validateName(String nameValue, String prefix) {
        ErrorCollection errorCollection = this.validationService.validateName("name", prefix, nameValue);
        if (errorCollection.hasAnyErrors()) {
            throw new YamlSpecsValidationException(String.join((CharSequence)";", (Iterable)errorCollection.getFieldErrors().get("name")));
        }
    }
}

