/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.yaml;

import com.atlassian.bamboo.configuration.external.util.PropertiesValidator;
import com.atlassian.bamboo.configuration.external.yaml.BambooYamlToSpecsConverter;
import com.atlassian.bamboo.configuration.external.yaml.properties.BambooYamlDeploymentDefinition;
import com.atlassian.bamboo.configuration.external.yaml.properties.BambooYamlDeploymentPermissionsDefinition;
import com.atlassian.bamboo.configuration.external.yaml.properties.BambooYamlPlanDefinition;
import com.atlassian.bamboo.configuration.external.yaml.properties.BambooYamlPlanPermissionsDefinition;
import com.atlassian.bamboo.configuration.external.yaml.properties.branch.BranchIntegrationSettings;
import com.atlassian.bamboo.configuration.external.yaml.properties.branch.BranchManagementConfiguration;
import com.atlassian.bamboo.configuration.external.yaml.properties.branch.CreatePlanBranchSettings;
import com.atlassian.bamboo.configuration.external.yaml.properties.branch.DeletePlanBranchSettings;
import com.atlassian.bamboo.configuration.external.yaml.properties.branch.PlanBranchConfiguration;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.Docker;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.Notification;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.Requirement;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.Trigger;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.notifications.BasicNotificationEvent;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.notifications.JobErrorNotificationEvent;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.notifications.NotificationEvent;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.notifications.PlanFailedNotificationEvent;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.permissions.Permission;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.permissions.PermissionSet;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.recipients.BasicNotificationsRecipients;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.recipients.EmailNotificationRecipients;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.recipients.GroupNotificationRecipients;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.recipients.NotificationRecipients;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.recipients.PluginAwareRecipients;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.recipients.UserNotificationRecipients;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.recipients.WebhookNotificationRecipients;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.triggers.DefaultTrigger;
import com.atlassian.bamboo.configuration.external.yaml.properties.common.triggers.PluginAwareTrigger;
import com.atlassian.bamboo.configuration.external.yaml.properties.deployment.Environment;
import com.atlassian.bamboo.configuration.external.yaml.properties.plan.Artifact;
import com.atlassian.bamboo.configuration.external.yaml.properties.plan.Job;
import com.atlassian.bamboo.configuration.external.yaml.properties.plan.Other;
import com.atlassian.bamboo.configuration.external.yaml.properties.plan.Stage;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.specs.api.builders.BambooKey;
import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.Variable;
import com.atlassian.bamboo.specs.api.builders.deployment.Deployment;
import com.atlassian.bamboo.specs.api.builders.deployment.ReleaseNaming;
import com.atlassian.bamboo.specs.api.builders.deployment.configuration.EnvironmentPluginConfiguration;
import com.atlassian.bamboo.specs.api.builders.docker.DockerConfiguration;
import com.atlassian.bamboo.specs.api.builders.notification.NotificationRecipient;
import com.atlassian.bamboo.specs.api.builders.notification.NotificationType;
import com.atlassian.bamboo.specs.api.builders.permission.DeploymentPermissions;
import com.atlassian.bamboo.specs.api.builders.permission.EnvironmentPermissions;
import com.atlassian.bamboo.specs.api.builders.permission.PermissionType;
import com.atlassian.bamboo.specs.api.builders.permission.Permissions;
import com.atlassian.bamboo.specs.api.builders.permission.PlanPermissions;
import com.atlassian.bamboo.specs.api.builders.plan.Plan;
import com.atlassian.bamboo.specs.api.builders.plan.PlanBranchIdentifier;
import com.atlassian.bamboo.specs.api.builders.plan.artifact.ArtifactSubscription;
import com.atlassian.bamboo.specs.api.builders.plan.branches.BranchCleanup;
import com.atlassian.bamboo.specs.api.builders.plan.branches.BranchIntegration;
import com.atlassian.bamboo.specs.api.builders.plan.branches.PlanBranchManagement;
import com.atlassian.bamboo.specs.api.builders.plan.configuration.PluginConfiguration;
import com.atlassian.bamboo.specs.api.builders.project.Project;
import com.atlassian.bamboo.specs.api.builders.repository.VcsRepositoryBranch;
import com.atlassian.bamboo.specs.api.builders.task.Task;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryIdentifierProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.builders.notification.BuildErrorNotification;
import com.atlassian.bamboo.specs.builders.notification.CommentAddedNotification;
import com.atlassian.bamboo.specs.builders.notification.CommittersRecipient;
import com.atlassian.bamboo.specs.builders.notification.DeploymentFailedNotification;
import com.atlassian.bamboo.specs.builders.notification.DeploymentFinishedNotification;
import com.atlassian.bamboo.specs.builders.notification.DeploymentStartedAndFinishedNotification;
import com.atlassian.bamboo.specs.builders.notification.EmailRecipient;
import com.atlassian.bamboo.specs.builders.notification.FirstFailedJobNotification;
import com.atlassian.bamboo.specs.builders.notification.GroupRecipient;
import com.atlassian.bamboo.specs.builders.notification.JobCompletedNotification;
import com.atlassian.bamboo.specs.builders.notification.JobFailedNotification;
import com.atlassian.bamboo.specs.builders.notification.JobHungNotification;
import com.atlassian.bamboo.specs.builders.notification.JobStatusChangedNotification;
import com.atlassian.bamboo.specs.builders.notification.JobTimeoutNotification;
import com.atlassian.bamboo.specs.builders.notification.JobWithoutAgentNotification;
import com.atlassian.bamboo.specs.builders.notification.PlanCompletedNotification;
import com.atlassian.bamboo.specs.builders.notification.PlanFailedNotification;
import com.atlassian.bamboo.specs.builders.notification.PlanStatusChangedNotification;
import com.atlassian.bamboo.specs.builders.notification.ResponsibilityChangedNotification;
import com.atlassian.bamboo.specs.builders.notification.ResponsibleRecipient;
import com.atlassian.bamboo.specs.builders.notification.UserRecipient;
import com.atlassian.bamboo.specs.builders.notification.WatchersRecipient;
import com.atlassian.bamboo.specs.builders.notification.WebhookRecipient;
import com.atlassian.bamboo.specs.builders.notification.XFailedChainsNotification;
import com.atlassian.bamboo.specs.builders.task.CleanWorkingDirectoryTask;
import com.atlassian.bamboo.specs.builders.task.VcsCheckoutTask;
import com.atlassian.bamboo.specs.builders.trigger.BitbucketServerTrigger;
import com.atlassian.bamboo.specs.builders.trigger.RepositoryPollingTrigger;
import com.atlassian.bamboo.specs.model.task.CheckoutItemProperties;
import com.atlassian.bamboo.specs.model.task.VcsCheckoutTaskProperties;
import com.atlassian.bamboo.specs.yaml.YamlSpecsValidationException;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityHelper;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySetManager;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityType;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooYamlToSpecsConverterImpl
implements BambooYamlToSpecsConverter {
    private static final Logger log = Logger.getLogger(BambooYamlToSpecsConverterImpl.class);
    @Inject
    private CachedPlanManager cachedPlanManager;
    @Inject
    private CapabilitySetManager capabilitySetManager;
    @Inject
    private CapabilityHelper capabilityHelper;

    @Override
    @NotNull
    public Plan createPlan(@NotNull BambooYamlPlanDefinition yamlPlan, @NotNull VcsRepositoryData repository) {
        Plan specsPlan = new Plan(new Project().key(yamlPlan.getPlan().getProjectKey()), yamlPlan.getPlan().getName(), yamlPlan.getPlan().getKey());
        BambooYamlToSpecsConverterImpl.appendPlanDefaults(specsPlan, repository);
        this.appendPlanConfig(specsPlan, yamlPlan, repository);
        this.appendBranchConfig(specsPlan, yamlPlan);
        this.validateEntity((EntityPropertiesBuilder)specsPlan);
        return specsPlan;
    }

    @Override
    @NotNull
    public Deployment createDeploymentProject(@NotNull BambooYamlDeploymentDefinition deploymentDefinition, @NotNull VcsRepositoryData repository) {
        com.atlassian.bamboo.specs.api.builders.plan.PlanIdentifier planIdentifier = this.getPlanIdentifier(deploymentDefinition.getSourcePlan());
        Deployment deployment = new Deployment(planIdentifier, deploymentDefinition.getName());
        ReleaseNaming releaseNaming = new ReleaseNaming(deploymentDefinition.getReleaseNaming().getNextVersionName()).applicableToBranches(deploymentDefinition.getReleaseNaming().isAppliesToBranches()).autoIncrement(deploymentDefinition.getReleaseNaming().isAutoIncrement());
        deploymentDefinition.getReleaseNaming().getAutoIncrementVariables().forEach(xva$0 -> releaseNaming.variablesToAutoIncrement(new String[]{xva$0}));
        deployment.releaseNaming(releaseNaming);
        deploymentDefinition.getEnvironments().stream().map(this::toEnvironment).forEach(xva$0 -> deployment.environments(new com.atlassian.bamboo.specs.api.builders.deployment.Environment[]{xva$0}));
        this.validateEntity((EntityPropertiesBuilder)deployment);
        return deployment;
    }

    @NotNull
    private com.atlassian.bamboo.specs.api.builders.deployment.Environment toEnvironment(Environment environment) {
        com.atlassian.bamboo.specs.api.builders.deployment.Environment result = new com.atlassian.bamboo.specs.api.builders.deployment.Environment(environment.getName());
        environment.getTasks().forEach(xva$0 -> result.tasks(new Task[]{xva$0}));
        environment.getFinalTasks().forEach(xva$0 -> result.finalTasks(new Task[]{xva$0}));
        environment.getVariables().forEach((key, value) -> result.variables(new Variable[]{new Variable(key, value)}));
        environment.getRequirements().stream().map(this::tryToMatchRequirementByLabel).map(this::getRequirement).forEach(xva$0 -> result.requirements(new com.atlassian.bamboo.specs.api.builders.requirement.Requirement[]{xva$0}));
        environment.getTriggers().forEach(trigger -> result.triggers(new com.atlassian.bamboo.specs.api.builders.trigger.Trigger[]{BambooYamlToSpecsConverterImpl.convertYamlTrigger(trigger, null)}));
        environment.getNotifications().stream().flatMap(BambooYamlToSpecsConverterImpl::convertYamlNotification).forEach(xva$0 -> result.notifications(new com.atlassian.bamboo.specs.api.builders.notification.Notification[]{xva$0}));
        this.convertYamlDocker(environment.getDocker()).ifPresent(arg_0 -> ((com.atlassian.bamboo.specs.api.builders.deployment.Environment)result).dockerConfiguration(arg_0));
        Optional.ofNullable(environment.getOther()).ifPresent(list -> list.forEach(xva$0 -> result.pluginConfigurations(new EnvironmentPluginConfiguration[]{xva$0})));
        return result;
    }

    @Override
    @NotNull
    public PlanPermissions createPlanPermissions(@NotNull BambooYamlPlanPermissionsDefinition planPermissionsDefinition) {
        com.atlassian.bamboo.specs.api.builders.plan.PlanIdentifier planIdentifier = this.getPlanIdentifier(planPermissionsDefinition.getPlanKey());
        Permissions permissions = new Permissions();
        planPermissionsDefinition.getPermissions().forEach(perm -> this.convertPermissionSet((PermissionSet)perm, permissions));
        return new PlanPermissions(planIdentifier).permissions(permissions);
    }

    @Override
    @NotNull
    public BambooYamlToSpecsConverter.CombinedDeploymentPermissions createDeploymentPermissions(@NotNull BambooYamlDeploymentPermissionsDefinition deploymentPermissionsDefinition) {
        DeploymentPermissions projectPermissions = new DeploymentPermissions(deploymentPermissionsDefinition.getDeploymentProjectName());
        Permissions deploymentProjectPermissions = new Permissions();
        deploymentPermissionsDefinition.getDeploymentPermissions().forEach(perm -> this.convertPermissionSet((PermissionSet)perm, deploymentProjectPermissions));
        projectPermissions.permissions(deploymentProjectPermissions);
        Permissions defaultEnvironmentPermissions = new Permissions();
        if (!deploymentPermissionsDefinition.getDefaultEnvironmentPermissions().isEmpty()) {
            deploymentPermissionsDefinition.getDefaultEnvironmentPermissions().forEach(perm -> this.convertPermissionSet((PermissionSet)perm, defaultEnvironmentPermissions));
        }
        List<EnvironmentPermissions> environmentPermissions = deploymentPermissionsDefinition.getEnvironmentPermissions().stream().map(env -> {
            EnvironmentPermissions environmentPermission = new EnvironmentPermissions(deploymentPermissionsDefinition.getDeploymentProjectName(), env.getName());
            Permissions permissions = new Permissions();
            env.getPermissionSets().forEach(perm -> this.convertPermissionSet((PermissionSet)perm, permissions));
            environmentPermission.permissions(permissions);
            return environmentPermission;
        }).collect(Collectors.toList());
        return new BambooYamlToSpecsConverter.CombinedDeploymentPermissions(projectPermissions, defaultEnvironmentPermissions, environmentPermissions);
    }

    @NotNull
    private com.atlassian.bamboo.specs.api.builders.plan.PlanIdentifier getPlanIdentifier(String planKey) {
        PlanKey key = PlanKeys.getPlanKey((String)planKey);
        return new com.atlassian.bamboo.specs.api.builders.plan.PlanIdentifier(PlanKeys.getProjectKeyPart((PlanKey)key), key.getPartialKey());
    }

    private void convertPermissionSet(@NotNull PermissionSet permissionSet, @NotNull Permissions permissions) {
        PermissionType[] permissionTypes = this.getPermissionTypes(permissionSet.getPermissions());
        permissionSet.getUsers().forEach(user -> permissions.userPermissions(user, permissionTypes));
        permissionSet.getGroups().forEach(user -> permissions.groupPermissions(user, permissionTypes));
        if (permissionSet.isAnonymous()) {
            permissions.anonymousUserPermissionView();
        }
        if (permissionSet.isLoggedIn()) {
            permissions.loggedInUserPermissions(permissionTypes);
        }
    }

    @NotNull
    private PermissionType[] getPermissionTypes(@NotNull Collection<Permission> permissions) {
        return (PermissionType[])permissions.stream().map(perm -> {
            switch (perm) {
                case VIEW: {
                    return PermissionType.VIEW;
                }
                case EDIT: {
                    return PermissionType.EDIT;
                }
                case BUILD: 
                case DEPLOY: {
                    return PermissionType.BUILD;
                }
                case CLONE: {
                    return PermissionType.CLONE;
                }
                case ADMIN: {
                    return PermissionType.ADMIN;
                }
            }
            throw new IllegalArgumentException("Can't handle permission: " + (Object)perm);
        }).toArray(PermissionType[]::new);
    }

    @VisibleForTesting
    static void appendPlanDefaults(@NotNull Plan specsPlan, @NotNull VcsRepositoryData repositoryData) {
        specsPlan.linkedRepositories(new String[]{repositoryData.getName()});
    }

    @VisibleForTesting
    static void appendDefaultPlanTriggers(@NotNull Plan specsPlan, @NotNull VcsRepositoryData repositoryData) {
        specsPlan.triggers(new com.atlassian.bamboo.specs.api.builders.trigger.Trigger[]{BambooYamlToSpecsConverterImpl.convertYamlTrigger(new DefaultTrigger(), repositoryData)});
    }

    @VisibleForTesting
    static void appendDefaultPlanNotifications(@NotNull Plan specsPlan) {
        Stream.of(Notification.createDefaultNotification()).flatMap(BambooYamlToSpecsConverterImpl::convertYamlNotification).forEach(xva$0 -> specsPlan.notifications(new com.atlassian.bamboo.specs.api.builders.notification.Notification[]{xva$0}));
    }

    private void appendPlanConfig(@NotNull Plan specsPlan, @NotNull BambooYamlPlanDefinition yamlPlan, @NotNull VcsRepositoryData repositoryData) {
        List<Notification> notifications = yamlPlan.getNotifications();
        if (notifications.isEmpty()) {
            specsPlan.noNotifications();
        } else {
            notifications.stream().flatMap(BambooYamlToSpecsConverterImpl::convertYamlNotification).forEach(xva$0 -> specsPlan.notifications(new com.atlassian.bamboo.specs.api.builders.notification.Notification[]{xva$0}));
        }
        yamlPlan.getTriggers().stream().map(yamlTrigger -> BambooYamlToSpecsConverterImpl.convertYamlTrigger(yamlTrigger, repositoryData)).forEach(xva$0 -> specsPlan.triggers(new com.atlassian.bamboo.specs.api.builders.trigger.Trigger[]{xva$0}));
        yamlPlan.getVariables().forEach((name, value) -> specsPlan.variables(new Variable[]{new Variable(name, value)}));
        List<String> labels = yamlPlan.getLabels();
        if (labels != null) {
            if (labels.isEmpty()) {
                specsPlan.noLabels();
            } else {
                labels.forEach(xva$0 -> specsPlan.labels(new String[]{xva$0}));
            }
        }
        LinkedHashSet<String> repositories = new LinkedHashSet<String>();
        repositories.add(repositoryData.getName());
        this.appendPlanStructure(specsPlan, yamlPlan, repositoryData, repositories);
        repositories.remove(repositoryData.getName());
        specsPlan.linkedRepositories(repositories.toArray(new String[0]));
        specsPlan.planBranchManagement(this.convertYamlBranchConfiguration(yamlPlan.getBranchManagementConfiguration(), specsPlan.getIdentifier()));
        List<PluginConfiguration> pluginConfigurations = yamlPlan.getOther();
        if (pluginConfigurations == null || pluginConfigurations.isEmpty()) {
            specsPlan.noPluginConfigurations();
        } else {
            pluginConfigurations.forEach(xva$0 -> specsPlan.pluginConfigurations(new PluginConfiguration[]{xva$0}));
        }
        if (yamlPlan.getPlan().getMasterBranch() != null) {
            specsPlan.repositoryBranches(new VcsRepositoryBranch[]{new VcsRepositoryBranch(repositoryData.getName(), yamlPlan.getPlan().getMasterBranch().getName()).branchDisplayName(yamlPlan.getPlan().getMasterBranch().getDisplayName())});
        }
    }

    private void appendPlanStructure(@NotNull Plan specsPlan, @NotNull BambooYamlPlanDefinition yamlPlan, @NotNull VcsRepositoryData repositoryData, @NotNull Set<String> repositories) {
        ArrayList allSharedArtifacts = new ArrayList();
        for (Stage yamlStage : yamlPlan.getStages()) {
            com.atlassian.bamboo.specs.api.builders.plan.Stage specsStage = new com.atlassian.bamboo.specs.api.builders.plan.Stage(yamlStage.getName()).finalStage(yamlStage.isFinal()).manual(yamlStage.isManual());
            ArrayList previousStagesSharedArtifacts = new ArrayList(allSharedArtifacts);
            for (Job yamlJob : yamlStage.getJobs()) {
                com.atlassian.bamboo.specs.api.builders.plan.Job specsJob = new com.atlassian.bamboo.specs.api.builders.plan.Job(yamlJob.getName(), yamlJob.getKey());
                previousStagesSharedArtifacts.stream().map(artifactName -> new ArtifactSubscription().artifact(artifactName)).forEach(xva$0 -> specsJob.artifactSubscriptions(new ArtifactSubscription[]{xva$0}));
                yamlJob.getArtifacts().stream().peek(yamlArtifact -> Optional.of(yamlArtifact).filter(Artifact::isShared).map(Artifact::getName).ifPresent(allSharedArtifacts::add)).map(yamlArtifact -> new com.atlassian.bamboo.specs.api.builders.plan.artifact.Artifact(yamlArtifact.getName()).location(Optional.ofNullable(yamlArtifact.getLocation()).orElse("")).copyPattern(yamlArtifact.getPattern()).shared(yamlArtifact.isShared()).required(yamlArtifact.isRequired())).forEach(xva$0 -> specsJob.artifacts(new com.atlassian.bamboo.specs.api.builders.plan.artifact.Artifact[]{xva$0}));
                yamlJob.getRequirements().stream().map(this::tryToMatchRequirementByLabel).map(this::getRequirement).forEach(xva$0 -> specsJob.requirements(new com.atlassian.bamboo.specs.api.builders.requirement.Requirement[]{xva$0}));
                boolean skipFirstTask = this.addFirstTaskIfRequired(yamlJob, specsJob);
                Consumer<Task> checkoutTaskConsumer = task -> {
                    if (task instanceof VcsCheckoutTask) {
                        VcsCheckoutTask checkoutTask = (VcsCheckoutTask)task;
                        VcsCheckoutTaskProperties properties = (VcsCheckoutTaskProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)checkoutTask);
                        CheckoutItemProperties checkoutItem = (CheckoutItemProperties)properties.getCheckoutItems().get(0);
                        String repositoryName = checkoutItem.isDefaultRepository() ? repositoryData.getName() : Optional.ofNullable(checkoutItem.getRepository()).map(VcsRepositoryIdentifierProperties::getName).orElse(repositoryData.getName());
                        repositories.add(repositoryName);
                    }
                };
                yamlJob.getTasks().stream().skip(skipFirstTask ? 1L : 0L).peek(checkoutTaskConsumer).forEach(xva$0 -> specsJob.tasks(new Task[]{xva$0}));
                yamlJob.getFinalTasks().stream().peek(checkoutTaskConsumer).forEach(xva$0 -> specsJob.finalTasks(new Task[]{xva$0}));
                this.convertYamlDocker(Optional.ofNullable(yamlJob.getDocker()).orElseGet(yamlPlan::getDocker)).ifPresent(arg_0 -> ((com.atlassian.bamboo.specs.api.builders.plan.Job)specsJob).dockerConfiguration(arg_0));
                Optional<Other> otherOptional = Optional.ofNullable(yamlJob.getOther());
                specsJob.cleanWorkingDirectory(otherOptional.map(Other::isCleanWorkingDir).orElse(false).booleanValue());
                if (otherOptional.isPresent() && !otherOptional.get().getPluginConfigurations().isEmpty()) {
                    for (PluginConfiguration configuration : otherOptional.get().getPluginConfigurations()) {
                        specsJob.pluginConfigurations(new PluginConfiguration[]{configuration});
                    }
                } else {
                    specsJob.noPluginConfigurations();
                }
                specsStage.jobs(new com.atlassian.bamboo.specs.api.builders.plan.Job[]{specsJob});
            }
            specsPlan.stages(new com.atlassian.bamboo.specs.api.builders.plan.Stage[]{specsStage});
        }
    }

    private PlanBranchManagement convertYamlBranchConfiguration(@NotNull BranchManagementConfiguration yamlConfig, com.atlassian.bamboo.specs.api.builders.plan.PlanIdentifier currentPlan) {
        BranchIntegration integration;
        PlanBranchManagement planBranchManagement = new PlanBranchManagement().notificationLikeParentPlan();
        CreatePlanBranchSettings.Type createType = yamlConfig.getCreatePlanBranchSettings().getType();
        switch (createType) {
            case MANUAL: {
                planBranchManagement.createManually();
                break;
            }
            case BRANCH: {
                if (StringUtils.isNotBlank((CharSequence)yamlConfig.getCreatePlanBranchSettings().getBranchPattern())) {
                    planBranchManagement.createForVcsBranchMatching(yamlConfig.getCreatePlanBranchSettings().getBranchPattern());
                    break;
                }
                planBranchManagement.createForVcsBranch();
                break;
            }
            case PR: {
                planBranchManagement.createForPullRequest();
                break;
            }
            default: {
                throw new YamlSpecsValidationException("Unknown create plan branch option: " + (Object)((Object)createType));
            }
        }
        DeletePlanBranchSettings deleteSettings = yamlConfig.getDeletePlanBranchSettings();
        if (deleteSettings != null && deleteSettings.isEnabled()) {
            BranchCleanup removedBranchCleanup = new BranchCleanup();
            if (deleteSettings.getDeletedDays() == -1) {
                removedBranchCleanup.whenRemovedFromRepository(false);
            } else {
                removedBranchCleanup.whenRemovedFromRepositoryAfterDays(deleteSettings.getDeletedDays());
            }
            if (deleteSettings.getInactiveDays() == -1) {
                removedBranchCleanup.whenInactiveInRepository(false);
            } else {
                removedBranchCleanup.whenInactiveInRepositoryAfterDays(deleteSettings.getInactiveDays());
            }
            planBranchManagement.delete(removedBranchCleanup);
        }
        if ((integration = this.convertBranchIntegration(yamlConfig.getBranchIntegrationSettings(), currentPlan)) != null) {
            planBranchManagement.branchIntegration(integration);
        }
        planBranchManagement.issueLinkingEnabled(yamlConfig.isLinkToJira());
        return planBranchManagement;
    }

    private void appendBranchConfig(@NotNull Plan specsPlan, @NotNull BambooYamlPlanDefinition yamlPlan) {
        PlanBranchConfiguration yamlPlanBranchConfiguration = yamlPlan.getPlanBranchConfiguration();
        if (yamlPlanBranchConfiguration != null) {
            BranchIntegration integration;
            com.atlassian.bamboo.specs.api.builders.plan.branches.PlanBranchConfiguration planBranchConfiguration = new com.atlassian.bamboo.specs.api.builders.plan.branches.PlanBranchConfiguration();
            if (yamlPlanBranchConfiguration.isDisableAutomaticallyBranchCleanup()) {
                planBranchConfiguration.disableAutomaticCleanup();
            }
            if ((integration = this.convertBranchIntegration(yamlPlanBranchConfiguration.getBranchIntegrationSettings(), specsPlan.getIdentifier())) != null) {
                planBranchConfiguration.branchIntegration(integration);
            }
            specsPlan.branchConfiguration(planBranchConfiguration);
        }
    }

    @Nullable
    private BranchIntegration convertBranchIntegration(@Nullable BranchIntegrationSettings branchIntegrationSettings, @NotNull com.atlassian.bamboo.specs.api.builders.plan.PlanIdentifier currentPlan) {
        if (branchIntegrationSettings == null) {
            return null;
        }
        BranchIntegration integration = new BranchIntegration();
        if (branchIntegrationSettings.getStrategy() == BranchIntegrationSettings.Strategy.GATEKEEPER) {
            integration.gatekeeper(true);
        }
        PlanBranchIdentifier integrationBranch = this.findPlanBranch(currentPlan, branchIntegrationSettings.getBranch());
        integration.integrationBranch(integrationBranch);
        integration.pushOnSuccessfulBuild(branchIntegrationSettings.isPush());
        return integration;
    }

    @NotNull
    private PlanBranchIdentifier findPlanBranch(@NotNull com.atlassian.bamboo.specs.api.builders.plan.PlanIdentifier plan, @Nullable String branchName) {
        ImmutablePlan planByKey = this.cachedPlanManager.getPlanByKey(PlanKeys.getPlanKey((String)plan.getProjectKey().toString(), (String)plan.getPlanKey().toString()));
        PlanKey integrationPlanBranchKey = null;
        if (planByKey != null) {
            if (StringUtils.isBlank((CharSequence)branchName)) {
                return new PlanBranchIdentifier(new BambooKey(plan.getPlanKey().toString()));
            }
            integrationPlanBranchKey = this.cachedPlanManager.getBranchesOfChain((planByKey = (ImmutablePlan)ObjectUtils.firstNonNull((Object[])new ImmutablePlan[]{planByKey.getMaster(), planByKey})).getPlanKey()).filter(planBranch -> Objects.equals(planBranch.getBuildName(), branchName)).findFirst().map(PlanIdentifier::getPlanKey).orElse(null);
            if (integrationPlanBranchKey == null) {
                integrationPlanBranchKey = this.cachedPlanManager.getBranchesOfChain(planByKey.getPlanKey()).filter(planBranch -> {
                    VcsBranchDefinition branch = ((PlanRepositoryDefinition)planBranch.getPlanRepositoryDefinitions().get(0)).getBranch();
                    return branch != null && Objects.equals(branch.getVcsBranch().getName(), branchName);
                }).findFirst().map(PlanIdentifier::getPlanKey).orElse(null);
            }
        }
        if (integrationPlanBranchKey != null) {
            return new PlanBranchIdentifier(new BambooKey(integrationPlanBranchKey.getPartialKey()));
        }
        return new PlanBranchIdentifier(new BambooKey(plan.getPlanKey().toString()));
    }

    private boolean addFirstTaskIfRequired(Job yamlJob, com.atlassian.bamboo.specs.api.builders.plan.Job specsJob) {
        boolean hasCheckoutTask = Stream.concat(yamlJob.getTasks().stream(), yamlJob.getFinalTasks().stream()).anyMatch(task -> task instanceof VcsCheckoutTask);
        if (hasCheckoutTask) {
            return false;
        }
        boolean cleanTaskFirst = !yamlJob.getTasks().isEmpty() && yamlJob.getTasks().get(0) instanceof CleanWorkingDirectoryTask;
        VcsCheckoutTask vcsCheckoutTask = new VcsCheckoutTask().addCheckoutOfDefaultRepository().cleanCheckout(cleanTaskFirst);
        specsJob.tasks(new Task[]{vcsCheckoutTask});
        return cleanTaskFirst;
    }

    @NotNull
    private com.atlassian.bamboo.specs.api.builders.requirement.Requirement getRequirement(Requirement requirement) {
        switch (requirement.getType()) {
            case EXISTS: {
                return com.atlassian.bamboo.specs.api.builders.requirement.Requirement.exists((String)requirement.getName());
            }
            case MATCHES: {
                return com.atlassian.bamboo.specs.api.builders.requirement.Requirement.matches((String)requirement.getName(), (String)requirement.getValue());
            }
        }
        throw new YamlSpecsValidationException("Unknown requirement type" + requirement);
    }

    @VisibleForTesting
    @NotNull
    Requirement tryToMatchRequirementByLabel(@NotNull Requirement requirement) throws YamlSpecsValidationException {
        List uniqueCapabilityKeys = this.capabilitySetManager.findUniqueCapabilityKeys();
        if (uniqueCapabilityKeys.contains(requirement.getName())) {
            return requirement;
        }
        List matchingCapabilityKeys = uniqueCapabilityKeys.stream().filter(key -> {
            CapabilityType capabilityType = this.capabilityHelper.getCapabilityTypeFromKey(key);
            String label = capabilityType.getLabel(key);
            return label.equals(requirement.getName());
        }).collect(Collectors.toList());
        if (matchingCapabilityKeys.isEmpty()) {
            log.info((Object)("Didn't find capability for " + requirement + " requirement."));
            return requirement;
        }
        if (matchingCapabilityKeys.size() == 1) {
            String matchedKey = (String)matchingCapabilityKeys.get(0);
            log.debug((Object)("Found " + matchedKey + " capability with " + requirement + " label. Return it"));
            return new Requirement(matchedKey, requirement.getValue(), requirement.getType());
        }
        String errorMessage = "Found " + matchingCapabilityKeys.size() + " capabilities by '" + requirement + "' label. Provide unique label or use exact key. Possible keys with same label: " + String.join((CharSequence)",", matchingCapabilityKeys);
        throw new YamlSpecsValidationException(errorMessage);
    }

    private static com.atlassian.bamboo.specs.api.builders.trigger.Trigger<?, ?> convertYamlTrigger(Trigger yamlTrigger, @Nullable VcsRepositoryData repositoryData) {
        if (yamlTrigger instanceof PluginAwareTrigger) {
            return ((PluginAwareTrigger)yamlTrigger).getTrigger();
        }
        if (yamlTrigger instanceof DefaultTrigger && repositoryData != null) {
            return "com.atlassian.bamboo.plugins.stash.atlassian-bamboo-plugin-stash:bbserver".equals(repositoryData.getPluginKey()) ? new BitbucketServerTrigger() : new RepositoryPollingTrigger();
        }
        throw new YamlSpecsValidationException("Unknown type of trigger: " + yamlTrigger.getClass());
    }

    @NotNull
    private static Stream<com.atlassian.bamboo.specs.api.builders.notification.Notification> convertYamlNotification(@NotNull Notification yamlNotification) {
        List notificationRecipients = yamlNotification.getNotificationRecipients().stream().flatMap(BambooYamlToSpecsConverterImpl::convertYamlRecipients).collect(Collectors.toList());
        return yamlNotification.getNotificationEvents().stream().map(notificationEvent -> {
            com.atlassian.bamboo.specs.api.builders.notification.Notification notification = new com.atlassian.bamboo.specs.api.builders.notification.Notification().type(BambooYamlToSpecsConverterImpl.convertYamlNotificationType(notificationEvent));
            notificationRecipients.forEach(xva$0 -> notification.recipients(new NotificationRecipient[]{xva$0}));
            return notification;
        });
    }

    @NotNull
    private static NotificationType<?, ?> convertYamlNotificationType(@NotNull NotificationEvent notificationEvent) {
        if (notificationEvent instanceof BasicNotificationEvent) {
            NotificationEvent.NotificationEventType eventType = ((BasicNotificationEvent)notificationEvent).getEventType();
            switch (eventType) {
                case DEPLOYMENT_FAILED: {
                    return new DeploymentFailedNotification();
                }
                case DEPLOYMENT_FINISHED: {
                    return new DeploymentFinishedNotification();
                }
                case DEPLOYMENT_STARTED_AND_FINISHED: {
                    return new DeploymentStartedAndFinishedNotification();
                }
                case PLAN_COMPLETED: {
                    return new PlanCompletedNotification();
                }
                case PLAN_STATUS_CHANGED: {
                    return new PlanStatusChangedNotification();
                }
                case PLAN_FAILED: {
                    return new PlanFailedNotification();
                }
                case PLAN_COMMENT_ADDED: {
                    return new CommentAddedNotification();
                }
                case PLAN_RESPONSIBILITY_CHANGED: {
                    return new ResponsibilityChangedNotification();
                }
                case JOB_COMPLETED: {
                    return new JobCompletedNotification();
                }
                case JOB_STATUS_CHANGED: {
                    return new JobStatusChangedNotification();
                }
                case JOB_FAILED: {
                    return new JobFailedNotification();
                }
                case JOB_FIRST_FAILED: {
                    return new FirstFailedJobNotification();
                }
                case JOB_ERROR: {
                    return new BuildErrorNotification().sendForFirstOccurrenceOnly();
                }
                case JOB_HUNG: {
                    return new JobHungNotification();
                }
                case JOB_QUEUE_TIMEOUT: {
                    return new JobTimeoutNotification();
                }
                case JOB_QUEUED_WITHOUT_CAPABLE_AGENTS: {
                    return new JobWithoutAgentNotification();
                }
            }
            throw new YamlSpecsValidationException("Unknown type of notification event: " + (Object)((Object)eventType));
        }
        if (notificationEvent instanceof PlanFailedNotificationEvent) {
            int failures = ((PlanFailedNotificationEvent)notificationEvent).getFailures();
            if (failures > 1) {
                return new XFailedChainsNotification().numberOfFailures(failures);
            }
            return new PlanFailedNotification();
        }
        if (notificationEvent instanceof JobErrorNotificationEvent) {
            if (((JobErrorNotificationEvent)notificationEvent).isFirstOnly()) {
                return new BuildErrorNotification().sendForFirstOccurrenceOnly();
            }
            return new BuildErrorNotification();
        }
        throw new YamlSpecsValidationException("Unknown type of notification event: " + notificationEvent.getClass());
    }

    @NotNull
    private static Stream<NotificationRecipient<?, ?>> convertYamlRecipients(@NotNull NotificationRecipients notificationRecipients) {
        if (notificationRecipients instanceof UserNotificationRecipients) {
            return ((UserNotificationRecipients)notificationRecipients).getUsers().stream().map(UserRecipient::new);
        }
        if (notificationRecipients instanceof GroupNotificationRecipients) {
            return ((GroupNotificationRecipients)notificationRecipients).getGroups().stream().map(GroupRecipient::new);
        }
        if (notificationRecipients instanceof EmailNotificationRecipients) {
            return ((EmailNotificationRecipients)notificationRecipients).getEmails().stream().map(EmailRecipient::new);
        }
        if (notificationRecipients instanceof BasicNotificationsRecipients) {
            NotificationRecipients.NotificationRecipientType recipientType = ((BasicNotificationsRecipients)notificationRecipients).getRecipientType();
            switch (recipientType) {
                case RESPONSIBLE: {
                    return Stream.of(new ResponsibleRecipient());
                }
                case COMMITTERS: {
                    return Stream.of(new CommittersRecipient());
                }
                case WATCHERS: {
                    return Stream.of(new WatchersRecipient());
                }
            }
            throw new YamlSpecsValidationException("Unknown type of notification recipient: " + (Object)((Object)recipientType));
        }
        if (notificationRecipients instanceof WebhookNotificationRecipients) {
            WebhookNotificationRecipients webhookNotificationRecipients = (WebhookNotificationRecipients)notificationRecipients;
            return Stream.of(new WebhookRecipient(webhookNotificationRecipients.getWebhookName(), webhookNotificationRecipients.getUrl()));
        }
        if (notificationRecipients instanceof PluginAwareRecipients) {
            return Stream.of(((PluginAwareRecipients)notificationRecipients).getRecipient());
        }
        throw new YamlSpecsValidationException("Unknown type of notification recipients: " + notificationRecipients.getClass());
    }

    @NotNull
    private Optional<DockerConfiguration> convertYamlDocker(Docker yamlDocker) {
        if (yamlDocker != null) {
            DockerConfiguration dockerConfiguration = new DockerConfiguration().enabled(true).image(yamlDocker.getImage());
            yamlDocker.getVolumes().forEach((arg_0, arg_1) -> ((DockerConfiguration)dockerConfiguration).volume(arg_0, arg_1));
            if (!yamlDocker.isUseDefaultVolumes()) {
                dockerConfiguration.withoutDefaultVolumes();
            }
            yamlDocker.getDockerRunArguments().forEach(xva$0 -> dockerConfiguration.dockerRunArguments(new String[]{xva$0}));
            return Optional.of(dockerConfiguration);
        }
        return Optional.empty();
    }

    private void validateEntity(EntityPropertiesBuilder builder) {
        try {
            PropertiesValidator.validate(EntityPropertiesBuilders.build((EntityPropertiesBuilder)builder));
        }
        catch (PropertiesValidationException e) {
            throw new YamlSpecsValidationException((Throwable)e);
        }
    }
}

